/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.AbstractListModel;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerKey;

public class ServerList
extends AbstractListModel<Server> {
    private static final long serialVersionUID = 1L;
    public static final String KEY = "YlKMdJocN6eNNlCY";
    private List<Server> serverList = new ArrayList<Server>();

    public static ServerList readServerList(File file) {
        ServerList serverList = new ServerList();
        Collection<Server> addedServers = ServerList.readServerCollection(file);
        serverList.serverList.addAll(addedServers);
        return serverList;
    }

    private static Collection<Server> readServerCollection(File jsonFile) {
        try {
            return ServerList.readServerCollection(new FileReader(jsonFile));
        }
        catch (IOException ex) {
            Logger.getLogger(ServerList.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Server>();
        }
    }

    private static Collection<Server> readServerCollection(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            Collection result;
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Server.class, (json, typeOfT, context) -> {
                JsonObject jsonObject = json.getAsJsonObject();
                Server server = new Server();
                JsonElement usernameElement = jsonObject.get("username");
                server.setUsername(usernameElement != null ? usernameElement.getAsString() : null);
                server.setUrl(jsonObject.get("url").getAsString());
                SecretKeySpec key = new SecretKeySpec(KEY.getBytes(), "AES");
                try {
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    cipher.init(2, key);
                    JsonElement passwordElement = jsonObject.get("password");
                    String password = passwordElement != null ? new String(cipher.doFinal(Base64.getDecoder().decode(passwordElement.getAsString())), "UTF-8") : null;
                    server.setPassword(password);
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (NoSuchPaddingException e) {
                    e.printStackTrace();
                }
                catch (IllegalBlockSizeException e) {
                    e.printStackTrace();
                }
                catch (BadPaddingException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                return server;
            });
            Gson gson = builder.create();
            Type collectionType = new TypeToken<Collection<Server>>(){}.getType();
            Collection collection = result = (Collection)gson.fromJson((Reader)br, collectionType);
            return collection;
        }
    }

    public void writeServerList(File file) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Server.class, (server, type, context) -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("username", server.getUsername());
            obj.addProperty("url", server.getUrl());
            if (server.getPassword() != null) {
                SecretKeySpec key = new SecretKeySpec(KEY.getBytes(), "AES");
                try {
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    cipher.init(1, key);
                    obj.addProperty("password", Base64.getEncoder().encodeToString(cipher.doFinal(server.getPassword().getBytes("UTF-8"))));
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (NoSuchPaddingException e) {
                    e.printStackTrace();
                }
                catch (IllegalBlockSizeException e) {
                    e.printStackTrace();
                }
                catch (BadPaddingException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return obj;
        });
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        String json = gson.toJson(this.serverList);
        try {
            Files.write((CharSequence)json, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Stream<Server> stream() {
        return this.serverList.stream();
    }

    public void delete(Server server) {
        if (!this.serverList.contains(server)) {
            throw new IllegalArgumentException("The server to be deleted must exist in the list.");
        }
        int indexOfDeletedServer = this.serverList.indexOf(server);
        this.serverList.remove(server);
        this.fireIntervalRemoved(server, indexOfDeletedServer, indexOfDeletedServer);
    }

    public void add(Server server) throws Exception {
        if (this.serverList.contains(server)) {
            throw new Exception("A server with that name already exists.");
        }
        this.serverList.add(server);
        int indexOfAddedServer = this.serverList.indexOf(server);
        this.fireContentsChanged(this, indexOfAddedServer, indexOfAddedServer);
    }

    public Server getServer(ServerKey serverKey) {
        List result = this.serverList.stream().filter(server -> serverKey.equals(new ServerKey(server.getUsername(), server.getUrl()))).collect(Collectors.toList());
        return result.size() == 1 ? (Server)result.get(0) : null;
    }

    @Override
    public int getSize() {
        return this.serverList.size();
    }

    @Override
    public Server getElementAt(int index) {
        return this.serverList.get(index);
    }
}

