/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import java.io.IOException;
import java.util.UUID;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.NdexStatus;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class Server {
    public static final Server DEFAULT_SERVER = Server.getDefaultServer();
    private String url;
    private String username;
    private String password;
    private UUID userId;

    private static final Server getDefaultServer() {
        Server server = new Server();
        server.url = "http://public.ndexbio.org/v2";
        return server;
    }

    public Server() {
    }

    public Server(Server s) {
        this.url = s.url;
        this.username = s.username;
        this.password = s.password;
        this.userId = s.getUserId();
    }

    public boolean isRunningNdexServer(NdexRestClientModelAccessLayer mal) {
        try {
            NdexStatus ndexStatus = mal.getServerStatus();
            return ndexStatus != null;
        }
        catch (IOException | NdexException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean check(NdexRestClientModelAccessLayer mal) throws IOException {
        boolean passwordPresent;
        boolean usernamePresent = this.username != null && !this.username.isEmpty();
        boolean bl = passwordPresent = this.password != null && !this.password.isEmpty();
        if (!usernamePresent && !passwordPresent) {
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof Server) {
            boolean sameUrl;
            Server b = (Server)o;
            boolean bl = this.url == null ? b.url == null : (sameUrl = this.url.equals(b.url));
            boolean sameUser = this.username == null ? b.username == null : this.username.equals(b.username);
            return sameUrl && sameUser;
        }
        return false;
    }

    public NdexRestClientModelAccessLayer getModelAccessLayer() throws IOException, NdexException {
        String apiUrl = this.url;
        NdexRestClient client = new NdexRestClient(this.username, this.password, apiUrl, UserAgentUtil.getUserAgent());
        return new NdexRestClientModelAccessLayer(client);
    }

    public String toString() {
        return this.username + "@" + this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username != null && username.trim().equals("") ? null : username;
    }

    public void setPassword(String password) {
        this.password = password != null && password.trim().equals("") ? null : password;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }
}

