/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import java.util.Properties;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.property.CyProperty;

public class CxPreferences {
    public static final String VIEW_THRESHOLD = "viewThreshold";
    private static final int DEF_VIEW_THRESHOLD = 200000;
    public static final String CREATE_VIEW_PROPERTY = "cx.createView";
    public static final String APPLY_LAYOUT_PROPERTY = "cx.applyLayout";
    public static final String LARGE_LAYOUT_THRESHOLD_PROPERTY = "cx.largeLayoutThreshold";
    public static final int DEF_LARGE_LAYOUT_THRESHOLD = 25000;

    public static int getViewThreshold() {
        return CxPreferences.getIntegerProperty(VIEW_THRESHOLD, 200000);
    }

    public static void setViewThreshold(int viewThreshold) {
        CxPreferences.setProperty(VIEW_THRESHOLD, Integer.toString(viewThreshold));
    }

    public static CreateViewEnum getCreateView() {
        String property = CxPreferences.getProperty(CREATE_VIEW_PROPERTY);
        System.out.println("CREATE_VIEW_PROPERTY=" + property);
        return CreateViewEnum.ALWAYS.toString().toLowerCase().equals(property) ? CreateViewEnum.ALWAYS : (CreateViewEnum.NEVER.toString().toLowerCase().equals(property) ? CreateViewEnum.NEVER : CreateViewEnum.AUTO);
    }

    public static void setCreateView(CreateViewEnum createView) {
        CxPreferences.setProperty(CREATE_VIEW_PROPERTY, createView.toString().toLowerCase());
    }

    public static ApplyLayoutEnum getApplyLayout() {
        String property = CxPreferences.getProperty(APPLY_LAYOUT_PROPERTY);
        return ApplyLayoutEnum.NEVER.toString().toLowerCase().equals(property) ? ApplyLayoutEnum.NEVER : ApplyLayoutEnum.AUTO;
    }

    public static void setApplyLayout(ApplyLayoutEnum applyLayout) {
        CxPreferences.setProperty(APPLY_LAYOUT_PROPERTY, applyLayout.toString().toLowerCase());
    }

    public static Integer getLargeLayoutThreshold() {
        return CxPreferences.getIntegerProperty(LARGE_LAYOUT_THRESHOLD_PROPERTY, 25000);
    }

    public static void setLargeLayoutThreshold(int largeLayoutThreshold) {
        CxPreferences.setProperty(LARGE_LAYOUT_THRESHOLD_PROPERTY, Integer.toString(largeLayoutThreshold));
    }

    private static String getProperty(String key) {
        Properties props = (Properties)CyServiceModule.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)").getProperties();
        return props.getProperty(key);
    }

    private static Object setProperty(String key, String property) {
        Properties props = (Properties)CyServiceModule.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)").getProperties();
        return props.setProperty(key, property);
    }

    private static Integer getIntegerProperty(String key, Integer defaultValue) {
        String property = CxPreferences.getProperty(key);
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static enum ApplyLayoutEnum {
        AUTO("Auto", "Apply a layout for smaller networks only"),
        NEVER("Never", "Never apply a layout, regardless of network size");

        private final String displayName;
        private final String description;

        private ApplyLayoutEnum(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String toString() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum CreateViewEnum {
        ALWAYS("Always", "Always create a view, regardless of network size"),
        AUTO("Auto", "Create views for smaller networks only"),
        NEVER("Never", "Never create views, regardless of network size");

        private final String displayName;
        private final String description;

        private CreateViewEnum(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String toString() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

