/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cyndex2.external.SaveParameters;
import org.cytoscape.cyndex2.internal.task.OpenDialogTaskFactory;
import org.cytoscape.cyndex2.internal.util.ExternalAppManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.task.RootNetworkCollectionTaskFactory;
import org.cytoscape.work.TaskIterator;

public class OpenSaveCollectionTaskFactory
extends OpenDialogTaskFactory
implements RootNetworkCollectionTaskFactory {
    private final CyApplicationManager appManager;

    public OpenSaveCollectionTaskFactory(CyApplicationManager appManager) {
        super("save");
        this.appManager = appManager;
    }

    @Override
    public TaskIterator createTaskIterator() {
        CyNetwork net = this.appManager.getCurrentNetwork();
        if (net == null) {
            return null;
        }
        CyRootNetwork root = ((CySubNetwork)net).getRootNetwork();
        return this.createTaskIterator(root);
    }

    @Override
    public boolean isReady() {
        if (ExternalAppManager.loadFailed()) {
            return false;
        }
        return this.appManager.getCurrentNetwork() != null;
    }

    public TaskIterator createTaskIterator(Collection<CyRootNetwork> roots) {
        if (roots.isEmpty()) {
            return null;
        }
        return this.createTaskIterator(roots.iterator().next());
    }

    public boolean isReady(Collection<CyRootNetwork> roots) {
        return !ExternalAppManager.loadFailed() && roots.size() == 1;
    }

    private TaskIterator createTaskIterator(CyRootNetwork root) {
        SaveParameters.INSTANCE.suid = root.getSUID();
        SaveParameters.INSTANCE.saveType = "collection";
        return super.createTaskIterator();
    }
}

