/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExBasicSaveParameters;
import org.cytoscape.cyndex2.internal.util.NDExNetworkManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class NetworkExportTask
extends AbstractTask
implements ObservableTask {
    private final InputStream cxStream;
    private final NDExBasicSaveParameters params;
    private final Long suid;
    private final boolean isUpdate;
    private final NdexRestClientModelAccessLayer mal;
    private final boolean writeCollection;
    private UUID networkUUID = null;

    public NetworkExportTask(NdexRestClientModelAccessLayer mal, Long suid, InputStream cxStream, NDExBasicSaveParameters params, boolean writeCollection, boolean isUpdate) throws JsonProcessingException, IOException, NdexException {
        this.params = params;
        this.writeCollection = writeCollection;
        this.isUpdate = isUpdate;
        this.cxStream = cxStream;
        this.suid = suid;
        this.mal = mal;
    }

    public void cancel() {
        super.cancel();
        try {
            this.cxStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run(TaskMonitor taskMonitor) throws NetworkExportException, InvocationTargetException, InterruptedException, IOException {
        String uploadName;
        this.networkUUID = null;
        taskMonitor.setTitle("Exporting CX network to NDEx...");
        CyNetworkManager net_manager = CyServiceModule.getService(CyNetworkManager.class);
        CyNetwork network = net_manager.getNetwork(this.suid.longValue());
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        String collectionName = (String)rootNetwork.getRow((CyIdentifiable)rootNetwork).get("name", String.class);
        String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        String string = this.params.metadata != null && this.params.metadata.containsKey("name") ? this.params.metadata.get("name") : (uploadName = this.writeCollection ? collectionName : networkName);
        if (this.writeCollection) {
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("name", (Object)uploadName);
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("shared name", (Object)uploadName);
        } else {
            network.getRow((CyIdentifiable)network).set("name", (Object)uploadName);
            network.getRow((CyIdentifiable)network).set("shared name", (Object)uploadName);
        }
        try {
            CyRootNetwork referenceNetwork;
            if (this.cancelled) {
                return;
            }
            taskMonitor.setProgress(0.5);
            taskMonitor.setStatusMessage("Uploading network to NDEx");
            Object object = referenceNetwork = this.writeCollection ? rootNetwork : network;
            if (!this.isUpdate) {
                this.networkUUID = this.mal.createCXNetwork(this.cxStream);
                NetworkSummary networkSummary = this.mal.getNetworkSummaryById(this.networkUUID);
                NDExNetworkManager.saveUUID((CyNetwork)referenceNetwork, this.networkUUID, networkSummary.getModificationTime());
            } else {
                this.networkUUID = NDExNetworkManager.getUUID((CyNetwork)referenceNetwork);
                if (this.networkUUID == null) {
                    throw new NetworkUpdateException("No UUID found for " + network);
                }
                this.mal.updateCXNetwork(this.networkUUID, this.cxStream);
                NetworkSummary networkSummary = this.mal.getNetworkSummaryById(this.networkUUID);
                NDExNetworkManager.updateModificationTimeStamp((CyNetwork)referenceNetwork, networkSummary.getModificationTime());
            }
        }
        catch (NetworkUpdateException e) {
            e.printStackTrace();
            throw new NetworkExportException("Only networks imported from CyNDEx2 can be updated. Error: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NetworkExportException("Failed to create CX stream for network. Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NetworkExportException("An error occurred loading the network to NDEx. Error: " + e.getMessage());
        }
        finally {
            if (this.cancelled) {
                return;
            }
        }
        if (this.networkUUID == null) {
            throw new NetworkExportException("There was a problem exporting the network! No UUID found.");
        }
        taskMonitor.setProgress(0.9);
        taskMonitor.setStatusMessage("Saving changes to network in Cytoscape");
        taskMonitor.setProgress(1.0);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (this.networkUUID == null) {
            return null;
        }
        if (type.equals(String.class)) {
            return (R)this.networkUUID.toString();
        }
        return null;
    }

    public UUID getUUID() {
        return this.networkUUID;
    }

    public class NetworkUpdateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NetworkUpdateException(String message) {
            super(message);
        }
    }

    public class NetworkExportException
    extends RuntimeException {
        private static final long serialVersionUID = -4168495871463038598L;

        public NetworkExportException(String message) {
            super(message);
        }
    }
}

