/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UploadUtil {
    private static final String LINE_FEED = "\r\n";
    private final String boundary;
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public UploadUtil(String requestURL, String charset, String authenticationString) throws IOException {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("Authorization", authenticationString);
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFormJson(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED).append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, InputStream cxStream) throws IOException {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = cxStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        cxStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    public List<String> finish() throws IOException {
        BufferedReader reader;
        ArrayList<String> response = new ArrayList<String>();
        this.writer.append(LINE_FEED).flush();
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        if (status == 200 || status == 201) {
            reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.add(line);
            }
        } else {
            if (status == 204) {
                this.httpConn.disconnect();
                return null;
            }
            this.httpConn.disconnect();
            throw new IOException("Server returned non-OK status: " + status + ".  Response message from server: " + this.httpConn.getResponseMessage());
        }
        reader.close();
        this.httpConn.disconnect();
        return response;
    }
}

