/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdexClient {
    private static final Logger logger = LoggerFactory.getLogger(NdexClient.class);
    private static final String PUBLIC_NDEX_URL = "http://www.ndexbio.org/v2";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ErrorBuilder errorBuilder;

    public NdexClient(ErrorBuilder errorBuilder) {
        this.errorBuilder = errorBuilder;
    }

    private final String getAuth(String id, String pw) {
        String credentials = id + ":" + pw;
        return "Basic " + new String(new Base64().encode(credentials.getBytes()));
    }

    private final CloseableHttpClient getClient(String id, String pw) {
        if (id == null || id.isEmpty() || pw == null || pw.isEmpty()) {
            return HttpClients.custom().build();
        }
        BasicHeader header = new BasicHeader("Authorization", this.getAuth(id, pw));
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(header);
        return HttpClients.custom().setDefaultHeaders(headers).build();
    }

    public Map<String, ?> getSummary(String url, String uuid) throws Exception {
        return this.getSummary(url, uuid, null, null);
    }

    public Map<String, ?> getSummary(String url, String uuid, String userId, String pw) throws WebApplicationException {
        String serverUrl = null;
        serverUrl = url == null || url.isEmpty() ? "http://www.ndexbio.org/v2/network/" + uuid + "/summary" : url + "/network/" + uuid + "/summary";
        CloseableHttpClient client = this.getClient(userId, pw);
        HttpGet httpget = new HttpGet(serverUrl);
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpget);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not get network summary from NDEx.", ErrorType.NDEX_API);
        }
        this.getError(response);
        Map result = null;
        try {
            String val = EntityUtils.toString((HttpEntity)response.getEntity());
            result = (Map)this.mapper.readValue(val, Map.class);
            response.close();
            client.close();
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not build network summary object.", ErrorType.INTERNAL);
        }
        return result;
    }

    private final void getError(CloseableHttpResponse response) throws WebApplicationException {
        int code = response.getStatusLine().getStatusCode();
        if (code == Response.Status.NOT_FOUND.getStatusCode()) {
            throw this.errorBuilder.buildException(Response.Status.NOT_FOUND, "Resource not found", ErrorType.INVALID_PARAMETERS);
        }
        if (code == Response.Status.UNAUTHORIZED.getStatusCode()) {
            throw this.errorBuilder.buildException(Response.Status.UNAUTHORIZED, "Autholization failed", ErrorType.AUTH_FAILED);
        }
        if (code == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Remote service call failed.", ErrorType.INTERNAL);
        }
    }

    public void setVisibility(String url, String uuid, boolean isPublic, String id, String pw) {
        String endpoint = url + "/network/" + uuid + "/systemproperty";
        String visibility = isPublic ? "PUBLIC" : "PRIVATE";
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("visibility", visibility);
        CloseableHttpClient client = this.getClient(id, pw);
        HttpPut httpput = new HttpPut(endpoint);
        String props = null;
        try {
            props = this.mapper.writeValueAsString(propMap);
        }
        catch (JsonProcessingException e1) {
            String message = "Given parameters are invalid";
            logger.error("Given parameters are invalid", (Throwable)e1);
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, "Given parameters are invalid", ErrorType.INTERNAL);
        }
        StringEntity params = new StringEntity(props, "UTF-8");
        params.setContentType("application/json");
        httpput.setEntity((HttpEntity)params);
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpput);
        }
        catch (Exception e) {
            String message = "Could not update visibility.";
            logger.error("Could not update visibility.", (Throwable)e);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not update visibility.", ErrorType.NDEX_API);
        }
        this.getError(response);
    }
}

