/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CytoscapeJsStyleConverter {
    private final Map<VisualProperty<?>, CytoscapeJsToken> vp2tag = new HashMap();
    private final Map<CytoscapeJsToken, VisualProperty<?>> tag2nodeVp = new HashMap();
    private final Map<CytoscapeJsToken, VisualProperty<?>> tag2edgeVp = new HashMap();

    public CytoscapeJsStyleConverter() {
        this.buildV2TMap();
        this.buildT2VMap();
    }

    private final void buildV2TMap() {
        this.vp2tag.put(BasicVisualLexicon.NODE_BORDER_PAINT, CytoscapeJsToken.BORDER_COLOR);
        this.vp2tag.put(BasicVisualLexicon.NODE_BORDER_TRANSPARENCY, CytoscapeJsToken.BORDER_OPACITY);
        this.vp2tag.put(BasicVisualLexicon.NODE_BORDER_WIDTH, CytoscapeJsToken.BORDER_WIDTH);
        this.vp2tag.put(BasicVisualLexicon.NODE_FILL_COLOR, CytoscapeJsToken.BACKGROUND_COLOR);
        this.vp2tag.put(BasicVisualLexicon.NODE_TRANSPARENCY, CytoscapeJsToken.BACKGROUND_OPACITY);
        this.vp2tag.put(BasicVisualLexicon.NODE_LABEL, CytoscapeJsToken.CONTENT);
        this.vp2tag.put(BasicVisualLexicon.NODE_LABEL_COLOR, CytoscapeJsToken.COLOR);
        this.vp2tag.put(BasicVisualLexicon.NODE_LABEL_FONT_SIZE, CytoscapeJsToken.FONT_SIZE);
        this.vp2tag.put(BasicVisualLexicon.NODE_LABEL_FONT_FACE, CytoscapeJsToken.FONT_FAMILY);
        this.vp2tag.put(BasicVisualLexicon.NODE_LABEL_TRANSPARENCY, CytoscapeJsToken.TEXT_OPACITY);
        this.vp2tag.put(BasicVisualLexicon.NODE_SHAPE, CytoscapeJsToken.SHAPE);
        this.vp2tag.put(BasicVisualLexicon.NODE_HEIGHT, CytoscapeJsToken.HEIGHT);
        this.vp2tag.put(BasicVisualLexicon.NODE_WIDTH, CytoscapeJsToken.WIDTH);
        this.vp2tag.put(BasicVisualLexicon.NODE_SELECTED_PAINT, CytoscapeJsToken.BACKGROUND_COLOR);
        this.vp2tag.put(BasicVisualLexicon.EDGE_WIDTH, CytoscapeJsToken.WIDTH);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LABEL, CytoscapeJsToken.CONTENT);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LABEL_FONT_SIZE, CytoscapeJsToken.FONT_SIZE);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LABEL_FONT_FACE, CytoscapeJsToken.FONT_FAMILY);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LABEL_COLOR, CytoscapeJsToken.COLOR);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY, CytoscapeJsToken.TEXT_OPACITY);
        this.vp2tag.put(BasicVisualLexicon.EDGE_LINE_TYPE, CytoscapeJsToken.LINE_STYLE);
        this.vp2tag.put(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, CytoscapeJsToken.LINE_COLOR);
        this.vp2tag.put(BasicVisualLexicon.EDGE_TRANSPARENCY, CytoscapeJsToken.OPACITY);
        this.vp2tag.put(BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE, CytoscapeJsToken.SOURCE_ARROW_SHAPE);
        this.vp2tag.put(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE, CytoscapeJsToken.TARGET_ARROW_SHAPE);
        this.vp2tag.put(BasicVisualLexicon.EDGE_SELECTED_PAINT, CytoscapeJsToken.LINE_COLOR);
    }

    private final void buildT2VMap() {
        this.tag2nodeVp.put(CytoscapeJsToken.COLOR, BasicVisualLexicon.NODE_LABEL_COLOR);
        this.tag2nodeVp.put(CytoscapeJsToken.BACKGROUND_COLOR, BasicVisualLexicon.NODE_PAINT);
        this.tag2nodeVp.put(CytoscapeJsToken.WIDTH, BasicVisualLexicon.NODE_WIDTH);
        this.tag2nodeVp.put(CytoscapeJsToken.HEIGHT, BasicVisualLexicon.NODE_HEIGHT);
        this.tag2nodeVp.put(CytoscapeJsToken.SHAPE, BasicVisualLexicon.NODE_SHAPE);
        this.tag2nodeVp.put(CytoscapeJsToken.VISIBLE, BasicVisualLexicon.NODE_VISIBLE);
        this.tag2nodeVp.put(CytoscapeJsToken.SELECTED, BasicVisualLexicon.NODE_SELECTED);
        this.tag2nodeVp.put(CytoscapeJsToken.POSITION_X, BasicVisualLexicon.NODE_X_LOCATION);
        this.tag2nodeVp.put(CytoscapeJsToken.POSITION_Y, BasicVisualLexicon.NODE_Y_LOCATION);
        this.tag2nodeVp.put(CytoscapeJsToken.CONTENT, BasicVisualLexicon.NODE_LABEL);
        this.tag2nodeVp.put(CytoscapeJsToken.BORDER_WIDTH, BasicVisualLexicon.NODE_BORDER_WIDTH);
        this.tag2nodeVp.put(CytoscapeJsToken.BORDER_COLOR, BasicVisualLexicon.NODE_BORDER_PAINT);
        this.tag2nodeVp.put(CytoscapeJsToken.OPACITY, BasicVisualLexicon.NODE_TRANSPARENCY);
        this.tag2nodeVp.put(CytoscapeJsToken.BACKGROUND_OPACITY, BasicVisualLexicon.NODE_TRANSPARENCY);
        this.tag2nodeVp.put(CytoscapeJsToken.BORDER_OPACITY, BasicVisualLexicon.NODE_BORDER_TRANSPARENCY);
        this.tag2nodeVp.put(CytoscapeJsToken.TEXT_OPACITY, BasicVisualLexicon.NODE_LABEL_TRANSPARENCY);
        this.tag2nodeVp.put(CytoscapeJsToken.FONT_SIZE, BasicVisualLexicon.NODE_LABEL_FONT_SIZE);
        this.tag2edgeVp.put(CytoscapeJsToken.COLOR, BasicVisualLexicon.EDGE_LABEL_COLOR);
        this.tag2edgeVp.put(CytoscapeJsToken.LINE_COLOR, BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        this.tag2edgeVp.put(CytoscapeJsToken.VISIBILITY, BasicVisualLexicon.EDGE_VISIBLE);
        this.tag2edgeVp.put(CytoscapeJsToken.SELECTED, BasicVisualLexicon.EDGE_SELECTED);
        this.tag2edgeVp.put(CytoscapeJsToken.WIDTH, BasicVisualLexicon.EDGE_WIDTH);
        this.tag2edgeVp.put(CytoscapeJsToken.CONTENT, BasicVisualLexicon.EDGE_LABEL);
        this.tag2edgeVp.put(CytoscapeJsToken.LINE_STYLE, BasicVisualLexicon.EDGE_LINE_TYPE);
        this.tag2edgeVp.put(CytoscapeJsToken.FONT_SIZE, BasicVisualLexicon.EDGE_LABEL_FONT_SIZE);
        this.tag2edgeVp.put(CytoscapeJsToken.TEXT_OPACITY, BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY);
        this.tag2edgeVp.put(CytoscapeJsToken.OPACITY, BasicVisualLexicon.EDGE_TRANSPARENCY);
        this.tag2edgeVp.put(CytoscapeJsToken.SOURCE_ARROW_SHAPE, BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE);
        this.tag2edgeVp.put(CytoscapeJsToken.TARGET_ARROW_SHAPE, BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
    }

    public <T extends CyIdentifiable> VisualProperty<?> getVisualProperty(CytoscapeJsToken tag, Class<T> type) {
        if (type == CyNode.class) {
            return this.tag2nodeVp.get((Object)tag);
        }
        return this.tag2edgeVp.get((Object)tag);
    }

    public CytoscapeJsToken getTag(VisualProperty<?> vp) {
        if (vp.getIdString().equals("EDGE_TARGET_ARROW_UNSELECTED_PAINT")) {
            return CytoscapeJsToken.TARGET_ARROW_COLOR;
        }
        if (vp.getIdString().equals("EDGE_SOURCE_ARROW_UNSELECTED_PAINT")) {
            return CytoscapeJsToken.SOURCE_ARROW_COLOR;
        }
        if (vp.getIdString().equals("NODE_LABEL_POSITION")) {
            return CytoscapeJsToken.TEXT_VALIGN;
        }
        return this.vp2tag.get(vp);
    }
}

