/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.CyVersion;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.internal.write.json.CytoscapeJsVisualStyleWriter;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsVisualStyleModule;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualStyle;

public class CytoscapeJsVisualStyleWriterFactory
implements CyWriterFactory,
VizmapWriterFactory {
    private final CyFileFilter filter;
    private final CyVersion cyVersion;
    private final CyServiceRegistrar serviceRegistrar;

    public CytoscapeJsVisualStyleWriterFactory(CyFileFilter filter, CyVersion cyVersion, CyServiceRegistrar serviceRegistrar) {
        this.filter = filter;
        this.cyVersion = cyVersion;
        this.serviceRegistrar = serviceRegistrar;
    }

    public CyFileFilter getFileFilter() {
        return this.filter;
    }

    public CyWriter createWriter(OutputStream os, Set<VisualStyle> styles) {
        RenderingEngine engine = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentRenderingEngine();
        VisualLexicon lexicon = engine != null ? engine.getVisualLexicon() : ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getDefaultVisualLexicon();
        ObjectMapper cytoscapeJsMapper = new ObjectMapper();
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        cytoscapeJsMapper.registerModule((Module)new CytoscapeJsVisualStyleModule(lexicon, this.cyVersion, viewManager));
        return new CytoscapeJsVisualStyleWriter(os, cytoscapeJsMapper, styles, lexicon);
    }
}

