/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.io.internal.write.json.EncodingUtil;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsStyleConverter;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CytoscapeJsVisualStyleWriter
extends AbstractTask
implements CyWriter {
    private final OutputStream os;
    private final Set<VisualStyle> styles;
    private final ObjectMapper visualStyles2jsonMapper;
    private final VisualLexicon lexicon;
    private final CytoscapeJsStyleConverter converter;

    public CytoscapeJsVisualStyleWriter(OutputStream os, ObjectMapper visualStyles2jsonMapper, Set<VisualStyle> styles, VisualLexicon lexicon) {
        this.os = os;
        this.styles = styles;
        this.visualStyles2jsonMapper = visualStyles2jsonMapper;
        this.lexicon = lexicon;
        this.converter = new CytoscapeJsStyleConverter();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Converting Cytoscape 3 Visual Styles into Cytoscape.js CSS Objects...");
        taskMonitor.setProgress(0.0);
        this.visualStyles2jsonMapper.writeValue((Writer)new OutputStreamWriter(this.os, EncodingUtil.getEncoder()), this.styles);
        this.displayMessage(taskMonitor);
    }

    private final void displayMessage(TaskMonitor taskMonitor) {
        CytoscapeJsToken tag;
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "The following Visual Properties are not supported in this version.");
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "For these Visual Properties, default values will be used:");
        Collection nodeVPs = this.lexicon.getAllDescendants(BasicVisualLexicon.NODE);
        Collection edgeVPs = this.lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
        TreeSet<String> valueSet = new TreeSet<String>();
        for (VisualProperty vp : nodeVPs) {
            tag = this.converter.getTag(vp);
            if (tag != null) continue;
            valueSet.add(vp.getDisplayName());
        }
        for (VisualProperty vp : edgeVPs) {
            tag = this.converter.getTag(vp);
            if (tag != null) continue;
            valueSet.add(vp.getDisplayName());
        }
        for (String vpText : valueSet) {
            taskMonitor.showMessage(TaskMonitor.Level.INFO, vpText);
        }
        taskMonitor.setProgress(100.0);
        taskMonitor.setTitle("Some incompatible Visual Properties were not converted.");
    }
}

