/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.CyVersion;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.read.json.CytoscapeJsNetworkReaderFactory;
import org.cytoscape.io.internal.write.json.CytoscapeJsNetworkWriterFactory;
import org.cytoscape.io.internal.write.json.CytoscapeJsVisualStyleWriterFactory;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsNetworkModule;
import org.cytoscape.io.internal.write.websession.WebSessionWriterFactoryImpl;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyApplicationConfiguration appConfig = (CyApplicationConfiguration)this.getService(bc, CyApplicationConfiguration.class);
        CyVersion cyVersion = (CyVersion)this.getService(bc, CyVersion.class);
        StreamUtil streamUtil = (StreamUtil)this.getService(bc, StreamUtil.class);
        CyNetworkFactory cyNetworkFactory = (CyNetworkFactory)this.getService(bc, CyNetworkFactory.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CyNetworkManager cyNetworkManager = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        CyRootNetworkManager cyRootNetworkManager = (CyRootNetworkManager)this.getService(bc, CyRootNetworkManager.class);
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        VisualMappingManager vmm = (VisualMappingManager)this.getService(bc, VisualMappingManager.class);
        BasicCyFileFilter cytoscapejsReaderFilter = new BasicCyFileFilter(new String[]{"cyjs", "json"}, new String[]{"application/json"}, "Cytoscape.js JSON", DataCategory.NETWORK, streamUtil);
        CytoscapeJsNetworkReaderFactory jsReaderFactory = new CytoscapeJsNetworkReaderFactory((CyFileFilter)cytoscapejsReaderFilter, applicationManager, cyNetworkFactory, cyNetworkManager, cyRootNetworkManager);
        Properties cytoscapeJsNetworkReaderFactoryProps = new Properties();
        cytoscapeJsNetworkReaderFactoryProps.put("id", "cytoscapejsNetworkReaderFactory");
        this.registerService(bc, (Object)jsReaderFactory, InputStreamTaskFactory.class, cytoscapeJsNetworkReaderFactoryProps);
        ObjectMapper cytoscapeJsMapper = new ObjectMapper();
        cytoscapeJsMapper.registerModule((Module)new CytoscapeJsNetworkModule(cyVersion));
        BasicCyFileFilter cytoscapejsFilter = new BasicCyFileFilter(new String[]{"cyjs"}, new String[]{"application/json"}, "Cytoscape.js JSON", DataCategory.NETWORK, streamUtil);
        BasicCyFileFilter vizmapJsonFilter = new BasicCyFileFilter(new String[]{"json"}, new String[]{"application/json"}, "Style for cytoscape.js", DataCategory.VIZMAP, streamUtil);
        CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory = new CytoscapeJsNetworkWriterFactory((CyFileFilter)cytoscapejsFilter, cytoscapeJsMapper);
        Properties jsWriterFactoryProperties = new Properties();
        jsWriterFactoryProperties.put("id", "cytoscapejsNetworkWriterFactory");
        this.registerAllServices(bc, cytoscapejsWriterFactory, jsWriterFactoryProperties);
        CytoscapeJsVisualStyleWriterFactory jsonVSWriterFactory = new CytoscapeJsVisualStyleWriterFactory((CyFileFilter)vizmapJsonFilter, cyVersion, serviceRegistrar);
        Properties jsVisualStyleWriterFactoryProperties = new Properties();
        jsVisualStyleWriterFactoryProperties.put("id", "cytoscapejsVisualStyleWriterFactory");
        this.registerAllServices(bc, jsonVSWriterFactory, jsVisualStyleWriterFactoryProperties);
        BasicCyFileFilter webSessionFilter = new BasicCyFileFilter(new String[]{"zip"}, new String[]{"application/zip"}, "Zip archive file (.zip)", DataCategory.ARCHIVE, streamUtil);
        WebSessionWriterFactoryImpl webSessionWriterFactory = new WebSessionWriterFactoryImpl(jsonVSWriterFactory, vmm, cytoscapejsWriterFactory, viewManager, (CyFileFilter)webSessionFilter, appConfig, applicationManager, "full");
        Properties webSessionWriterFactoryProps = new Properties();
        webSessionWriterFactoryProps.put("id", "fullWebSessionWriterFactory");
        this.registerAllServices(bc, webSessionWriterFactory, webSessionWriterFactoryProps);
        WebSessionWriterFactoryImpl simpleWebSessionWriterFactory = new WebSessionWriterFactoryImpl(jsonVSWriterFactory, vmm, cytoscapejsWriterFactory, viewManager, (CyFileFilter)webSessionFilter, appConfig, applicationManager, "simple");
        Properties simpleWebSessionWriterFactoryProps = new Properties();
        simpleWebSessionWriterFactoryProps.put("id", "simpleWebSessionWriterFactory");
        this.registerAllServices(bc, simpleWebSessionWriterFactory, simpleWebSessionWriterFactoryProps);
        WebSessionWriterFactoryImpl zippedJsonWriterFactory = new WebSessionWriterFactoryImpl(jsonVSWriterFactory, vmm, cytoscapejsWriterFactory, viewManager, (CyFileFilter)webSessionFilter, appConfig, applicationManager, "zip");
        Properties zippedJsonWriterFactoryProps = new Properties();
        zippedJsonWriterFactoryProps.put("id", "zippedJsonWriterFactory");
        this.registerAllServices(bc, zippedJsonWriterFactory, zippedJsonWriterFactoryProps);
    }
}

