/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.cytoscape.tableimport.internal.ui.PreviewTablePanel;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;

public final class TypeUtil {
    public static final String DEFAULT_INTERACTION = "interacts with";
    private static final List<SourceColumnSemantic> TABLE_IMPORT_TYPES = Arrays.asList(SourceColumnSemantic.NONE, SourceColumnSemantic.KEY, SourceColumnSemantic.ATTR);
    private static final List<SourceColumnSemantic> NETWORK_IMPORT_TYPES = Arrays.asList(SourceColumnSemantic.NONE, SourceColumnSemantic.SOURCE, SourceColumnSemantic.INTERACTION, SourceColumnSemantic.TARGET, SourceColumnSemantic.EDGE_ATTR, SourceColumnSemantic.SOURCE_ATTR, SourceColumnSemantic.TARGET_ATTR);
    private static final List<SourceColumnSemantic> ONTOLOGY_IMPORT_TYPES = Arrays.asList(SourceColumnSemantic.NONE, SourceColumnSemantic.KEY, SourceColumnSemantic.ALIAS, SourceColumnSemantic.ONTOLOGY, SourceColumnSemantic.TAXON, SourceColumnSemantic.ATTR);
    private static final List<String> NAMESPACES = Arrays.asList("LOCAL_ATTRS", "USER");
    private static final String[] PREF_KEY_NAMES = new String[]{"shared name", "name", "identifier", "id", "key", "names", "identifiers", "ids", "keys", "node", "node id", "node key", "edge", "edge id", "edge key", "nodes", "node ids", "node keys", "edges", "edge ids", "edge keys", "gene", "gene id", "gene name", "protein", "genes", "gene ids", "gene names", "proteins"};
    private static final String[] PREF_SOURCE_NAMES = new String[]{"source", "source node", "source name", "source id", "source identifier", "node 1", "node a", "identifier 1", "identifier a", "id 1", "id a", "key 1", "key a", "source shared name", "name 1", "name a", "shared name 1", "shared name a", "source gene", "gene 1", "gene1", "gene a", "genea", "gene id 1", "gene name 1", "id interactor a", "name", "shared name", "node", "gene", "gene id", "gene name", "id", "identifier"};
    private static final String[] PREF_TARGET_NAMES = new String[]{"target", "target node", "target name", "target id", "target identifier", "node 2", "node b", "identifier 2", "identifier b", "id 2", "id b", "key 2", "key b", "target shared name", "name 2", "name b", "shared name 2", "shared name b", "target gene", "gene 2", "gene2", "gene b", "geneb", "gene id 2", "gene name 2", "id interactor b"};
    private static final String[] PREF_INTERACTION_NAMES = new String[]{"interaction", "interaction type", "interaction types", "edge type", "edge types", "interaction id", "interaction identifier", "type", "evidence"};
    private static final String[] PREF_ONTOLOGY_NAMES = new String[]{"gene ontology", "ontology", "go"};
    private static final String[] PREF_TAXON_NAMES = new String[]{"taxon", "tax id", "taxonomy", "organism"};
    private static Pattern truePattern = Pattern.compile("^true$", 2);
    private static Pattern falsePattern = Pattern.compile("^false$", 2);
    private static String preferredNamespace = "USER";

    private TypeUtil() {
    }

    public static List<SourceColumnSemantic> getAvailableTypes(ImportType importType) {
        if (importType == ImportType.NETWORK_IMPORT) {
            return NETWORK_IMPORT_TYPES;
        }
        if (importType == ImportType.ONTOLOGY_IMPORT) {
            return ONTOLOGY_IMPORT_TYPES;
        }
        return TABLE_IMPORT_TYPES;
    }

    public static List<String> getAvailableNamespaces(ImportType importType) {
        return importType == ImportType.NETWORK_IMPORT ? NAMESPACES : Collections.emptyList();
    }

    public static SourceColumnSemantic getDefaultType(ImportType importType) {
        return importType == ImportType.NETWORK_IMPORT ? SourceColumnSemantic.EDGE_ATTR : SourceColumnSemantic.ATTR;
    }

    public static SourceColumnSemantic[] guessTypes(ImportType importType, TableModel model, AttributeDataType[] dataTypes, Set<SourceColumnSemantic> ignoredTypes) {
        SourceColumnSemantic[] types;
        block18: {
            int i;
            block19: {
                int size = model.getColumnCount();
                types = new SourceColumnSemantic[size];
                if (importType == ImportType.NETWORK_IMPORT) {
                    Arrays.fill((Object[])types, (Object)SourceColumnSemantic.EDGE_ATTR);
                } else {
                    Arrays.fill((Object[])types, (Object)SourceColumnSemantic.ATTR);
                }
                if (dataTypes == null || dataTypes.length == 0 || dataTypes.length != model.getColumnCount()) {
                    return types;
                }
                boolean srcFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.SOURCE);
                boolean tgtFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.TARGET);
                boolean interactFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.INTERACTION);
                boolean keyFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.KEY);
                boolean goFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.ONTOLOGY);
                boolean taxFound = ignoredTypes != null && ignoredTypes.contains((Object)SourceColumnSemantic.TAXON);
                block0: for (int attempt = 0; attempt < 2; ++attempt) {
                    boolean exact = attempt == 0;
                    for (int i2 = 0; i2 < size; ++i2) {
                        String name = model.getColumnName(i2);
                        AttributeDataType dataType = dataTypes[i2];
                        if (attempt == 0) {
                            if (name.isBlank() || "SUID".equalsIgnoreCase(name) || name.endsWith(".SUID") || "selected".equalsIgnoreCase(name)) {
                                types[i2] = SourceColumnSemantic.NONE;
                                continue;
                            }
                            if (importType == ImportType.NETWORK_IMPORT) {
                                if (!srcFound && TypeUtil.matches(name, PREF_SOURCE_NAMES, exact) && TypeUtil.isValid(SourceColumnSemantic.SOURCE, dataType)) {
                                    srcFound = true;
                                    types[i2] = SourceColumnSemantic.SOURCE;
                                    continue;
                                }
                                if (!tgtFound && TypeUtil.matches(name, PREF_TARGET_NAMES, exact) && TypeUtil.isValid(SourceColumnSemantic.TARGET, dataType)) {
                                    tgtFound = true;
                                    types[i2] = SourceColumnSemantic.TARGET;
                                    continue;
                                }
                                if (interactFound || !TypeUtil.matches(name, PREF_INTERACTION_NAMES, exact) || !TypeUtil.isValid(SourceColumnSemantic.INTERACTION, dataType)) continue;
                                interactFound = true;
                                types[i2] = SourceColumnSemantic.INTERACTION;
                                continue;
                            }
                            if (importType != ImportType.ONTOLOGY_IMPORT) continue;
                            if (!keyFound && TypeUtil.matches(name, PREF_KEY_NAMES, exact) && TypeUtil.canBeKey(model, i2, dataType)) {
                                keyFound = true;
                                types[i2] = SourceColumnSemantic.KEY;
                            } else if (!goFound && TypeUtil.matches(name, PREF_ONTOLOGY_NAMES, exact) && TypeUtil.isValid(SourceColumnSemantic.ONTOLOGY, dataType)) {
                                goFound = true;
                                types[i2] = SourceColumnSemantic.ONTOLOGY;
                            } else if (!taxFound && TypeUtil.matches(name, PREF_TAXON_NAMES, exact) && TypeUtil.isValid(SourceColumnSemantic.TAXON, dataType)) {
                                taxFound = true;
                                types[i2] = SourceColumnSemantic.TAXON;
                            }
                            if (!keyFound || !goFound || !taxFound) continue;
                            break block0;
                        }
                        if (keyFound || types[i2] == SourceColumnSemantic.NONE || !TypeUtil.canBeKey(model, i2, dataType)) continue;
                        keyFound = true;
                        types[i2] = SourceColumnSemantic.KEY;
                        break block0;
                    }
                }
                if (importType != ImportType.TABLE_IMPORT || keyFound) break block19;
                for (i = 0; i < types.length; ++i) {
                    String name = model.getColumnName(i);
                    if ("SUID".equalsIgnoreCase(name) || dataTypes[i] != AttributeDataType.TYPE_STRING && dataTypes[i] != AttributeDataType.TYPE_INTEGER && dataTypes[i] != AttributeDataType.TYPE_LONG) continue;
                    types[i] = SourceColumnSemantic.KEY;
                    break block18;
                }
                break block18;
            }
            if (importType != ImportType.NETWORK_IMPORT) break block18;
            block3: for (i = 0; i < types.length; ++i) {
                if (types[i] != SourceColumnSemantic.EDGE_ATTR) continue;
                for (int j = 0; j < types.length; ++j) {
                    if (i == j || types[j] != SourceColumnSemantic.EDGE_ATTR || !model.getColumnName(i).equals(model.getColumnName(j))) continue;
                    types[i] = SourceColumnSemantic.SOURCE_ATTR;
                    types[j] = SourceColumnSemantic.TARGET_ATTR;
                    continue block3;
                }
            }
        }
        return types;
    }

    public static AttributeDataType[] guessSheetDataTypes(PreviewTablePanel.PreviewTableModel model, Character decimalSeparator) {
        if (!model.hasPredefinedTypes()) {
            return TypeUtil.guessDataTypes(model, decimalSeparator);
        }
        AttributeDataType[] dataTypes = new AttributeDataType[model.getColumnCount()];
        for (int col = 0; col < model.getColumnCount(); ++col) {
            Class<?> predefinedClass = model.getPredefinedColumnClass(col);
            dataTypes[col] = predefinedClass == Double.class ? AttributeDataType.TYPE_FLOATING : (predefinedClass == Long.class ? AttributeDataType.TYPE_LONG : (predefinedClass == Integer.class ? AttributeDataType.TYPE_INTEGER : (predefinedClass == Boolean.class ? AttributeDataType.TYPE_BOOLEAN : AttributeDataType.TYPE_STRING)));
        }
        return dataTypes;
    }

    public static AttributeDataType[] guessDataTypes(TableModel model, Character decimalSeparator) {
        AttributeDataType[] dataTypes = new AttributeDataType[model.getColumnCount()];
        int rowCount = Math.min(1000, model.getRowCount());
        block0: for (int col = 0; col < model.getColumnCount(); ++col) {
            AttributeDataType dt = dataTypes[col];
            for (int row = 0; row < rowCount; ++row) {
                String val = (String)model.getValueAt(row, col);
                if (val == null || val.isEmpty() || val.equals("null")) continue;
                if (dt == AttributeDataType.TYPE_STRING || dt == AttributeDataType.TYPE_STRING_LIST) continue block0;
                if (dt == null) {
                    if (TypeUtil.isBoolean(val)) {
                        dt = AttributeDataType.TYPE_BOOLEAN;
                        continue;
                    }
                    if (TypeUtil.isInteger(val)) {
                        dt = AttributeDataType.TYPE_INTEGER;
                        continue;
                    }
                    if (TypeUtil.isLong(val)) {
                        dt = AttributeDataType.TYPE_LONG;
                        continue;
                    }
                    if (TypeUtil.isDouble(val, decimalSeparator)) {
                        dt = AttributeDataType.TYPE_FLOATING;
                        continue;
                    }
                    dt = AttributeDataType.TYPE_STRING;
                    continue;
                }
                if (dt == AttributeDataType.TYPE_BOOLEAN) {
                    if (TypeUtil.isBoolean(val)) continue;
                    dt = AttributeDataType.TYPE_STRING;
                    break;
                }
                if (dt == AttributeDataType.TYPE_INTEGER) {
                    if (TypeUtil.isInteger(val)) continue;
                    if (TypeUtil.isLong(val)) {
                        dt = AttributeDataType.TYPE_LONG;
                        continue;
                    }
                    if (TypeUtil.isDouble(val, decimalSeparator)) {
                        dt = AttributeDataType.TYPE_FLOATING;
                        continue;
                    }
                    dt = AttributeDataType.TYPE_STRING;
                    continue;
                }
                if (dt == AttributeDataType.TYPE_LONG) {
                    if (TypeUtil.isLong(val)) continue;
                    if (TypeUtil.isDouble(val, decimalSeparator)) {
                        dt = AttributeDataType.TYPE_FLOATING;
                        continue;
                    }
                    dt = AttributeDataType.TYPE_STRING;
                    continue;
                }
                if (dt != AttributeDataType.TYPE_FLOATING || TypeUtil.isDouble(val, decimalSeparator)) continue;
                dt = AttributeDataType.TYPE_STRING;
            }
            dataTypes[col] = dt;
        }
        for (int i = 0; i < dataTypes.length; ++i) {
            if (dataTypes[i] != null) continue;
            dataTypes[i] = AttributeDataType.TYPE_STRING;
        }
        return dataTypes;
    }

    public static SourceColumnSemantic[] parseColumnTypeList(String strList) {
        ArrayList<SourceColumnSemantic> typeList = new ArrayList<SourceColumnSemantic>();
        if (strList != null) {
            String[] tokens;
            for (String t : tokens = TypeUtil.getCSV(strList)) {
                String s;
                typeList.add(switch (s = t.trim().toLowerCase().replaceAll("[^a-zA-Z]", "")) {
                    case "s", "source", "source node" -> SourceColumnSemantic.SOURCE;
                    case "t", "target", "target node" -> SourceColumnSemantic.TARGET;
                    case "i", "interaction" -> SourceColumnSemantic.INTERACTION;
                    case "sa", "source attribute" -> SourceColumnSemantic.SOURCE_ATTR;
                    case "ta", "target attribute" -> SourceColumnSemantic.TARGET_ATTR;
                    case "ea", "edge attribute" -> SourceColumnSemantic.EDGE_ATTR;
                    case "x", "skip", "none" -> SourceColumnSemantic.NONE;
                    default -> throw new IllegalArgumentException("Invalid Column Type: \"" + t + "\"");
                });
            }
        }
        return typeList.toArray(new SourceColumnSemantic[typeList.size()]);
    }

    public static AttributeDataType[] parseDataTypeList(String strList) {
        ArrayList<AttributeDataType> dataTypeList = new ArrayList<AttributeDataType>();
        if (strList != null) {
            String[] tokens;
            for (String t : tokens = TypeUtil.getCSV(strList)) {
                String s;
                dataTypeList.add(switch (s = t.trim().toLowerCase().replaceAll("[^a-zA-Z]", "")) {
                    case "i", "int", "integer" -> AttributeDataType.TYPE_INTEGER;
                    case "l", "long", "longinteger" -> AttributeDataType.TYPE_LONG;
                    case "f", "d", "float", "floating", "floatingpoint", "decimal", "double" -> AttributeDataType.TYPE_FLOATING;
                    case "b", "bool", "boolean" -> AttributeDataType.TYPE_BOOLEAN;
                    case "s", "t", "text", "string" -> AttributeDataType.TYPE_STRING;
                    case "ii", "li", "il", "listint", "listinteger", "intlist", "integerlist" -> AttributeDataType.TYPE_INTEGER_LIST;
                    case "ll", "listlong", "listlonginteger", "longlist", "longintegerlist" -> AttributeDataType.TYPE_LONG_LIST;
                    case "ff", "dd", "lf", "fl", "ld", "dl", "listfloat", "listfloating", "listfloatingpoint", "listdecimal", "listdouble", "floatlist", "floatinglist", "floatingpointlist", "decimallist", "doublelist" -> AttributeDataType.TYPE_FLOATING_LIST;
                    case "bb", "lb", "bl", "listbool", "listboolean", "boollist", "booleanlist" -> AttributeDataType.TYPE_BOOLEAN_LIST;
                    case "ss", "ls", "sl", "lt", "tl", "liststring", "listtext", "stringlist", "textlist" -> AttributeDataType.TYPE_STRING_LIST;
                    default -> throw new IllegalArgumentException("Invalid Data Type: \"" + t + "\"");
                });
            }
        }
        return dataTypeList.toArray(new AttributeDataType[dataTypeList.size()]);
    }

    public static String[] getPreferredNamespaces(SourceColumnSemantic[] types) {
        String[] namespaces;
        String[] stringArray = namespaces = types != null ? new String[types.length] : null;
        if (namespaces != null) {
            for (int i = 0; i < types.length; ++i) {
                SourceColumnSemantic t = types[i];
                namespaces[i] = TypeUtil.getPreferredNamespace(t);
            }
        }
        return namespaces;
    }

    public static String getPreferredNamespace(SourceColumnSemantic type) {
        if (type == null) {
            return null;
        }
        return type.isUnique() ? "LOCAL_ATTRS" : preferredNamespace;
    }

    public static void setPreferredNamespace(String preferredNamespace) {
        TypeUtil.preferredNamespace = preferredNamespace;
    }

    private static boolean isBoolean(String val) {
        return val != null && (truePattern.matcher(val).matches() || falsePattern.matcher(val).matches());
    }

    private static boolean isNaN(String val) {
        if (val != null) {
            return val.equals("NA") || val.equals("#NUM!") || val.equals("NaN");
        }
        return false;
    }

    private static boolean isInteger(String val) {
        if (val != null) {
            if (TypeUtil.isNaN(val)) {
                return true;
            }
            try {
                long n = Long.parseLong(val.trim());
                return n <= Integer.MAX_VALUE && n >= Integer.MIN_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isLong(String val) {
        if (val != null) {
            if (TypeUtil.isNaN(val)) {
                return true;
            }
            try {
                Long.parseLong(val.trim());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isDouble(String val, Character decimalSeparator) {
        if (val != null) {
            if (TypeUtil.isNaN(val = val.trim())) {
                return true;
            }
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator(decimalSeparator.charValue());
            dfs.setExponentSeparator("E");
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(dfs);
            df.setGroupingUsed(false);
            ParsePosition parsePosition = new ParsePosition(0);
            String val1 = val.replace('e', 'E');
            df.parse(val1, parsePosition);
            if (parsePosition.getIndex() != val1.length()) {
                return false;
            }
            return !(val1 = val1.toLowerCase()).endsWith("f") && !val1.endsWith("d");
        }
        return false;
    }

    public static boolean allowsDuplicateName(ImportType importType, SourceColumnSemantic type1, SourceColumnSemantic type2) {
        boolean b;
        boolean bl = b = type1 == SourceColumnSemantic.NONE || type2 == SourceColumnSemantic.NONE;
        if (importType == ImportType.NETWORK_IMPORT) {
            b = b || type1 == SourceColumnSemantic.SOURCE_ATTR && type2 != SourceColumnSemantic.SOURCE_ATTR && type2 != SourceColumnSemantic.SOURCE && type2 != SourceColumnSemantic.TARGET;
            b = b || type2 == SourceColumnSemantic.SOURCE_ATTR && type1 != SourceColumnSemantic.SOURCE_ATTR && type1 != SourceColumnSemantic.SOURCE && type1 != SourceColumnSemantic.TARGET;
            b = b || type1 == SourceColumnSemantic.TARGET_ATTR && type2 != SourceColumnSemantic.TARGET_ATTR && type2 != SourceColumnSemantic.SOURCE && type2 != SourceColumnSemantic.TARGET;
            b = b || type2 == SourceColumnSemantic.TARGET_ATTR && type1 != SourceColumnSemantic.TARGET_ATTR && type1 != SourceColumnSemantic.SOURCE && type1 != SourceColumnSemantic.TARGET;
            b = b || type1 == SourceColumnSemantic.EDGE_ATTR && type2 != SourceColumnSemantic.EDGE_ATTR && type2 != SourceColumnSemantic.INTERACTION;
            b = b || type2 == SourceColumnSemantic.EDGE_ATTR && type1 != SourceColumnSemantic.EDGE_ATTR && type1 != SourceColumnSemantic.INTERACTION;
        }
        return b;
    }

    public static boolean isValid(SourceColumnSemantic type, AttributeDataType dataType) {
        if (type == SourceColumnSemantic.KEY || type == SourceColumnSemantic.SOURCE || type == SourceColumnSemantic.TARGET) {
            return dataType == AttributeDataType.TYPE_INTEGER || dataType == AttributeDataType.TYPE_LONG || dataType == AttributeDataType.TYPE_STRING;
        }
        if (type == SourceColumnSemantic.INTERACTION || type == SourceColumnSemantic.ONTOLOGY || type == SourceColumnSemantic.TAXON) {
            return dataType == AttributeDataType.TYPE_STRING;
        }
        return true;
    }

    public static boolean isValid(SourceColumnSemantic type, String namespace) {
        if (type == SourceColumnSemantic.NONE) {
            return false;
        }
        if (type == SourceColumnSemantic.KEY || type == SourceColumnSemantic.SOURCE || type == SourceColumnSemantic.TARGET) {
            return namespace == "LOCAL_ATTRS";
        }
        if (type == SourceColumnSemantic.INTERACTION || type == SourceColumnSemantic.ONTOLOGY || type == SourceColumnSemantic.TAXON) {
            return namespace == "LOCAL_ATTRS";
        }
        return true;
    }

    private static boolean matches(String name, String[] preferredNames, boolean exact) {
        name = name.replaceAll("[^a-zA-Z0-9]", "").toLowerCase().trim();
        block0: for (String s : preferredNames) {
            if (exact && name.equalsIgnoreCase(s = s.replaceAll(" ", ""))) {
                return true;
            }
            if (exact) continue;
            String[] tokens = s.split(" ");
            boolean b = false;
            for (String t : tokens) {
                boolean bl = b = b && name.contains(t.toLowerCase());
                if (!b) continue block0;
            }
            return true;
        }
        return false;
    }

    private static boolean canBeKey(TableModel model, int col, AttributeDataType dataType) {
        if (dataType != AttributeDataType.TYPE_STRING && dataType != AttributeDataType.TYPE_INTEGER && dataType != AttributeDataType.TYPE_LONG) {
            return false;
        }
        int rowCount = Math.min(1000, model.getRowCount());
        HashSet<Object> values = new HashSet<Object>();
        for (int row = 0; row < rowCount; ++row) {
            Object val = model.getValueAt(row, col);
            if (val == null) {
                return false;
            }
            if (dataType == AttributeDataType.TYPE_STRING) {
                String s = val.toString();
                if (values.contains(s)) {
                    return false;
                }
                values.add(s);
                continue;
            }
            try {
                Long n = Long.parseLong(val.toString());
                if (values.contains(n)) {
                    return false;
                }
                values.add(n);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static String[] getCSV(String str) {
        String[] s1 = str.split("(?<!\\\\),");
        for (int index = 0; index < s1.length; ++index) {
            String s = s1[index];
            s1[index] = s.replaceAll("\\\\", "");
        }
        return s1;
    }
}

