/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class DataUtils {
    public static final String PARENT_NETWORK_COLUMN = "__parentNetwork.SUID";

    public static String getNetworkName(CyNetwork network) {
        Object name = "";
        try {
            name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null || ((String)name).trim().isEmpty()) {
            name = "? (SUID: " + network.getSUID() + ")";
        }
        return name;
    }

    public static String getViewTitle(CyNetworkView view) {
        String title = (String)view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        if (title == null || title.trim().isEmpty()) {
            title = DataUtils.getNetworkName((CyNetwork)view.getModel());
        }
        return title;
    }

    public static String getNodeName(CyTable table, CyNode node) {
        Object name = (String)table.getRow((Object)node.getSUID()).get("name", String.class);
        name = (String)name + " (SUID: " + node.getSUID() + ")";
        return name;
    }

    public static String getEdgeName(CyTable table, CyEdge edge) {
        Object name = (String)table.getRow((Object)edge.getSUID()).get("name", String.class);
        name = (String)name + " (SUID: " + edge.getSUID() + ")";
        return name;
    }

    public static <T> T convertString(String value, Class<T> type) {
        if (type.equals(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (type.equals(Double.class)) {
            return (T)Double.valueOf(value);
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.equals(String.class)) {
            return (T)value;
        }
        return null;
    }

    public static <T> List<T> convertStringList(String value, Class<T> listElementType) {
        String[] splitString = DataUtils.getCSV(value);
        ArrayList<T> list = new ArrayList<T>();
        for (String s : splitString) {
            T val = DataUtils.convertString(s, listElementType);
            if (val == null) continue;
            list.add(val);
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public static String convertData(Object data) {
        if (data instanceof List) {
            return DataUtils.convertListToString((List)data);
        }
        if (data instanceof Map) {
            return DataUtils.convertMapToString((Map)data);
        }
        return data.toString();
    }

    public static String convertDataJSON(Object object) {
        if (object instanceof List) {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (Object value : (List)object) {
                joiner.add(DataUtils.convertPrimitiveJSON(value));
            }
            return joiner.toString();
        }
        if (object instanceof Map) {
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (entry.getKey() == null) continue;
                joiner.add("\"" + entry.getKey().toString() + "\": " + DataUtils.convertDataJSON(entry.getValue()));
            }
            return joiner.toString();
        }
        return DataUtils.convertPrimitiveJSON(object);
    }

    private static String convertPrimitiveJSON(Object object) {
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object == null) {
            return "null";
        }
        throw new IllegalArgumentException();
    }

    public static String convertMapToString(Map data) {
        if (data.size() == 0) {
            return "{}";
        }
        Object result = "{";
        for (Object key : data.keySet()) {
            Object v = data.get(key);
            if (v == null) continue;
            result = (String)result + key.toString() + ":";
            if (v instanceof List) {
                result = (String)result + DataUtils.convertListToString((List)v) + ",";
                continue;
            }
            if (v instanceof Map) {
                result = (String)result + DataUtils.convertMapToString((Map)v) + ",";
                continue;
            }
            result = (String)result + v.toString() + ",";
        }
        return ((String)result).substring(0, ((String)result).length() - 1) + "}";
    }

    public static String convertListToString(List<Object> data) {
        if (data.size() == 0) {
            return "[]";
        }
        Object result = "[";
        for (Object v : data) {
            result = (String)result + v.toString() + ",";
        }
        return ((String)result).substring(0, ((String)result).length() - 1) + "]";
    }

    public static Class getType(String type) {
        if ("double".equalsIgnoreCase(type)) {
            return Double.class;
        }
        if ("integer".equalsIgnoreCase(type)) {
            return Integer.class;
        }
        if ("long".equalsIgnoreCase(type)) {
            return Long.class;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return Boolean.class;
        }
        if ("string".equalsIgnoreCase(type)) {
            return String.class;
        }
        if ("list".equalsIgnoreCase(type)) {
            return List.class;
        }
        return String.class;
    }

    public static String getType(Class type) {
        if (type.equals(Double.class)) {
            return "double";
        }
        if (type.equals(Integer.class)) {
            return "integer";
        }
        if (type.equals(Long.class)) {
            return "long";
        }
        if (type.equals(Boolean.class)) {
            return "boolean";
        }
        if (type.equals(String.class)) {
            return "string";
        }
        if (type.equals(List.class)) {
            return "list";
        }
        return type.getName();
    }

    public static String getIdentifiableType(Class<? extends CyIdentifiable> type) {
        if (type.equals(CyNetwork.class)) {
            return "Network";
        }
        if (type.equals(CyNode.class)) {
            return "Node";
        }
        if (type.equals(CyEdge.class)) {
            return "Edge";
        }
        return "unknown";
    }

    public static Class<? extends CyIdentifiable> getIdentifiableClass(CyIdentifiable obj) {
        if (obj instanceof CyNetwork) {
            return CyNetwork.class;
        }
        if (obj instanceof CyNode) {
            return CyNode.class;
        }
        if (obj instanceof CyEdge) {
            return CyEdge.class;
        }
        return CyIdentifiable.class;
    }

    public static String[] getCSV(String str) {
        String[] s1 = str.split("(?<!\\\\),");
        for (int index = 0; index < s1.length; ++index) {
            String s = s1[index];
            s1[index] = s.replaceAll("\\\\", "");
        }
        return s1;
    }

    public static void saveParentNetworkSUID(CySubNetwork net, Long parentSUID) {
        CyTable hiddenTable = net.getTable(CyNetwork.class, "HIDDEN");
        if (hiddenTable.getColumn(PARENT_NETWORK_COLUMN) == null) {
            hiddenTable.createColumn(PARENT_NETWORK_COLUMN, Long.class, true);
        }
        hiddenTable.getRow((Object)net.getSUID()).set(PARENT_NETWORK_COLUMN, (Object)parentSUID);
    }

    public static Long getParentNetworkSUID(CySubNetwork net) {
        CyTable table = net.getTable(CyNetwork.class, "HIDDEN");
        return table != null ? (Long)table.getRow((Object)net.getSUID()).get(PARENT_NETWORK_COLUMN, Long.class) : null;
    }
}

