/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.ui;

import au.com.bytecode.opencsv.CSVReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleComponent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.ui.AttributeEditorPanel;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.FileType;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.tableimport.internal.util.URLUtil;
import org.cytoscape.util.swing.ColumnResizer;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewTablePanel
extends JPanel {
    private static final float ICON_FONT_SIZE = 14.0f;
    private String commentChar;
    private int startLine;
    private String[] namespaces;
    private SourceColumnSemantic[] types;
    private AttributeDataType[] dataTypes;
    private String[] listDelimiters;
    private Character decimalSeparator;
    private Set<?> keySet;
    private JLabel sheetLabel;
    private JComboBox<Sheet> sheetComboBox;
    private JTable previewTable;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JScrollPane tableScrollPane;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private ImportType importType;
    private final TableImportContext tableImportContext;
    private final IconManager iconManager;
    private EditDialog editDialog;
    private int lastDialogIndex = -1;
    private long lastDialogTime;
    private boolean updating;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public PreviewTablePanel(ImportType importType, TableImportContext tableImportContext, IconManager iconManager) {
        this.importType = importType;
        this.tableImportContext = tableImportContext;
        this.iconManager = iconManager;
        this.initComponents();
    }

    public void setKeyAttributeList(Set<?> keySet) {
        this.keySet = keySet;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changes == null) {
            return;
        }
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    private void initComponents() {
        this.setBorder(LookAndFeelUtil.createTitledBorder((String)"Preview"));
        this.sheetLabel = new JLabel("Sheet:");
        this.sheetLabel.setVisible(false);
        JLabel instructionLabel = new JLabel("Click on a column to edit it.");
        instructionLabel.setFont(instructionLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getSelectAllButton(), this.getSelectNoneButton()});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.sheetLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSheetComboBox(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(instructionLabel).addGap(20, 20, Short.MAX_VALUE).addComponent(this.getSelectAllButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSelectNoneButton(), -2, -1, -2)).addComponent(this.getTableScrollPane(), -1, 320, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.sheetLabel).addComponent(this.getSheetComboBox(), -2, -1, -2).addComponent(instructionLabel).addComponent(this.getSelectAllButton()).addComponent(this.getSelectNoneButton())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getTableScrollPane(), 120, 180, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED));
        ColumnResizer.adjustColumnPreferredWidths((JTable)this.getPreviewTable());
        this.update();
    }

    public JTable getPreviewTable() {
        if (this.previewTable == null) {
            this.previewTable = new JTable(new PreviewTableModel(new Vector<Vector<String>>(), new Vector<String>(), false));
            this.previewTable.setShowGrid(false);
            this.previewTable.setCellSelectionEnabled(false);
            this.previewTable.setAutoResizeMode(0);
            this.previewTable.setDefaultEditor(Object.class, null);
            if (this.importType == ImportType.NETWORK_IMPORT) {
                PreviewTableCellRenderer netRenderer = new PreviewTableCellRenderer();
                this.previewTable.setDefaultRenderer(Object.class, netRenderer);
            } else {
                this.previewTable.setDefaultRenderer(Object.class, new PreviewTableCellRenderer());
            }
            JTableHeader hd = this.previewTable.getTableHeader();
            hd.setReorderingAllowed(false);
            hd.setDefaultRenderer(new PreviewTableHeaderRenderer());
            TableColumnModelListener colModelListener = new TableColumnModelListener(){

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    PreviewTablePanel.this.disposeEditDialog();
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                    PreviewTablePanel.this.disposeEditDialog();
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }
            };
            hd.addMouseListener(new MouseAdapter(colModelListener){
                final /* synthetic */ 1 val$colModelListener;
                {
                    this.val$colModelListener = var2_2;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    TableColumnModel columnModel = PreviewTablePanel.this.previewTable.getColumnModel();
                    int newColIdx = columnModel.getColumnIndexAtX(e.getX());
                    int idx = PreviewTablePanel.this.editDialog != null ? PreviewTablePanel.this.editDialog.index : -1;
                    PreviewTablePanel.this.disposeEditDialog();
                    if (idx != newColIdx) {
                        PreviewTablePanel.this.showEditDialog(newColIdx);
                    }
                    PreviewTablePanel.this.previewTable.getColumnModel().removeColumnModelListener(this.val$colModelListener);
                    PreviewTablePanel.this.previewTable.getColumnModel().addColumnModelListener(this.val$colModelListener);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PreviewTablePanel.this.previewTable.getColumnModel().removeColumnModelListener(this.val$colModelListener);
                }
            });
            this.previewTable.getModel().addTableModelListener(evt -> this.disposeEditDialog());
        }
        return this.previewTable;
    }

    public String[] getAttributeNames() {
        String[] names = null;
        PreviewTableModel model = (PreviewTableModel)this.getPreviewTable().getModel();
        int columnCount = model.getColumnCount();
        names = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            names[i] = model.getColumnName(i);
        }
        return names;
    }

    public String[] getNamespaces() {
        return this.namespaces;
    }

    protected void setNamespace(int index, String newValue) {
        if (index < 0) {
            return;
        }
        if (this.namespaces != null && this.namespaces.length > index) {
            this.namespaces[index] = newValue;
        }
    }

    public SourceColumnSemantic[] getTypes() {
        return this.types;
    }

    protected void setType(int index, SourceColumnSemantic newType) {
        if (index < 0) {
            return;
        }
        if (this.types != null && this.types.length > index) {
            if (newType.isUnique()) {
                this.replaceType(newType, TypeUtil.getDefaultType(this.importType));
            }
            SourceColumnSemantic oldType = this.types[index];
            this.types[index] = newType;
            if (newType != oldType) {
                this.changes.fireIndexedPropertyChange("attrTypeChanged", index, (Object)oldType, (Object)newType);
            }
        }
    }

    protected void fillTypes(SourceColumnSemantic newValue) {
        if (this.types != null) {
            Arrays.fill((Object[])this.types, (Object)newValue);
        }
    }

    protected void replaceType(SourceColumnSemantic type1, SourceColumnSemantic type2) {
        if (this.types != null) {
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] != type1) continue;
                this.setType(i, type2);
            }
        }
    }

    public AttributeDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public AttributeDataType getDataType(int index) {
        if (this.dataTypes != null && this.dataTypes.length > index) {
            return this.dataTypes[index];
        }
        return null;
    }

    protected void setDataType(int index, AttributeDataType newValue) {
        if (index < 0) {
            return;
        }
        if (this.dataTypes != null && this.dataTypes.length > index) {
            AttributeDataType oldValue = this.dataTypes[index];
            this.dataTypes[index] = newValue;
            if (newValue != oldValue) {
                this.changes.fireIndexedPropertyChange("attrDataTypeChanged", index, (Object)oldValue, (Object)newValue);
            }
        }
    }

    public String[] getListDelimiters() {
        return this.listDelimiters;
    }

    public void setListDelimiter(int index, String newValue) {
        if (index < 0) {
            return;
        }
        if (this.listDelimiters != null && this.listDelimiters.length > index) {
            this.listDelimiters[index] = newValue;
        }
    }

    public FileType getFileType() {
        String name = this.getSourceName();
        if (name != null && name.startsWith("gene_association")) {
            return FileType.GENE_ASSOCIATION_FILE;
        }
        return FileType.ATTRIBUTE_FILE;
    }

    public String getSourceName() {
        return this.getPreviewTable().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Workbook workbook, String fileType, String fileFullName, InputStream tempIs, List<String> delimiters, String commentLineChar, int startLine, Character decimalSeparator) throws IOException {
        if (tempIs == null) {
            return;
        }
        this.commentChar = commentLineChar != null && commentLineChar.trim().length() != 0 ? commentLineChar : null;
        this.startLine = startLine;
        this.decimalSeparator = decimalSeparator;
        this.updating = true;
        try {
            this.getSheetComboBox().removeAllItems();
            this.getSheetComboBox().setVisible(false);
            this.sheetLabel.setVisible(false);
            PreviewTableModel newModel = null;
            if (SupportedFileType.EXCEL.getExtension().equalsIgnoreCase(fileType) || SupportedFileType.OOXML.getExtension().equalsIgnoreCase(fileType)) {
                int numberOfSheets = workbook.getNumberOfSheets();
                if (numberOfSheets == 0) {
                    throw new IllegalStateException("No sheet found in the workbook.");
                }
                for (int i = 0; i < numberOfSheets; ++i) {
                    Sheet sheet = workbook.getSheetAt(i);
                    if (sheet.getPhysicalNumberOfRows() <= 0) continue;
                    this.getSheetComboBox().addItem(sheet);
                }
                if (this.getSheetComboBox().getItemCount() > 0) {
                    this.getSheetComboBox().setSelectedIndex(0);
                }
                if (this.getSheetComboBox().getItemCount() > 1) {
                    this.sheetLabel.setVisible(true);
                    this.getSheetComboBox().setVisible(true);
                }
                if (this.getSheetComboBox().getItemCount() <= 0) throw new RuntimeException("No data found in the Excel sheets.");
                Sheet sheet = workbook.getSheetAt(0);
                this.update(sheet);
                return;
            } else {
                newModel = this.parseText(tempIs, delimiters, startLine);
                String[] urlParts = fileFullName.split("/");
                String sourceName = urlParts.length > 0 && !fileFullName.isEmpty() ? urlParts[urlParts.length - 1] : "Source Table";
                this.dataTypes = TypeUtil.guessDataTypes(newModel, decimalSeparator);
                this.types = TypeUtil.guessTypes(this.importType, newModel, this.dataTypes, this.getIgnoredTypes());
                this.listDelimiters = new String[newModel.getColumnCount()];
                this.namespaces = TypeUtil.getPreferredNamespaces(this.types);
                this.update(newModel, sourceName);
            }
            return;
        }
        finally {
            this.updating = false;
        }
    }

    public void setFirstRowAsColumnNames() {
        PreviewTableModel model = (PreviewTableModel)this.getPreviewTable().getModel();
        model.setFirstRowNames(true);
        this.types = TypeUtil.guessTypes(this.importType, model, this.dataTypes, this.getIgnoredTypes());
        this.update();
        ColumnResizer.adjustColumnPreferredWidths((JTable)this.getPreviewTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCytoscapeAttributeFile(URL sourceURL) throws IOException {
        boolean testResult = true;
        try (InputStream is = null;){
            is = URLUtil.getInputStream(sourceURL);
            try (BufferedReader bufRd = null;){
                String line = null;
                int i = 0;
                bufRd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8").newDecoder()));
                while ((line = bufRd.readLine()) != null) {
                    if (i == 0) {
                        elements = line.split(" +");
                        if (!(elements.length == 1 || (elements = line.split("[(]")).length == 2 && elements[1].startsWith("class="))) {
                            testResult = false;
                            break;
                        }
                    } else if (i == 1) {
                        elements = line.split(" += +");
                        if (elements.length != 2) {
                            testResult = false;
                        }
                    } else if (i >= 2) {
                        break;
                    }
                    ++i;
                }
            }
        }
        return testResult;
    }

    public int checkKeyMatch(int targetColumn) {
        int matched = 0;
        if (this.keySet != null && !this.keySet.isEmpty()) {
            TableModel curModel = this.getPreviewTable().getModel();
            try {
                curModel.getValueAt(0, targetColumn);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 0;
            }
            int rowCount = curModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Object val = curModel.getValueAt(i, targetColumn);
                if (val == null || !this.keySet.contains(val)) continue;
                ++matched;
            }
        }
        return matched;
    }

    public int getPreviewSize() {
        return 500;
    }

    protected int getColumnIndex(SourceColumnSemantic type) {
        if (this.types != null) {
            return Arrays.asList(this.types).indexOf((Object)type);
        }
        return -1;
    }

    protected void setAliasColumn(int index, boolean flag) {
        if (this.types != null && this.types.length > index) {
            this.types[index] = flag ? SourceColumnSemantic.ALIAS : SourceColumnSemantic.ATTR;
            this.update();
        }
    }

    protected boolean isImported(int index) {
        if (this.types != null && this.types.length > index) {
            return this.types[index] != SourceColumnSemantic.NONE;
        }
        return false;
    }

    private Class<?> getNumericClass(double val) {
        BigDecimal bd = BigDecimal.valueOf(val);
        try {
            bd.intValueExact();
            return Integer.class;
        }
        catch (ArithmeticException eInt) {
            try {
                bd.longValueExact();
                return Long.class;
            }
            catch (ArithmeticException eLong) {
                return Double.class;
            }
        }
    }

    private String formatCell(Cell cell, Class<?> cellClass, DataFormatter formatter, FormulaEvaluator evaluator) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            if (evaluator == null) {
                return cell.getCellFormula();
            }
            cellType = evaluator.evaluateFormulaCell(cell);
        }
        switch (cellType) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return formatter.formatCellValue(cell, evaluator);
                }
                BigDecimal val = BigDecimal.valueOf(cell.getNumericCellValue());
                if (cellClass == Integer.class) {
                    return String.valueOf(val.intValue());
                }
                if (cellClass == Long.class) {
                    return String.valueOf(val.longValue());
                }
                if (cellClass == Double.class) {
                    return String.valueOf(val.doubleValue());
                }
                return val.toPlainString();
            }
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }

    private PreviewTableModel parseExcel(Sheet sheet, int startLine) throws IOException {
        Row row;
        int size = this.getPreviewSize();
        if (size == -1) {
            size = Integer.MAX_VALUE;
        }
        short maxCol = 0;
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        boolean firstRowNames = this.importType == ImportType.NETWORK_IMPORT || this.importType == ImportType.TABLE_IMPORT;
        int rowCount = 0;
        int validRowCount = 0;
        FormulaEvaluator evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        DataFormatter formatter = new DataFormatter();
        Vector colTypes = new Vector();
        Vector<Row> previewRows = new Vector<Row>();
        while ((row = sheet.getRow(rowCount)) != null && validRowCount < size) {
            if (rowCount >= startLine) {
                if (maxCol < row.getLastCellNum()) {
                    maxCol = row.getLastCellNum();
                }
                if (colTypes.size() != maxCol) {
                    for (int c = colTypes.size(); c < maxCol; ++c) {
                        colTypes.add(null);
                    }
                }
                for (short j = 0; j < maxCol; j = (short)(j + 1)) {
                    Cell cell = row.getCell((int)j);
                    if (cell == null || cell.getCellType() == CellType.ERROR || cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() == CellType.ERROR || firstRowNames && validRowCount <= 0) continue;
                    Class<Object> colType = colTypes.get(j);
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.FORMULA && evaluator != null) {
                        cellType = evaluator.evaluateFormulaCell(cell);
                    }
                    if (colType == null) {
                        switch (cellType) {
                            case NUMERIC: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    colType = String.class;
                                    break;
                                }
                                colType = this.getNumericClass(cell.getNumericCellValue());
                                break;
                            }
                            case STRING: {
                                colType = String.class;
                                break;
                            }
                            case BOOLEAN: {
                                colType = Boolean.class;
                                break;
                            }
                            case BLANK: 
                            case FORMULA: {
                                colType = null;
                            }
                        }
                    } else if (colType == Boolean.class) {
                        if (cellType != CellType.BOOLEAN) {
                            colType = String.class;
                        }
                    } else if (colType == Integer.class) {
                        if (cellType == CellType.NUMERIC) {
                            cellNumericType = this.getNumericClass(cell.getNumericCellValue());
                            if (cellNumericType == Long.class) {
                                colType = Long.class;
                            } else if (cellNumericType == Double.class) {
                                colType = Double.class;
                            }
                        } else {
                            colType = String.class;
                        }
                    } else if (colType == Long.class) {
                        if (cellType == CellType.NUMERIC) {
                            cellNumericType = this.getNumericClass(cell.getNumericCellValue());
                            if (cellNumericType == Double.class) {
                                colType = Double.class;
                            }
                        } else {
                            colType = String.class;
                        }
                    } else if (colType == Double.class && cellType != CellType.NUMERIC) {
                        colType = String.class;
                    }
                    colTypes.set(j, colType);
                }
                previewRows.add(row);
                ++validRowCount;
            }
            ++rowCount;
        }
        for (Row r : previewRows) {
            Vector<String> rowVector = new Vector<String>();
            for (short col = 0; col < maxCol; col = (short)(col + 1)) {
                Cell cell = r.getCell((int)col);
                if (cell == null || cell.getCellType() == CellType.ERROR || cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() == CellType.ERROR) {
                    rowVector.add(null);
                    continue;
                }
                rowVector.add(this.formatCell(cell, colTypes.get(col), formatter, evaluator));
            }
            data.add(rowVector);
        }
        return new PreviewTableModel(data, new Vector<String>(), colTypes, firstRowNames);
    }

    private PreviewTableModel parseText(InputStream tempIs, List<String> delimiters, int startLine) throws IOException {
        boolean firstRowNames;
        String line;
        String delimiterRegEx;
        String attrName = "Attr1";
        Vector<Vector<String>> data = null;
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(tempIs, Charset.forName("UTF-8").newDecoder()));
        if (delimiters != null) {
            StringBuffer delimiterBuffer = new StringBuffer();
            if (delimiters.size() != 0) {
                delimiterBuffer.append("[");
                for (String delimiter : delimiters) {
                    delimiterBuffer.append(delimiter);
                }
                delimiterBuffer.append("]");
            }
            delimiterRegEx = delimiterBuffer.toString();
        } else {
            delimiterRegEx = " += +";
            line = bufRd.readLine();
            String[] line1 = line.split(" +");
            attrName = line1[0];
        }
        int size = this.getPreviewSize();
        boolean importAll = false;
        if (size == -1) {
            importAll = true;
        }
        int rowCount = 0;
        int validRowCount = 0;
        int maxColumn = 0;
        data = new Vector<Vector<String>>();
        if (delimiters != null && delimiters.contains(TextDelimiter.COMMA.getDelimiter()) && delimiters.size() == 1) {
            String[] rowData;
            CSVReader reader = new CSVReader((Reader)bufRd);
            while ((rowData = reader.readNext()) != null) {
                List<String> list = Arrays.asList(rowData);
                String string = line = list.isEmpty() ? "" : String.join((CharSequence)TextDelimiter.COMMA.getDelimiter(), list);
                if (!this.ignoreLine(line, rowCount)) {
                    Vector<String> row = new Vector<String>();
                    for (String field : rowData) {
                        row.add(field);
                    }
                    if (rowData.length > maxColumn) {
                        maxColumn = rowData.length;
                    }
                    data.add(row);
                    ++validRowCount;
                }
                ++rowCount;
                if (importAll || validRowCount < size) continue;
                break;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        } else {
            while ((line = bufRd.readLine()) != null) {
                if (!this.ignoreLine(line, rowCount)) {
                    Vector<String> row = new Vector<String>();
                    String[] parts = delimiterRegEx.length() == 0 ? new String[]{line} : line.split(delimiterRegEx);
                    for (String entry : parts) {
                        row.add(entry);
                    }
                    if (parts.length > maxColumn) {
                        maxColumn = parts.length;
                    }
                    data.add(row);
                    ++validRowCount;
                }
                ++rowCount;
                if (importAll || validRowCount < size) continue;
            }
        }
        if (tempIs != null) {
            tempIs.close();
        }
        boolean bl = firstRowNames = this.importType == ImportType.NETWORK_IMPORT || this.importType == ImportType.TABLE_IMPORT;
        if (delimiters == null) {
            Vector<String> columnNames = new Vector<String>();
            columnNames.add("Key");
            columnNames.add(attrName);
            return new PreviewTableModel(data, columnNames, firstRowNames);
        }
        return new PreviewTableModel(data, new Vector<String>(), firstRowNames);
    }

    private boolean ignoreLine(String line, int index) {
        return this.commentChar != null && line.startsWith(this.commentChar) || line.trim().length() == 0 || index < this.startLine;
    }

    private void showEditDialog(final int colIdx) {
        if (colIdx == this.lastDialogIndex && System.currentTimeMillis() - this.lastDialogTime < 100L) {
            return;
        }
        this.lastDialogIndex = -1;
        this.lastDialogTime = 0L;
        Window parent = SwingUtilities.getWindowAncestor(this);
        PreviewTableModel model = (PreviewTableModel)this.getPreviewTable().getModel();
        String attrName = model.getColumnName(colIdx);
        List<String> availableNamespaces = TypeUtil.getAvailableNamespaces(this.importType);
        List<SourceColumnSemantic> availableTypes = TypeUtil.getAvailableTypes(this.importType);
        if (!this.tableImportContext.isKeyRequired() && availableTypes.contains((Object)SourceColumnSemantic.KEY)) {
            availableTypes = new ArrayList<SourceColumnSemantic>(availableTypes);
            availableTypes.remove((Object)SourceColumnSemantic.KEY);
        }
        final AttributeEditorPanel attrEditorPanel = new AttributeEditorPanel(parent, attrName, availableTypes, availableNamespaces, this.types[colIdx], this.namespaces[colIdx], this.dataTypes[colIdx], this.listDelimiters[colIdx], this.iconManager);
        if (LookAndFeelUtil.isWinLAF()) {
            attrEditorPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("activeCaptionBorder")));
            attrEditorPanel.setBackground(UIManager.getColor("TableHeader.background"));
        }
        this.editDialog = new EditDialog(attrEditorPanel, parent, colIdx);
        ActionMap actionMap = attrEditorPanel.getActionMap();
        InputMap inputMap = attrEditorPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "VK_ESCAPE");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
        actionMap.put("VK_ESCAPE", new AbstractAction("VK_ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTablePanel.this.disposeEditDialog();
            }
        });
        actionMap.put("VK_ENTER", new AbstractAction("VK_ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTablePanel.this.disposeEditDialog();
            }
        });
        attrEditorPanel.addPropertyChangeListener("attributeName", evt -> {
            String name = (String)evt.getNewValue();
            if (name != null) {
                ((PreviewTableModel)this.getPreviewTable().getModel()).setColumnName(colIdx, name);
                this.getPreviewTable().getColumnModel().getColumn(colIdx).setHeaderValue(name);
                this.update();
            }
        });
        attrEditorPanel.addPropertyChangeListener("namespace", evt -> {
            this.setNamespace(colIdx, (String)evt.getNewValue());
            this.update();
        });
        attrEditorPanel.addPropertyChangeListener("attributeType", evt -> {
            this.setType(colIdx, (SourceColumnSemantic)((Object)((Object)evt.getNewValue())));
            this.update();
        });
        attrEditorPanel.addPropertyChangeListener("attributeDataType", evt -> {
            AttributeDataType newDataType = (AttributeDataType)((Object)((Object)evt.getNewValue()));
            if (newDataType.isList()) {
                this.setListDelimiter(colIdx, attrEditorPanel.getListDelimiter());
            }
            this.setDataType(colIdx, newDataType);
            this.update();
        });
        attrEditorPanel.addPropertyChangeListener("listDelimiter", evt -> {
            this.setListDelimiter(colIdx, (String)evt.getNewValue());
            this.update();
        });
        this.positionEditDialog();
        this.editDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PreviewTablePanel.this.getPreviewTable().getTableHeader().repaint();
                attrEditorPanel.getAttributeNameTextField().requestFocusInWindow();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                String name = ((PreviewTableModel)PreviewTablePanel.this.getPreviewTable().getModel()).getColumnName(colIdx);
                if (name == null || name.isBlank()) {
                    PreviewTablePanel.this.setType(colIdx, SourceColumnSemantic.NONE);
                    PreviewTablePanel.this.update();
                }
                PreviewTablePanel.this.getPreviewTable().getTableHeader().repaint();
            }
        });
        this.editDialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (PreviewTablePanel.this.editDialog != null) {
                    PreviewTablePanel.this.lastDialogIndex = PreviewTablePanel.this.editDialog.index;
                    PreviewTablePanel.this.lastDialogTime = System.currentTimeMillis();
                }
                PreviewTablePanel.this.disposeEditDialog();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.editDialog.pack();
        this.editDialog.setVisible(true);
    }

    private void positionEditDialog() {
        if (this.editDialog != null) {
            JTableHeader hd = this.getPreviewTable().getTableHeader();
            AccessibleComponent ac = hd.getAccessibleContext().getAccessibleChild(this.editDialog.index).getAccessibleContext().getAccessibleComponent();
            Point screenPt = ac.getLocationOnScreen();
            Point compPt = ac.getLocation();
            int xOffset = screenPt.x - compPt.x;
            int yOffset = screenPt.y - compPt.y + hd.getBounds().height;
            Point pt = ac.getBounds().getLocation();
            pt.translate(xOffset, yOffset);
            pt.x = Math.max(pt.x, this.getTableScrollPane().getLocationOnScreen().x - this.editDialog.getBounds().width);
            pt.x = Math.min(pt.x, this.getTableScrollPane().getLocationOnScreen().x + this.getTableScrollPane().getBounds().width);
            this.editDialog.setLocation(pt);
        }
    }

    protected void disposeEditDialog() {
        if (this.editDialog != null) {
            this.editDialog.getContentPane().removeAll();
            this.editDialog.dispose();
            this.editDialog = null;
        }
    }

    private void update(Sheet sheet) throws IOException {
        PreviewTableModel newModel = this.parseExcel(sheet, this.startLine);
        if (newModel.getRowCount() > 0) {
            String sheetName = sheet.getSheetName();
            this.dataTypes = TypeUtil.guessSheetDataTypes(newModel, this.decimalSeparator);
            this.types = TypeUtil.guessTypes(this.importType, newModel, this.dataTypes, this.getIgnoredTypes());
            this.listDelimiters = new String[newModel.getColumnCount()];
            this.namespaces = TypeUtil.getPreferredNamespaces(this.types);
            this.update(newModel, sheetName);
        }
        if (this.getPreviewTable() == null) {
            throw new IllegalStateException("No data found in the Excel sheets.");
        }
    }

    private void update(PreviewTableModel newModel, String name) {
        this.getPreviewTable().setName(name);
        this.getPreviewTable().setModel(newModel);
        ColumnResizer.adjustColumnPreferredWidths((JTable)this.getPreviewTable());
        this.update();
    }

    protected void update() {
        this.getPreviewTable().revalidate();
        this.getPreviewTable().repaint();
        this.getPreviewTable().getTableHeader().resizeAndRepaint();
        this.getSelectAllButton().setEnabled(false);
        this.getSelectNoneButton().setEnabled(false);
        if (this.types != null) {
            this.getSelectAllButton().setEnabled(Arrays.asList(this.types).contains((Object)SourceColumnSemantic.NONE));
            for (SourceColumnSemantic t : this.types) {
                if (t == SourceColumnSemantic.NONE) continue;
                this.getSelectNoneButton().setEnabled(true);
                break;
            }
        }
    }

    protected void updateKeyType() {
        block2: {
            SourceColumnSemantic[] newTypes;
            List currentTypes;
            block3: {
                String name = this.getPreviewTable().getName();
                PreviewTableModel model = (PreviewTableModel)this.getPreviewTable().getModel();
                if (name == null) break block2;
                currentTypes = this.types != null ? Arrays.asList(this.types) : Collections.emptyList();
                Set<SourceColumnSemantic> ignoredTypes = this.getIgnoredTypes();
                newTypes = TypeUtil.guessTypes(this.importType, model, this.dataTypes, ignoredTypes);
                if (!this.tableImportContext.isKeyRequired() || currentTypes.contains((Object)SourceColumnSemantic.KEY)) break block3;
                for (int i = 0; i < newTypes.length; ++i) {
                    if (newTypes[i] != SourceColumnSemantic.KEY) continue;
                    this.setType(i, SourceColumnSemantic.KEY);
                    this.update();
                    break block2;
                }
                break block2;
            }
            if (this.tableImportContext.isKeyRequired() || !currentTypes.contains((Object)SourceColumnSemantic.KEY)) break block2;
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] != SourceColumnSemantic.KEY) continue;
                this.setType(i, newTypes.length > i ? newTypes[i] : SourceColumnSemantic.NONE);
                this.update();
                break;
            }
        }
    }

    private Set<SourceColumnSemantic> getIgnoredTypes() {
        HashSet<SourceColumnSemantic> set = new HashSet<SourceColumnSemantic>();
        if (this.tableImportContext != null && !this.tableImportContext.isKeyRequired()) {
            set.add(SourceColumnSemantic.KEY);
        }
        return set;
    }

    private JComboBox<Sheet> getSheetComboBox() {
        if (this.sheetComboBox == null) {
            this.sheetComboBox = new JComboBox();
            this.sheetComboBox.setVisible(false);
            this.sheetComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(((Sheet)value).getSheetName());
                    return this;
                }
            });
            this.sheetComboBox.addActionListener(evt -> {
                if (!this.updating) {
                    this.disposeEditDialog();
                    Sheet sheet = (Sheet)this.sheetComboBox.getSelectedItem();
                    try {
                        if (sheet != null) {
                            this.update(sheet);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Cannot preview Excel sheet '" + sheet.getSheetName() + "'.", (Throwable)e);
                    }
                }
            });
        }
        return this.sheetComboBox;
    }

    private JButton getSelectAllButton() {
        if (this.selectAllButton == null) {
            this.selectAllButton = new JButton("Select All");
            this.selectAllButton.addActionListener(evt -> {
                this.disposeEditDialog();
                Set<SourceColumnSemantic> ignoredTypes = this.getIgnoredTypes();
                ignoredTypes.addAll(Arrays.asList(this.types));
                SourceColumnSemantic[] newTypes = TypeUtil.guessTypes(this.importType, this.getPreviewTable().getModel(), this.dataTypes, ignoredTypes);
                for (int i = 0; i < newTypes.length; ++i) {
                    if (this.types.length <= i || this.types[i] != SourceColumnSemantic.NONE) continue;
                    this.setType(i, newTypes[i]);
                }
                this.update();
            });
            if (LookAndFeelUtil.isAquaLAF()) {
                this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
                this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
            }
            this.selectAllButton.setEnabled(false);
        }
        return this.selectAllButton;
    }

    private JButton getSelectNoneButton() {
        if (this.selectNoneButton == null) {
            this.selectNoneButton = new JButton("Select None");
            this.selectNoneButton.addActionListener(evt -> {
                this.disposeEditDialog();
                this.fillTypes(SourceColumnSemantic.NONE);
                this.update();
            });
            if (LookAndFeelUtil.isAquaLAF()) {
                this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
                this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
            }
            this.selectNoneButton.setEnabled(false);
        }
        return this.selectNoneButton;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane(this.getPreviewTable());
            this.tableScrollPane.getHorizontalScrollBar().addAdjustmentListener(evt -> {
                if (!evt.getValueIsAdjusting()) {
                    this.positionEditDialog();
                }
            });
        }
        return this.tableScrollPane;
    }

    public class PreviewTableModel
    extends DefaultTableModel {
        private boolean firstRowNames;
        private Vector<Class<?>> predefinedClasses;

        public PreviewTableModel(Vector<Vector<String>> data, Vector<String> columnNames, Vector<Class<?>> columnTypes, boolean firstRowNames) {
            super(data, columnNames);
            this.firstRowNames = firstRowNames;
            this.predefinedClasses = columnTypes;
        }

        public PreviewTableModel(Vector<Vector<String>> data, Vector<String> columnNames, boolean firstRowNames) {
            this(data, columnNames, null, firstRowNames);
        }

        public boolean hasPredefinedTypes() {
            return this.predefinedClasses != null;
        }

        public Class<?> getPredefinedColumnClass(int column) {
            if (this.predefinedClasses != null && column < this.predefinedClasses.size()) {
                return this.predefinedClasses.get(column);
            }
            return String.class;
        }

        public void setColumnName(int column, String name) {
            if (this.columnIdentifiers.isEmpty()) {
                this.columnIdentifiers.setSize(this.getColumnCount());
            }
            if (this.columnIdentifiers.size() > column) {
                this.columnIdentifiers.set(column, name);
                this.fireTableChanged(new TableModelEvent(this));
            }
        }

        public void setFirstRowNames(boolean firstRowNames) {
            this.firstRowNames = firstRowNames;
            this.fireTableStructureChanged();
        }

        public boolean isFirstRowNames() {
            return this.firstRowNames;
        }

        @Override
        public int getRowCount() {
            return this.firstRowNames ? this.dataVector.size() - 1 : this.dataVector.size();
        }

        @Override
        public int getColumnCount() {
            return this.dataVector.size() > 0 ? ((Vector)this.dataVector.get(0)).size() : 0;
        }

        @Override
        public String getColumnName(int column) {
            Vector firstRow;
            Object colName = null;
            if (this.columnIdentifiers.size() > column) {
                colName = (String)this.columnIdentifiers.get(column);
            }
            if (colName == null && this.firstRowNames && this.dataVector.size() > 0 && (firstRow = (Vector)this.dataVector.get(0)) != null && firstRow.size() > column) {
                colName = (String)firstRow.get(column);
            }
            if (colName == null) {
                colName = "Column " + (column + 1);
            }
            return colName;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.firstRowNames) {
                ++row;
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (this.firstRowNames) {
                ++row;
            }
            super.setValueAt(aValue, row, column);
        }
    }

    private class PreviewTableCellRenderer
    extends DefaultTableCellRenderer {
        public PreviewTableCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.setFont(this.getFont().deriveFont(PreviewTablePanel.this.getColumnIndex(SourceColumnSemantic.KEY) == column ? 1 : 0));
            this.setText(value == null ? "" : value.toString());
            if (PreviewTablePanel.this.isImported(column)) {
                this.setForeground(table.getForeground());
            } else {
                this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            }
            AttributeDataType dataType = PreviewTablePanel.this.getDataType(column);
            if (dataType == AttributeDataType.TYPE_INTEGER || dataType == AttributeDataType.TYPE_LONG || dataType == AttributeDataType.TYPE_FLOATING) {
                this.setHorizontalAlignment(4);
            } else if (dataType == AttributeDataType.TYPE_BOOLEAN) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    private class PreviewTableHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel typeLabel;
        private final JLabel nameLabel;
        private final JLabel editLabel;

        PreviewTableHeaderRenderer() {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.nameLabel = new JLabel();
            this.nameLabel.setFont(UIManager.getFont("TableHeader.font"));
            this.typeLabel = new JLabel();
            this.typeLabel.setFont(PreviewTablePanel.this.iconManager.getIconFont(14.0f));
            this.editLabel = new JLabel("\uf0d9");
            this.editLabel.setFont(PreviewTablePanel.this.iconManager.getIconFont(12.0f));
            this.editLabel.setHorizontalAlignment(0);
            JLabel tempLabel = new JLabel("\uf0d7");
            tempLabel.setFont(PreviewTablePanel.this.iconManager.getIconFont(12.0f));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.editLabel, tempLabel});
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(6).addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel).addGap(5, 5, Short.MAX_VALUE).addComponent(this.editLabel).addGap(6));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.typeLabel).addComponent(this.nameLabel).addComponent(this.editLabel)).addGap(4));
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isS, boolean hasF, int row, int col) {
            this.nameLabel.setText(val != null && !val.toString().isBlank() ? val.toString() : "N/A");
            Color fgColor = UIManager.getColor("TableHeader.foreground");
            if (PreviewTablePanel.this.types != null && PreviewTablePanel.this.types.length > col) {
                SourceColumnSemantic type = PreviewTablePanel.this.types[col];
                if (type == null) {
                    type = SourceColumnSemantic.NONE;
                }
                AttributeDataType dataType = PreviewTablePanel.this.dataTypes != null && PreviewTablePanel.this.dataTypes.length > col ? PreviewTablePanel.this.dataTypes[col] : AttributeDataType.TYPE_STRING;
                this.typeLabel.setForeground(type.getForeground());
                this.typeLabel.setText(type.getText());
                this.setToolTipText("<html>" + type.getDescription() + " - <i>" + dataType.getDescription() + "</i></html>");
                if (type == SourceColumnSemantic.NONE) {
                    fgColor = UIManager.getColor("TextField.inactiveForeground");
                }
            } else {
                fgColor = UIManager.getColor("TextField.inactiveForeground");
            }
            if (PreviewTablePanel.this.editDialog != null && PreviewTablePanel.this.editDialog.index == col && PreviewTablePanel.this.editDialog.isVisible()) {
                this.editLabel.setText("\uf0d7");
            } else {
                this.editLabel.setText("\uf0d9");
            }
            this.nameLabel.setForeground(fgColor);
            this.invalidate();
            return this;
        }
    }

    private class EditDialog
    extends JDialog {
        final int index;
        final AttributeEditorPanel attrEditorPanel;

        EditDialog(AttributeEditorPanel attrEditorPanel, Window parent, int index) {
            super(parent, Dialog.ModalityType.MODELESS);
            this.index = index;
            this.attrEditorPanel = attrEditorPanel;
            this.setUndecorated(true);
            this.getContentPane().add(attrEditorPanel);
        }
    }
}

