/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.LoadNetworkReaderTask;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class NetworkCollectionHelper
extends AbstractTask {
    private LoadNetworkReaderTask importTask;
    private final CyServiceRegistrar serviceRegistrar;
    public static final String CREATE_NEW_COLLECTION_STRING = "-- Create new network collection --";
    protected HashMap<String, CyRootNetwork> name2RootMap;
    protected Map<Object, CyNode> nMap = new HashMap<Object, CyNode>(10000);
    public ListSingleSelection<String> rootNetworkList;
    public ListSingleSelection<String> targetColumnList;
    public ListSingleSelection<NetworkViewRenderer> rendererList;

    @Tunable(description="Network Collection", longDescription="The name of the network collection (root network) that the imported network should be part of. A name of ``-- Create new network collection --`` will result in the creation of a new network collection for this import.", exampleStringValue="-- Create new network collection --", groups={"Network"}, gravity=1.0)
    public ListSingleSelection<String> getRootNetworkList() {
        return this.rootNetworkList;
    }

    public void setRootNetworkList(ListSingleSelection<String> roots) {
        if (roots == this.rootNetworkList) {
            return;
        }
        String rootNetName = (String)roots.getSelectedValue();
        if (rootNetName != null && !rootNetName.equalsIgnoreCase(CREATE_NEW_COLLECTION_STRING)) {
            ListSingleSelection<String> tempList = this.getTargetColumns((CyNetwork)this.name2RootMap.get(rootNetName));
            if (!this.targetColumnList.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.targetColumnList.getPossibleValues().size() != tempList.getPossibleValues().size()) {
                this.setTargetColumnList(tempList);
            }
        } else {
            this.setTargetColumnList((ListSingleSelection<String>)new ListSingleSelection((Object[])new String[0]));
        }
        this.rootNetworkList = roots;
    }

    @Tunable(description="Node Identifier Mapping Column", longDescription="Enter the name of the column in the existing network collection (root network) that you want to map your input identifiers to.", exampleStringValue="share name", groups={"Network"}, gravity=2.0, listenForChange={"RootNetworkList"})
    public ListSingleSelection<String> getTargetColumnList() {
        return this.targetColumnList;
    }

    public void setTargetColumnList(ListSingleSelection<String> colList) {
        this.targetColumnList = colList;
    }

    @Tunable(description="Network View Renderer:", longDescription="Enter the network view renderer that this network should use.  This is only useful if multiple renderers have been installed, which is rare.", exampleStringValue="Cytoscape 2D", groups={"Network"}, gravity=3.0)
    public ListSingleSelection<NetworkViewRenderer> getNetworkViewRendererList() {
        return this.rendererList;
    }

    public void setNetworkViewRendererList(ListSingleSelection<NetworkViewRenderer> rendererList) {
        this.rendererList = rendererList;
    }

    public ListSingleSelection<String> getTargetColumns(CyNetwork network) {
        CyTable selectedTable = network.getTable(CyNode.class, "SHARED_ATTRS");
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : selectedTable.getColumns()) {
            if (col.getName().equalsIgnoreCase("SUID") || col.getName().endsWith(".SUID") || col.getType() != String.class && col.getType() != Integer.class && col.getType() != Long.class) continue;
            colNames.add(col.getName());
        }
        if (colNames.isEmpty() || colNames.size() == 1 && colNames.contains("shared name")) {
            return new ListSingleSelection((Object[])new String[0]);
        }
        this.sort(colNames);
        ListSingleSelection targetColumns = new ListSingleSelection(colNames);
        if (targetColumns.getPossibleValues().contains("shared name")) {
            targetColumns.setSelectedValue((Object)"shared name");
        }
        return targetColumns;
    }

    public NetworkCollectionHelper(CyServiceRegistrar serviceRegistrar) {
        this(null, serviceRegistrar);
    }

    public NetworkCollectionHelper(LoadNetworkReaderTask importTask, CyServiceRegistrar serviceRegistrar) {
        this.importTask = importTask;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    void init() {
        String rootNetName;
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyRootNetworkManager rootNetMgr = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        this.name2RootMap = this.getRootNetworkMap();
        ArrayList<String> rootNames = new ArrayList<String>();
        rootNames.addAll(this.name2RootMap.keySet());
        if (!rootNames.isEmpty()) {
            this.sort(rootNames);
            rootNames.add(0, CREATE_NEW_COLLECTION_STRING);
        }
        this.rootNetworkList = new ListSingleSelection(rootNames);
        CyNetwork net = appMgr != null ? appMgr.getCurrentNetwork() : null;
        CyRootNetwork rootNet = net != null ? rootNetMgr.getRootNetwork(net) : null;
        String string = rootNetName = rootNet != null ? (String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class) : CREATE_NEW_COLLECTION_STRING;
        if (rootNames.contains(rootNetName)) {
            this.rootNetworkList.setSelectedValue((Object)rootNetName);
        } else if (rootNames.contains(CREATE_NEW_COLLECTION_STRING)) {
            this.rootNetworkList.setSelectedValue((Object)CREATE_NEW_COLLECTION_STRING);
        }
        this.targetColumnList = rootNet != null ? this.getTargetColumns((CyNetwork)rootNet) : new ListSingleSelection((Object[])new String[0]);
        ArrayList renderers = new ArrayList();
        Set rendererSet = appMgr.getNetworkViewRendererSet();
        if (rendererSet.size() > 1) {
            renderers.addAll(rendererSet);
            Collections.sort(renderers, new Comparator<NetworkViewRenderer>(){

                @Override
                public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                    return r1.toString().compareToIgnoreCase(r2.toString());
                }
            });
        }
        this.rendererList = new ListSingleSelection(renderers);
        NetworkViewRenderer defViewRenderer = appMgr.getDefaultNetworkViewRenderer();
        if (defViewRenderer != null && renderers.contains(defViewRenderer)) {
            this.rendererList.setSelectedValue((Object)defViewRenderer);
        }
    }

    public CyRootNetwork getRootNetwork() {
        CyRootNetwork rootNetwork;
        String rootNetName = (String)this.rootNetworkList.getSelectedValue();
        if (rootNetName == null || rootNetName.equalsIgnoreCase(CREATE_NEW_COLLECTION_STRING)) {
            CyNetwork newNet = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork();
            rootNetwork = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(newNet);
        } else {
            rootNetwork = this.name2RootMap.get(rootNetName);
            if (rootNetwork == null) {
                throw new RuntimeException("Can't find a network collection named '" + rootNetName + "'");
            }
        }
        return rootNetwork;
    }

    public CyNetworkViewFactory getNetworkViewFactory() {
        if (this.rendererList != null && this.rendererList.getSelectedValue() != null) {
            return ((NetworkViewRenderer)this.rendererList.getSelectedValue()).getNetworkViewFactory();
        }
        return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getDefaultNetworkViewRenderer().getNetworkViewFactory();
    }

    protected void initNodeMap() {
        CyRootNetwork rootNetwork;
        String rootNetName = (String)this.rootNetworkList.getSelectedValue();
        if (rootNetName == null || rootNetName.equalsIgnoreCase(CREATE_NEW_COLLECTION_STRING)) {
            return;
        }
        String targetKeyColName = (String)this.targetColumnList.getSelectedValue();
        if (targetKeyColName == null) {
            targetKeyColName = "shared name";
        }
        if ((rootNetwork = this.name2RootMap.get(rootNetName)) == null) {
            return;
        }
        for (CyNode node : rootNetwork.getNodeList()) {
            Object keyValue = rootNetwork.getRow((CyIdentifiable)node).getRaw(targetKeyColName);
            if (keyValue == null) continue;
            this.nMap.put(keyValue.toString(), node);
        }
    }

    private HashMap<String, CyRootNetwork> getRootNetworkMap() {
        HashMap<String, CyRootNetwork> name2RootMap = new HashMap<String, CyRootNetwork>();
        Set networkSet = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        CyRootNetworkManager rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        for (CyNetwork net : networkSet) {
            CyRootNetwork rootNet = rootNetworkManager.getRootNetwork(net);
            if (name2RootMap.containsValue(rootNet)) continue;
            name2RootMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
        }
        return name2RootMap;
    }

    public void run(TaskMonitor monitor) throws Exception {
        this.initNodeMap();
        if (this.importTask != null) {
            this.importTask.setNodeMap(this.getNodeMap());
            this.importTask.setRootNetwork(this.getRootNetwork());
            this.importTask.setNetworkViewFactory(this.getNetworkViewFactory());
        }
    }

    public Map<Object, CyNode> getNodeMap() {
        return this.nMap;
    }

    private void sort(List<String> names) {
        if (!names.isEmpty()) {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return collator.compare(s1, s2);
                }
            });
        }
    }
}

