/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AbstractMappingParameters;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.reader.DefaultAttributeTableReader;
import org.cytoscape.tableimport.internal.reader.ExcelAttributeSheetReader;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.cytoscape.tableimport.internal.task.DelimitersTunable;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.ui.PreviewTablePanel;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class LoadTableReaderTask
extends AbstractTask
implements CyTableReader,
TunableValidator {
    private InputStream isStart;
    private InputStream isEnd;
    private String fileType;
    protected CyNetworkView[] cyNetworkViews;
    protected VisualStyle[] visualstyles;
    private String inputName;
    private PreviewTablePanel previewPanel;
    private CyTable[] cyTables;
    private static int numImports = 0;
    public AttributeMappingParameters amp;
    TextTableReader reader;
    @ContainsTunables
    public DelimitersTunable delimiters = new DelimitersTunable();
    @Tunable(description="Text Delimiters for data list type", longDescription="The delimiters between elements of list columns in the table.", exampleStringValue="'|'", context="both")
    public ListSingleSelection<String> delimitersForDataList;
    @Tunable(description="Start Load Row", longDescription="The first row of the input table to load.  This allows the skipping of headers that are not part of the import.", exampleStringValue="10", context="both")
    public int startLoadRow = -1;
    @Tunable(description="Key Column Index", longDescription="The column that contains the key values for this import.  These values will be used to match with the key values in the network.", exampleStringValue="1", context="both")
    public int keyColumnIndex = -1;
    @Tunable(description="First row used for column names", longDescription="If the first imported row contains column names, set this to ```true```.", exampleStringValue="true", context="both")
    public boolean firstRowAsColumnNames;
    @Tunable(description="List of column data types ordered by column index (e.g. \"string,int,long,double,boolean,intlist\" or just \"s,i,l,d,b,il\")", longDescription="List of column data types ordered by column index (e.g. \"string,int,long,double,boolean,intlist\" or just \"s,i,l,d,b,il\")", exampleStringValue="s,s,i", context="nongui")
    public String dataTypeList;
    @Tunable(description="Decimal character used in the decimal format in text files", longDescription="Character that separates the integer-part (characteristic) and the fractional-part (mantissa) of a decimal number. This can only be used with text files. The default value is the dot \".\"", exampleStringValue=".", context="nogui")
    public Character decimalSeparator;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public LoadTableReaderTask(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(TextDelimiter.PIPE.getDelimiter());
        tempList.add(TextDelimiter.BACKSLASH.getDelimiter());
        tempList.add(TextDelimiter.SLASH.getDelimiter());
        tempList.add(TextDelimiter.COMMA.getDelimiter());
        this.delimitersForDataList = new ListSingleSelection(tempList);
    }

    public LoadTableReaderTask(InputStream is, String fileType, String inputName, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this(tableImportContext, serviceRegistrar);
        this.setInputFile(is, fileType, inputName);
    }

    public void setInputFile(InputStream is, String fileType, String inputName) {
        this.fileType = fileType;
        this.inputName = inputName;
        this.isStart = is;
        this.previewPanel = new PreviewTablePanel(ImportType.TABLE_IMPORT, this.tableImportContext, (IconManager)this.serviceRegistrar.getService(IconManager.class));
        try {
            File tempFile = File.createTempFile("temp", this.fileType);
            tempFile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            this.isStart = new FileInputStream(tempFile);
            this.isEnd = new FileInputStream(tempFile);
        }
        catch (IOException e) {
            try {
                System.out.println("exceptioon catched!!");
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isStart = null;
            throw new IllegalStateException("Could not initialize object", e);
        }
        ArrayList<TextDelimiter> tempList = new ArrayList<TextDelimiter>();
        if (fileType.equals(".csv")) {
            tempList.add(TextDelimiter.COMMA);
        } else {
            tempList.add(TextDelimiter.TAB);
        }
        this.delimiters.setSelectedValues(tempList);
        this.delimitersForDataList.setSelectedValue((Object)TextDelimiter.PIPE.getDelimiter());
    }

    public void run(TaskMonitor tm) throws Exception {
        Object[] listDelimiters;
        Workbook workbook;
        ArrayList<Object> attrNameList;
        block24: {
            tm.setTitle("Loading table data");
            tm.setProgress(0.0);
            tm.setStatusMessage("Loading table...");
            attrNameList = new ArrayList<Object>();
            workbook = null;
            try {
                if (this.fileType == null || !this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) && !this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension()) || workbook != null) break block24;
                try {
                    workbook = WorkbookFactory.create((InputStream)this.isStart);
                    this.decimalSeparator = Character.valueOf('.');
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Could not read Excel file.  Maybe the file is broken?");
                }
                finally {
                    if (this.isStart != null) {
                        this.isStart.close();
                    }
                }
            }
            catch (Exception ioe) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unable to read table: " + ioe.getMessage());
                return;
            }
        }
        if (this.decimalSeparator == null) {
            this.decimalSeparator = AbstractMappingParameters.DEF_DECIMAL_SEPARATOR;
        }
        if (this.startLoadRow > 0) {
            --this.startLoadRow;
        }
        this.previewPanel.update(workbook, this.fileType, this.inputName, this.isStart, this.delimiters.getSelectedValues(), null, this.startLoadRow, this.decimalSeparator);
        int colCount = this.previewPanel.getPreviewTable().getColumnModel().getColumnCount();
        Object curName = null;
        if (this.firstRowAsColumnNames) {
            this.previewPanel.setFirstRowAsColumnNames();
            ++this.startLoadRow;
        }
        String sourceName = this.previewPanel.getSourceName();
        SourceColumnSemantic[] types = this.previewPanel.getTypes();
        for (int i = 0; i < colCount; ++i) {
            curName = this.previewPanel.getPreviewTable().getColumnModel().getColumn(i).getHeaderValue();
            if (attrNameList.contains(curName)) {
                int dupIndex = 0;
                for (int idx = 0; idx < attrNameList.size(); ++idx) {
                    if (!curName.equals(attrNameList.get(idx))) continue;
                    dupIndex = idx;
                    break;
                }
                if (!TypeUtil.allowsDuplicateName(ImportType.TABLE_IMPORT, types[i], types[dupIndex])) {
                    throw new Exception("Duplicate column name \"" + curName + "\".");
                }
            }
            if (curName == null) {
                attrNameList.add("Column " + i);
                continue;
            }
            attrNameList.add(curName.toString());
        }
        String[] attributeNames = attrNameList.toArray(new String[0]);
        SourceColumnSemantic[] typesCopy = Arrays.copyOf(types, types.length);
        AttributeDataType[] dataTypes = this.previewPanel.getDataTypes();
        AttributeDataType[] dataTypesCopy = Arrays.copyOf(dataTypes, dataTypes.length);
        AttributeDataType[] tunableDataTypes = null;
        if (this.dataTypeList != null && !this.dataTypeList.trim().isEmpty()) {
            tunableDataTypes = TypeUtil.parseDataTypeList(this.dataTypeList);
        }
        if (tunableDataTypes != null && tunableDataTypes.length > 0) {
            System.arraycopy(tunableDataTypes, 0, dataTypesCopy, 0, Math.min(tunableDataTypes.length, dataTypesCopy.length));
        }
        if ((listDelimiters = this.previewPanel.getListDelimiters()) == null || listDelimiters.length == 0) {
            listDelimiters = new String[dataTypes.length];
            if (this.delimitersForDataList.getSelectedValue() != null) {
                Arrays.fill(listDelimiters, this.delimitersForDataList.getSelectedValue());
            }
        }
        String[] namespaces = this.previewPanel.getNamespaces();
        String[] namespacesCopy = Arrays.copyOf(namespaces, namespaces.length);
        if (this.keyColumnIndex > 0) {
            --this.keyColumnIndex;
        }
        this.amp = new AttributeMappingParameters(sourceName, this.delimiters.getSelectedValues(), (String[])listDelimiters, this.keyColumnIndex, attributeNames, dataTypesCopy, typesCopy, namespacesCopy, this.startLoadRow, null, this.decimalSeparator);
        if (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) {
            Sheet sheet = workbook.getSheet(sourceName);
            if (sheet != null) {
                this.reader = new ExcelAttributeSheetReader(sheet, this.amp, this.serviceRegistrar);
                this.loadAnnotation(tm);
            }
        } else {
            this.reader = new DefaultAttributeTableReader(null, this.amp, this.isEnd, this.serviceRegistrar);
            this.loadAnnotation(tm);
        }
    }

    public CyTable[] getTables() {
        return this.cyTables;
    }

    private void loadAnnotation(TaskMonitor tm) {
        tm.setProgress(0.0);
        TextTableReader reader = this.reader;
        AttributeMappingParameters readerAMP = (AttributeMappingParameters)reader.getMappingParameter();
        int keyIndex = readerAMP.getKeyIndex();
        String pk = keyIndex >= 0 ? readerAMP.getAttributeNames()[keyIndex] : "SUID";
        AttributeDataType dataType = keyIndex >= 0 ? readerAMP.getDataTypes()[keyIndex] : AttributeDataType.TYPE_LONG;
        Class keyType = switch (dataType) {
            case AttributeDataType.TYPE_INTEGER -> Integer.class;
            case AttributeDataType.TYPE_LONG -> Long.class;
            default -> String.class;
        };
        tm.setProgress(0.1);
        CyTableFactory tableFactory = (CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class);
        CyTable table = tableFactory.createTable("AttrTable " + this.inputName.substring(this.inputName.lastIndexOf(47) + 1) + " " + Integer.toString(numImports++), pk, keyType, true, true);
        this.cyTables = new CyTable[]{table};
        tm.setProgress(0.3);
        try {
            this.reader.readTable(table);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tm.setProgress(1.0);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.tableImportContext.isKeyRequired() && this.keyColumnIndex <= 0) {
            try {
                errMsg.append("The primary key column needs to be selected. Please select values from 1 to the number of columns");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.startLoadRow < 0) {
            try {
                errMsg.append("The row that will be used as starting point needs to be selected.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }
}

