/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.File;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedEvent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.io.read.CyTableReaderManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.CombineTableReaderAndMappingTask;
import org.cytoscape.tableimport.internal.task.ImportTableDataTask;
import org.cytoscape.tableimport.internal.task.LoadTableFileTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.task.read.LoadTableFileTaskFactory;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class LoadTableFileTaskFactoryImpl
extends AbstractTaskFactory
implements LoadTableFileTaskFactory,
CytoPanelComponentSelectedListener {
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public LoadTableFileTaskFactoryImpl(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(2, new Task[]{new LoadTableFileTask(this.tableImportContext, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(File file) {
        CyTableReaderManager tableReaderMgr = (CyTableReaderManager)this.serviceRegistrar.getService(CyTableReaderManager.class);
        CyTableReader reader = tableReaderMgr.getReader(file.toURI(), file.toURI().toString());
        return new TaskIterator(new Task[]{new CombineTableReaderAndMappingTask(reader, this.tableImportContext, this.serviceRegistrar)});
    }

    public void handleEvent(CytoPanelComponentSelectedEvent evt) {
        CytoPanel cytoPanel = evt.getCytoPanel();
        int idx = evt.getSelectedIndex();
        if (cytoPanel.getCytoPanelName() != CytoPanelName.SOUTH || idx < 0 || idx >= cytoPanel.getCytoPanelComponentCount()) {
            return;
        }
        if (idx == cytoPanel.indexOfComponent("org.cytoscape.NodeTables")) {
            this.tableImportContext.setTableType(ImportTableDataTask.TableType.NODE_ATTR);
        } else if (idx == cytoPanel.indexOfComponent("org.cytoscape.EdgeTables")) {
            this.tableImportContext.setTableType(ImportTableDataTask.TableType.EDGE_ATTR);
        } else if (idx == cytoPanel.indexOfComponent("org.cytoscape.NetworkTables")) {
            this.tableImportContext.setTableType(ImportTableDataTask.TableType.NETWORK_ATTR);
        } else if (idx == cytoPanel.indexOfComponent("org.cytoscape.UnassignedTables")) {
            this.tableImportContext.setTableType(null);
        }
    }
}

