/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.ImportTableDataTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.task.AbstractTableTaskFactory;
import org.cytoscape.task.edit.ImportDataTableTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class ImportTableDataTaskFactoryImpl
extends AbstractTableTaskFactory
implements ImportDataTableTaskFactory {
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public ImportTableDataTaskFactoryImpl(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyTable table) {
        return new TaskIterator(new Task[]{new ImportTableDataTask(table, this.tableImportContext, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(CyTableReader reader) {
        return new TaskIterator(new Task[]{new ImportTableDataTask(reader, this.tableImportContext, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(CyTable globalTable, boolean selectedNetworksOnly, boolean loadToUnassignedTable, List<CyNetwork> networkList, CyRootNetwork rootNetwork, CyColumn targetJoinColumn, Class<? extends CyIdentifiable> type) {
        ListSingleSelection chooser = new ListSingleSelection((Object[])new String[]{"To a Network Collection", "To selected networks only", "To an unassigned table"});
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (!loadToUnassignedTable) {
            ImportTableDataTask.TableType tableType = this.getTableType(type);
            if (tableType == null) {
                throw new IllegalArgumentException("The specified type " + type + " is not acceptable.");
            }
            ListSingleSelection tableTypes = new ListSingleSelection((Object[])new ImportTableDataTask.TableType[]{tableType});
            tableTypes.setSelectedValue((Object)tableType);
            ArrayList<String> networkNames = new ArrayList<String>();
            for (CyNetwork net : networkList) {
                networkNames.add((String)net.getRow((CyIdentifiable)net).get("name", String.class));
            }
            ListMultipleSelection networksListTunable = new ListMultipleSelection(networkNames);
            networksListTunable.setSelectedValues(networkNames);
            ArrayList<String> rootNetworkNames = new ArrayList<String>();
            ListSingleSelection rootNetworkList = new ListSingleSelection((Object[])new String[0]);
            if (rootNetwork != null) {
                rootNetworkNames.add((String)rootNetwork.getRow((CyIdentifiable)rootNetwork).get("name", String.class));
                rootNetworkList = new ListSingleSelection(rootNetworkNames);
                rootNetworkList.setSelectedValue((Object)((String)rootNetworkNames.get(0)));
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            ListSingleSelection columnNamesList = new ListSingleSelection((Object[])new String[0]);
            if (targetJoinColumn != null) {
                columnNames.add(targetJoinColumn.getName());
                columnNamesList = new ListSingleSelection(columnNames);
                columnNamesList.setSelectedValue((Object)((String)columnNames.get(0)));
            }
            if (selectedNetworksOnly) {
                m.put("DataTypeTargetForNetworkList", tableTypes);
                chooser.setSelectedValue((Object)"To selected networks only");
            } else {
                m.put("DataTypeTargetForNetworkCollection", tableTypes);
                chooser.setSelectedValue((Object)"To a Network Collection");
            }
            m.put("TargetNetworkList", networksListTunable);
            m.put("KeyColumnForMapping", columnNamesList);
            m.put("TargetNetworkCollection", rootNetworkList);
        } else {
            chooser.setSelectedValue((Object)"To an unassigned table");
        }
        m.put("WhereImportTable", chooser);
        TunableSetter tunableSetter = (TunableSetter)this.serviceRegistrar.getService(TunableSetter.class);
        return tunableSetter.createTaskIterator(this.createTaskIterator(globalTable), m);
    }

    private ImportTableDataTask.TableType getTableType(Class<? extends CyIdentifiable> type) {
        if (type.equals(ImportTableDataTask.TableType.EDGE_ATTR.getType())) {
            return ImportTableDataTask.TableType.EDGE_ATTR;
        }
        if (type.equals(ImportTableDataTask.TableType.NETWORK_ATTR.getType())) {
            return ImportTableDataTask.TableType.NETWORK_ATTR;
        }
        if (type.equals(ImportTableDataTask.TableType.NODE_ATTR.getType())) {
            return ImportTableDataTask.TableType.NODE_ATTR;
        }
        return null;
    }
}

