/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.reader.DefaultAttributeTableReader;
import org.cytoscape.tableimport.internal.reader.ExcelAttributeSheetReader;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;

public class ImportAttributeTableReaderTask
extends AbstractTask
implements CyTableReader,
TunableValidator {
    private InputStream is;
    private final String fileType;
    protected CyNetworkView[] cyNetworkViews;
    protected VisualStyle[] visualstyles;
    private final String inputName;
    private CyTable[] cyTables;
    private static int numImports;
    @Tunable(description="Attribute Mapping Parameters:")
    public AttributeMappingParameters amp;
    TextTableReader reader;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public ImportAttributeTableReaderTask(InputStream is, String fileType, String inputName, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.fileType = fileType;
        this.inputName = inputName;
        this.is = is;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        try {
            File tempFile = File.createTempFile("temp", this.fileType);
            tempFile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            this.amp = new AttributeMappingParameters(new FileInputStream(tempFile), fileType);
            this.is = new FileInputStream(tempFile);
        }
        catch (IOException e) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
            throw new IllegalStateException("Could not initialize object", e);
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Load Table");
        tm.setProgress(0.0);
        tm.setStatusMessage("Loading table...");
        Workbook workbook = null;
        if (this.fileType != null && (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) && workbook == null) {
            try {
                workbook = WorkbookFactory.create((InputStream)this.is);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not read Excel file.  Maybe the file is broken?");
            }
            finally {
                if (this.is != null) {
                    this.is.close();
                }
            }
        }
        if (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) {
            Sheet sheet;
            String networkName = this.amp.getName();
            if (networkName == null) {
                networkName = workbook.getSheetName(0);
            }
            if ((sheet = workbook.getSheet(networkName)) != null) {
                this.reader = new ExcelAttributeSheetReader(sheet, this.amp, this.serviceRegistrar);
                this.loadAnnotation(tm);
            }
        } else {
            try {
                this.reader = new DefaultAttributeTableReader(null, this.amp, this.is, this.serviceRegistrar);
                this.loadAnnotation(tm);
            }
            catch (Exception ioe) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unable to read table: " + ioe.getMessage());
            }
        }
    }

    public CyTable[] getTables() {
        return this.cyTables;
    }

    private void loadAnnotation(TaskMonitor tm) {
        tm.setProgress(0.0);
        TextTableReader reader = this.reader;
        AttributeMappingParameters readerAMP = (AttributeMappingParameters)reader.getMappingParameter();
        int keyIndex = readerAMP.getKeyIndex();
        String primaryKey = keyIndex >= 0 ? readerAMP.getAttributeNames()[keyIndex] : "SUID";
        AttributeDataType dataType = keyIndex >= 0 ? readerAMP.getDataTypes()[keyIndex] : AttributeDataType.TYPE_LONG;
        Class keyType = switch (dataType) {
            case AttributeDataType.TYPE_INTEGER -> Integer.class;
            case AttributeDataType.TYPE_LONG -> Long.class;
            default -> String.class;
        };
        tm.setProgress(0.1);
        CyTable table = ((CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class)).createTable("AttrTable " + this.inputName.substring(this.inputName.lastIndexOf(47) + 1) + " " + Integer.toString(numImports++), primaryKey, keyType, true, true);
        this.cyTables = new CyTable[]{table};
        tm.setProgress(0.3);
        try {
            this.reader.readTable(table);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tm.setProgress(1.0);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        int minColCount;
        if (this.tableImportContext.isKeyRequired()) {
            if (this.amp.getKeyIndex() == -1) {
                try {
                    errMsg.append("The primary key column needs to be selected.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return TunableValidator.ValidationState.INVALID;
                }
                return TunableValidator.ValidationState.INVALID;
            }
            AttributeDataType keyDataType = this.amp.getDataTypes()[this.amp.getKeyIndex()];
            if (!TypeUtil.isValid(SourceColumnSemantic.KEY, keyDataType)) {
                try {
                    errMsg.append("The primary key column must be an Integer, Long or String.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return TunableValidator.ValidationState.INVALID;
                }
                return TunableValidator.ValidationState.INVALID;
            }
        }
        int n = minColCount = this.tableImportContext.isKeyRequired() ? 2 : 1;
        if (this.amp.getSelectedColumnCount() < minColCount) {
            try {
                errMsg.append("Table must have " + (minColCount > 1 ? "more than" : "at least") + " one column. Please check the selected delimeters and columns.");
            }
            catch (IOException e) {
                e.printStackTrace();
                return TunableValidator.ValidationState.INVALID;
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }
}

