/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AttributeLineParser;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.reader.MappingParameter;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAttributeSheetReader
implements TextTableReader {
    private final Sheet sheet;
    private final AttributeMappingParameters mapping;
    private final AttributeLineParser parser;
    private final DataFormatter formatter;
    private final FormulaEvaluator evaluator;
    private final int startLineNumber;
    private int globalCounter = 0;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public ExcelAttributeSheetReader(Sheet sheet, AttributeMappingParameters mapping, CyServiceRegistrar serviceRegistrar) {
        this.sheet = sheet;
        this.mapping = mapping;
        this.startLineNumber = mapping.getStartLineNumber();
        this.parser = new AttributeLineParser(mapping, serviceRegistrar);
        this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        this.formatter = new DataFormatter();
    }

    private String formatCell(Cell cell, AttributeDataType cellDT) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            if (this.evaluator == null) {
                return cell.getCellFormula();
            }
            cellType = this.evaluator.evaluateFormulaCell(cell);
        }
        switch (cellType) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return this.formatter.formatCellValue(cell, this.evaluator);
                }
                BigDecimal val = BigDecimal.valueOf(cell.getNumericCellValue());
                if (cellDT == AttributeDataType.TYPE_INTEGER) {
                    return String.valueOf(val.intValue());
                }
                if (cellDT == AttributeDataType.TYPE_LONG) {
                    return String.valueOf(val.longValue());
                }
                if (cellDT == AttributeDataType.TYPE_FLOATING) {
                    return String.valueOf(val.doubleValue());
                }
                return this.formatter.formatCellValue(cell);
            }
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList(this.mapping.getAttributeNames());
    }

    @Override
    public void readTable(CyTable table) throws IOException {
        Row row;
        int rowCount = this.startLineNumber;
        while ((row = this.sheet.getRow(rowCount)) != null) {
            String[] cellsInOneRow = this.createElementStringArray(row);
            try {
                this.parser.parseAll(table, cellsInOneRow);
            }
            catch (Exception ex) {
                logger.warn("Couldn't parse row: " + rowCount, (Throwable)ex);
            }
            ++rowCount;
            ++this.globalCounter;
        }
    }

    private String[] createElementStringArray(Row row) {
        String[] cells = new String[this.mapping.getColumnCount()];
        Cell cell = null;
        for (int i = 0; i < this.mapping.getColumnCount(); i = (int)((short)(i + 1))) {
            cell = row.getCell(i);
            cells[i] = cell == null || cell.getCellType() == CellType.ERROR || cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() == CellType.ERROR ? null : this.formatCell(cell, this.mapping.getDataTypes()[i]);
        }
        return cells;
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> invalid = this.parser.getInvalidMap();
        sb.append(this.globalCounter + " entries are loaded and mapped into table.");
        int limit = 10;
        if (invalid.size() > 0) {
            sb.append("\n\nThe following enties are invalid and were not imported:\n");
            for (String key : invalid.keySet()) {
                sb.append(key + " = " + invalid.get(key) + "\n");
                if (limit-- > 0) continue;
                sb.append("Approximately " + (invalid.size() - 10) + " additional entries were not imported...");
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public MappingParameter getMappingParameter() {
        return this.mapping;
    }
}

