/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AttributeLineParser;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.reader.MappingParameter;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.cytoscape.tableimport.internal.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttributeTableReader
implements TextTableReader {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final URL source;
    private AttributeMappingParameters mapping;
    private final AttributeLineParser parser;
    private int globalCounter;
    private final int startLineNumber;
    private String commentChar;
    private InputStream is;

    public DefaultAttributeTableReader(URL source, AttributeMappingParameters mapping, int startLineNumber, String commentChar, CyServiceRegistrar serviceRegistrar) {
        this.source = source;
        this.mapping = mapping;
        this.startLineNumber = startLineNumber;
        this.parser = new AttributeLineParser(mapping, serviceRegistrar);
        this.commentChar = commentChar;
    }

    public DefaultAttributeTableReader(URL source, AttributeMappingParameters mapping, InputStream is, CyServiceRegistrar serviceRegistrar) {
        this.source = source;
        this.mapping = mapping;
        this.startLineNumber = mapping.getStartLineNumber();
        this.parser = new AttributeLineParser(mapping, serviceRegistrar);
        this.commentChar = mapping.getCommentChar();
        this.is = is;
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList(this.mapping.getAttributeNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTable(CyTable table) throws IOException {
        block22: {
            try {
                BufferedReader bufRd = null;
                if (this.is == null) {
                    this.is = URLUtil.getInputStream(this.source);
                }
                try {
                    String line;
                    int lineCount = 0;
                    bufRd = new BufferedReader(new InputStreamReader(this.is, Charset.forName("UTF-8").newDecoder()));
                    String delimiter = this.mapping.getDelimiterRegEx();
                    if (delimiter.contains(TextDelimiter.COMMA.getDelimiter()) && this.mapping.getDelimiters().size() == 1) {
                        String[] rowData;
                        CSVReader reader = new CSVReader((Reader)bufRd);
                        while ((rowData = reader.readNext()) != null) {
                            if (lineCount >= this.startLineNumber && rowData.length >= this.mapping.getKeyIndex() + 1) {
                                try {
                                    this.parser.parseAll(table, rowData);
                                }
                                catch (Exception ex) {
                                    logger.warn("Couldn't parse row from OpenCSV: " + lineCount);
                                }
                                ++this.globalCounter;
                            }
                            ++lineCount;
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception ex) {}
                        break block22;
                    }
                    String[] parts = null;
                    while ((line = bufRd.readLine()) != null) {
                        if (!(this.commentChar != null && line.startsWith(this.commentChar) || lineCount < this.startLineNumber || line.trim().length() <= 0 || (parts = line.split(delimiter)).length < this.mapping.getKeyIndex() + 1)) {
                            try {
                                this.parser.parseAll(table, parts);
                            }
                            catch (Exception ex) {
                                logger.warn("Couldn't parse row: " + lineCount);
                            }
                            ++this.globalCounter;
                        }
                        ++lineCount;
                    }
                }
                catch (MalformedInputException mie) {
                    throw new IOException("Unable to import table: illegal character encoding in input");
                }
                finally {
                    if (bufRd != null) {
                        bufRd.close();
                    }
                }
            }
            finally {
                if (this.is != null) {
                    this.is.close();
                }
            }
        }
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> invalid = this.parser.getInvalidMap();
        sb.append(this.globalCounter + " entries are loaded and mapped into table.");
        if (invalid.size() > 0) {
            sb.append("\n\nThe following enties are invalid and were not imported:\n");
            int limit = 10;
            for (String key : invalid.keySet()) {
                sb.append(key + " = " + invalid.get(key) + "\n");
                if (limit-- > 0) continue;
                sb.append("Approximately " + (invalid.size() - 10) + " additional entries were not imported...");
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public MappingParameter getMappingParameter() {
        return this.mapping;
    }
}

