/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;

public class WildCardCyFileFilter
extends BasicCyFileFilter {
    private List<String> blackList = new ArrayList<String>();

    public WildCardCyFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public WildCardCyFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public void setBlacklist(String ... extensions) {
        this.blackList = Arrays.asList(extensions);
    }

    public boolean accepts(URI uri, DataCategory category) {
        if (category != this.category) {
            return false;
        }
        if (!this.extensionsMatch(uri)) {
            return false;
        }
        return this.contentTypeMatch(uri);
    }

    private boolean contentTypeMatch(URI uri) {
        if (this.contentTypes.isEmpty()) {
            return true;
        }
        if (!WildCardCyFileFilter.isFile(uri)) {
            return true;
        }
        File file = new File(uri);
        String type = URLConnection.guessContentTypeFromName(file.getName());
        if (type == null) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                type = URLConnection.guessContentTypeFromStream(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (type == null) {
                type = "";
            }
        }
        return this.contentTypes.contains(type.toLowerCase());
    }

    private boolean extensionsMatch(URI uri) {
        String extension = this.getExtension(uri.toString());
        if (this.blackList.contains(extension)) {
            return false;
        }
        return this.extensions.contains("") || this.extensions.contains(extension);
    }

    private static boolean isFile(URI uri) {
        return uri.getScheme().equals("file");
    }
}

