/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal;

import java.awt.Font;
import java.util.Properties;
import javax.swing.Icon;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.read.AbstractInputStreamTaskFactory;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.io.WildCardCyFileFilter;
import org.cytoscape.tableimport.internal.task.ImportAttributeTableReaderFactory;
import org.cytoscape.tableimport.internal.task.ImportNetworkTableReaderFactory;
import org.cytoscape.tableimport.internal.task.ImportNoGuiNetworkReaderFactory;
import org.cytoscape.tableimport.internal.task.ImportNoGuiTableReaderFactory;
import org.cytoscape.tableimport.internal.task.ImportTableDataTaskFactoryImpl;
import org.cytoscape.tableimport.internal.task.LoadTableFileTaskFactoryImpl;
import org.cytoscape.tableimport.internal.task.LoadTableURLTaskFactoryImpl;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.tunable.AttributeMappingParametersHandlerFactory;
import org.cytoscape.tableimport.internal.tunable.NetworkTableMappingParametersHandlerFactory;
import org.cytoscape.tableimport.internal.util.IconUtil;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.task.edit.ImportDataTableTaskFactory;
import org.cytoscape.task.read.LoadTableFileTaskFactory;
import org.cytoscape.task.read.LoadTableURLTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.swing.GUITunableHandlerFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private static float LARGE_ICON_FONT_SIZE = 32.0f;
    private static int LARGE_ICON_SIZE = 32;
    private Font iconFont;

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        StreamUtil streamUtil = (StreamUtil)this.getService(bc, StreamUtil.class);
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        this.iconFont = iconManager.getIconFont("cytoscape-3", LARGE_ICON_FONT_SIZE);
        TableImportContext tableImportContext = new TableImportContext();
        TableImportContext netImportContext = new TableImportContext(false);
        WildCardCyFileFilter filter = new WildCardCyFileFilter(new String[]{"xls", "xlsx"}, new String[]{"application/excel", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, "Excel", DataCategory.TABLE, streamUtil);
        AbstractInputStreamTaskFactory factory = new ImportAttributeTableReaderFactory((CyFileFilter)filter, tableImportContext, serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("readerDescription", "Attribute Table file reader");
        props.setProperty("readerId", "attributeTableReader");
        this.registerService(bc, factory, InputStreamTaskFactory.class, props);
        filter = new WildCardCyFileFilter(new String[]{"csv", "tsv", "txt", "tab", "net", ""}, new String[]{"text/csv", "text/tab-separated-values", "text/plain", ""}, "Comma or Tab Separated Value", DataCategory.TABLE, streamUtil);
        filter.setBlacklist("xml", "xgmml", "rdf", "owl", "zip", "rar", "jar", "doc", "docx", "ppt", "pptx", "pdf", "jpg", "jpeg", "gif", "png", "svg", "tiff", "ttf", "mp3", "mp4", "mpg", "mpeg", "exe", "dmg", "iso", "cys");
        factory = new ImportAttributeTableReaderFactory((CyFileFilter)filter, tableImportContext, serviceRegistrar);
        props = new Properties();
        props.setProperty("readerDescription", "Attribute Table file reader");
        props.setProperty("readerId", "attributeTableReader_txt");
        this.registerService(bc, factory, InputStreamTaskFactory.class, props);
        filter = new WildCardCyFileFilter(new String[]{"csv", "tsv", "txt", ""}, new String[]{"text/csv", "text/tab-separated-values", "text/plain", ""}, "Comma or Tab Separated Value", DataCategory.NETWORK, streamUtil);
        filter.setBlacklist("xml", "xgmml", "rdf", "owl", "zip", "rar", "jar", "doc", "docx", "ppt", "pptx", "pdf", "jpg", "jpeg", "gif", "png", "svg", "tiff", "ttf", "mp3", "mp4", "mpg", "mpeg", "exe", "dmg", "iso", "cys");
        factory = new ImportNetworkTableReaderFactory((CyFileFilter)filter, serviceRegistrar);
        props = new Properties();
        props.setProperty("readerDescription", "Network Table file reader");
        props.setProperty("readerId", "networkTableReader_txt");
        this.registerService(bc, factory, InputStreamTaskFactory.class, props);
        filter = new WildCardCyFileFilter(new String[]{"xls", "xlsx"}, new String[]{"application/excel", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, "Excel", DataCategory.NETWORK, streamUtil);
        factory = new ImportNetworkTableReaderFactory((CyFileFilter)filter, serviceRegistrar);
        props = new Properties();
        props.setProperty("readerDescription", "Network Table file reader");
        props.setProperty("readerId", "networkTableReader_xls");
        this.registerService(bc, factory, InputStreamTaskFactory.class, props);
        Object factory2 = new AttributeMappingParametersHandlerFactory(ImportType.TABLE_IMPORT, tableImportContext, serviceRegistrar);
        this.registerService(bc, factory2, GUITunableHandlerFactory.class);
        factory2 = new NetworkTableMappingParametersHandlerFactory(ImportType.NETWORK_IMPORT, netImportContext, serviceRegistrar);
        this.registerService(bc, factory2, GUITunableHandlerFactory.class);
        factory2 = new ImportNoGuiTableReaderFactory(false, tableImportContext, serviceRegistrar);
        Properties props2 = new Properties();
        props2.setProperty("command", "import file");
        props2.setProperty("commandNamespace", "table");
        props2.setProperty("commandDescription", "Import a table from a file");
        props2.setProperty("commandLongDescription", "This uses a long list of input parameters to specify the attributes of the table, the mapping keys, and the destination table for the input.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"mappedTables\":[101,102]}");
        this.registerService(bc, factory2, TaskFactory.class, props2);
        ImportNoGuiTableReaderFactory importURLTableFactory = new ImportNoGuiTableReaderFactory(true, tableImportContext, serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("command", "import url");
        props2.setProperty("commandNamespace", "table");
        props2.setProperty("commandDescription", "Import a table from a URL");
        props2.setProperty("commandLongDescription", "Similar to Import Table this uses a long list of input parameters to specify the attributes of the table, the mapping keys, and the destination table for the input.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"mappedTables\":[101,102]}");
        this.registerService(bc, (Object)importURLTableFactory, TaskFactory.class, props2);
        factory2 = new ImportNoGuiNetworkReaderFactory(false, tableImportContext, serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("command", "import file");
        props2.setProperty("commandNamespace", "network");
        props2.setProperty("commandDescription", "Import a network from a file");
        props2.setProperty("commandLongDescription", "Import a new network from a tabular formatted file type (e.g. ``csv``, ``tsv``, ``Excel``, etc.).  Use ``network load file`` to load network formatted files.  This command will create a new network collection if no current network collection is selected, otherwise it will add the network to the current collection. The SUIDs of the new networks and views are returned.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ \"networks\":[101,102,103],\"views\":[200,201,204] }");
        this.registerService(bc, factory2, TaskFactory.class, props2);
        factory2 = new ImportNoGuiNetworkReaderFactory(true, tableImportContext, serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("command", "import url");
        props2.setProperty("commandNamespace", "network");
        props2.setProperty("commandDescription", "Import a network from a URL");
        props2.setProperty("commandLongDescription", "Import a new network from a URL that points to a tabular formatted file type (e.g. ``csv``, ``tsv``, ``Excel``, etc.).  Use ``network load url`` to load network formatted files.  This command will create a new network collection if no current network collection is selected, otherwise it will add the network to the current collection. The SUIDs of the new networks and views are returned.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ \"networks\":[101,102,103],\"views\":[200,201,204] }");
        this.registerService(bc, factory2, TaskFactory.class, props2);
        factory2 = new LoadTableFileTaskFactoryImpl(tableImportContext, serviceRegistrar);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_IMPORT_TABLE, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        String iconId = "cy::IMPORT_FILE_TABLE";
        iconManager.addIcon(iconId, (Icon)icon);
        Properties props3 = new Properties();
        props3.setProperty("preferredMenu", "File.Import[23.0]");
        props3.setProperty("title", "Table from File...");
        props3.setProperty("menuGravity", "5.1");
        props3.setProperty("insertSeparatorBefore", "true");
        props3.setProperty("largeIconID", iconId);
        props3.setProperty("inToolBar", "true");
        props3.setProperty("toolBarGravity", "2.1");
        props3.setProperty("tooltip", "Import Table from File");
        props3.setProperty("tooltipLongDescription", "Reads a table from the file system and adds it to the current session.");
        props3.setProperty("commandLongDescription", "Reads a table from the file system.  Requires a string containing the absolute path of the file. Returns the SUID of the table created.");
        props3.setProperty("commandSupportsJSON", "true");
        props3.setProperty("commandExampleJSON", "{\"mappedTables\": [101,102]}");
        this.registerService(bc, factory2, TaskFactory.class, props3);
        this.registerService(bc, factory2, LoadTableFileTaskFactory.class, props3);
        this.registerService(bc, factory2, CytoPanelComponentSelectedListener.class);
        factory2 = new LoadTableFileTaskFactoryImpl(tableImportContext, serviceRegistrar);
        icon = new TextIcon(",", this.iconFont.deriveFont(22.0f), 32, 31);
        iconId = "cy::Table::IMPORT_TABLE";
        iconManager.addIcon(iconId, (Icon)icon);
        props3 = new Properties();
        props3.setProperty("inNodeTableToolBar", "true");
        props3.setProperty("inEdgeTableToolBar", "true");
        props3.setProperty("inNetworkTableToolBar", "true");
        props3.setProperty("inUnassignedTableToolBar", "true");
        props3.setProperty("toolBarGravity", "0.006");
        props3.setProperty("largeIconID", iconId);
        props3.setProperty("tooltip", "Import Table from File...");
        props3.setProperty("insertToolbarSeparatorBefore", "true");
        this.registerService(bc, factory2, TaskFactory.class, props3);
        factory2 = new LoadTableURLTaskFactoryImpl(tableImportContext, serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("preferredMenu", "File.Import[23.0]");
        props2.setProperty("menuGravity", "6.0");
        props2.setProperty("title", "Table from URL...");
        props2.setProperty("tooltip", "Import Table From URL");
        props2.setProperty("commandLongDescription", "Reads a table from the Internet.  Requires a valid URL pointing to the file. Returns the SUID of the table created.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"mappedTables\": [101,102]}");
        this.registerService(bc, factory2, TaskFactory.class, props2);
        this.registerService(bc, factory2, LoadTableURLTaskFactory.class, props2);
        factory2 = new ImportTableDataTaskFactoryImpl(tableImportContext, serviceRegistrar);
        this.registerService(bc, factory2, ImportDataTableTaskFactory.class);
    }
}

