/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.view;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;
import org.cytoscape.work.internal.view.RoundedProgressBar;

public class TaskDialog
extends JDialog {
    public static final String CANCEL_EVENT = "task-cancel-event";
    public static final String CLOSE_EVENT = "task-close-event";
    private static final int PREF_LABEL_WIDTH = 500;
    volatile boolean errorOccurred = false;
    private final JLabel titleLabel;
    private final JLabel subtitleLabel;
    private final RoundedProgressBar progressBar;
    private final JLabel msgIconLabel;
    private final JTextArea msgArea;
    private final JLabel cancelLabel;
    private final JButton cancelButton;
    private final JButton closeButton;

    private static JLabel newLabelWithFont(int style, float sizeFactor) {
        Font font = UIManager.getFont("Label.font");
        font = font.deriveFont((float)font.getSize() * sizeFactor).deriveFont(style);
        JLabel label = new JLabel();
        label.setFont(font);
        return label;
    }

    public TaskDialog(Window parent, CyServiceRegistrar serviceRegistrar) {
        super(parent, "Cytoscape Task", DEFAULT_MODALITY_TYPE);
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.titleLabel = TaskDialog.newLabelWithFont(0, 1.5f);
        this.subtitleLabel = TaskDialog.newLabelWithFont(0, 1.0f);
        this.subtitleLabel.setVisible(false);
        this.progressBar = new RoundedProgressBar();
        this.progressBar.setIndeterminate();
        this.msgIconLabel = new JLabel();
        this.msgIconLabel.setFont(iconManager.getIconFont(16.0f));
        this.msgArea = new JTextArea();
        this.msgArea.setEditable(false);
        this.msgArea.setHighlighter(null);
        this.msgArea.setBorder(null);
        this.msgArea.setLineWrap(true);
        this.msgArea.setWrapStyleWord(true);
        this.msgArea.setOpaque(false);
        if (LookAndFeelUtil.isNimbusLAF()) {
            this.msgArea.setBackground(new Color(0, 0, 0, 0));
        }
        this.cancelLabel = TaskDialog.newLabelWithFont(2, 1.0f);
        this.cancelLabel.setText("Cancelling...");
        this.cancelLabel.setVisible(false);
        this.cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TaskDialog.this.cancelButton.isVisible() && TaskDialog.this.cancelButton.isEnabled()) {
                    TaskDialog.this.cancel();
                }
            }
        });
        this.closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TaskDialog.this.closeButton.isVisible() && TaskDialog.this.closeButton.isEnabled()) {
                    TaskDialog.this.close();
                }
            }
        });
        this.closeButton.setVisible(false);
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.cancelButton, (JButton)this.closeButton, (JComponent[])new JComponent[]{this.cancelLabel});
        JPanel contents = new JPanel();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap(20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.titleLabel, -1, 500, Short.MAX_VALUE).addComponent(this.subtitleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.msgIconLabel, -2, -1, -2).addComponent(this.msgArea, -1, -1, Short.MAX_VALUE)).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(20, 20));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel, -2, -1, -2).addComponent(this.subtitleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar).addGap(15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.msgIconLabel, -2, -1, -2).addComponent(this.msgArea, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(buttonPanel, -2, -1, -2).addContainerGap());
        this.getContentPane().add(contents);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.closeButton.getAction(), (Action)this.cancelButton.getAction());
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TaskDialog.this.errorOccurred) {
                    TaskDialog.this.close();
                } else {
                    TaskDialog.this.cancel();
                }
            }
        });
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setTaskTitle(String taskTitle) {
        ViewUtil.invokeOnEDT(() -> {
            String currentTitle = this.titleLabel.getText();
            if (currentTitle == null || currentTitle.length() == 0) {
                this.titleLabel.setText(taskTitle);
                this.setTitle("Cytoscape: " + taskTitle);
            } else {
                this.subtitleLabel.setVisible(true);
                this.subtitleLabel.setText(taskTitle);
            }
            this.updateLabels();
            this.pack();
        });
    }

    public void setPercentCompleted(float percent) {
        ViewUtil.invokeOnEDT(() -> {
            if (percent < 0.0f) {
                this.progressBar.setIndeterminate();
            } else {
                this.progressBar.setProgress(percent);
            }
        });
    }

    public void setException(Throwable t) {
        t.printStackTrace();
        this.errorOccurred = true;
        ViewUtil.invokeOnEDT(() -> {
            this.setStatus("\uf056", LookAndFeelUtil.getErrorColor(), t.getMessage());
            this.progressBar.setVisible(false);
            this.closeButton.setVisible(true);
            this.cancelButton.setVisible(false);
            this.cancelLabel.setVisible(false);
            this.updateLabels();
            this.pack();
        });
    }

    public void setErrorStatus(String message) {
        this.errorOccurred = true;
        ViewUtil.invokeOnEDT(() -> {
            this.setStatus("\uf056", LookAndFeelUtil.getErrorColor(), message);
            this.progressBar.setVisible(false);
            this.closeButton.setVisible(true);
            this.cancelButton.setVisible(false);
            this.cancelLabel.setVisible(false);
            this.updateLabels();
            this.pack();
        });
    }

    public void setWarnStatus(String message) {
        ViewUtil.invokeOnEDT(() -> {
            this.setStatus("\uf071", LookAndFeelUtil.getErrorColor(), message);
            this.progressBar.setVisible(false);
            this.closeButton.setVisible(true);
            this.cancelButton.setVisible(false);
            this.cancelLabel.setVisible(false);
            this.updateLabels();
            this.pack();
        });
    }

    public void setStatus(String iconText, Color iconForeground, String message) {
        ViewUtil.invokeOnEDT(() -> {
            this.msgIconLabel.setText(iconText);
            this.msgIconLabel.setForeground(iconForeground != null ? iconForeground : this.msgArea.getForeground());
            this.msgArea.setText(message);
            this.updateLabels();
            this.pack();
        });
    }

    public boolean errorOccurred() {
        return this.errorOccurred;
    }

    private void cancel() {
        this.cancelLabel.setVisible(true);
        this.cancelButton.setEnabled(false);
        this.progressBar.setIndeterminate();
        this.firePropertyChange(CANCEL_EVENT, null, null);
    }

    private void close() {
        this.firePropertyChange(CLOSE_EVENT, null, null);
    }

    private void updateLabels() {
        ViewUtil.invokeOnEDT(() -> {
            this.titleLabel.setVisible(this.titleLabel.getText() != null && !this.titleLabel.getText().trim().isEmpty());
            this.subtitleLabel.setVisible(this.subtitleLabel.getText() != null && !this.subtitleLabel.getText().trim().isEmpty());
        });
    }
}

