/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;

public class RoundedProgressBar
extends JComponent {
    protected static final float CORNER_RADIUS = 5.2f;
    protected static final float HEIGHT = 8.0f;
    protected static final float INDET_BAR_WIDTH = 100.0f;
    protected static final int INDET_UPDATE_MS = 50;
    protected static final double INDET_UPDATE_INCREMENT = 0.015;
    boolean indet;
    Timer indetUpdate;
    double indetPosition;
    float progress;
    Insets insets = new Insets(0, 0, 0, 0);
    RoundRectangle2D.Float bkRect = new RoundRectangle2D.Float();
    RoundRectangle2D.Float fgRect = new RoundRectangle2D.Float();
    private final Color bgColor;
    private final Color fgColor = UIManager.getColor("TextField.selectionBackground");
    private final Color borderColor = UIManager.getColor("Separator.foreground");

    public RoundedProgressBar() {
        int h = (int)Math.ceil(8.0);
        super.setMinimumSize(new Dimension(50, h));
        super.setMaximumSize(new Dimension(10000, h));
        super.setPreferredSize(new Dimension(250, h));
        Color c = UIManager.getColor("TextField.foreground");
        this.bgColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 10);
    }

    public void setProgress(float progress) {
        this.indet = false;
        if (this.indetUpdate != null) {
            this.indetUpdate.stop();
            this.indetUpdate = null;
        }
        this.progress = progress > 1.0f ? 1.0f : (progress < 0.0f ? 0.0f : progress);
        super.repaint();
    }

    public void setIndeterminate() {
        if (this.indet) {
            return;
        }
        this.indet = true;
        this.indetUpdate = new Timer(50, new IndetUpdate());
        this.indetUpdate.start();
    }

    protected static double indetPositionFunc(double t) {
        if (t > 0.5) {
            return -2.0 * (t - 1.0);
        }
        return 2.0 * t;
    }

    public Float getProgress() {
        return this.indet ? null : Float.valueOf(this.progress);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.insets = super.getInsets(this.insets);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float x = this.insets.left;
        float y = this.insets.top;
        float w = this.getEffectiveWidth() - this.insets.right - this.insets.left;
        float h = 8.0f;
        this.bkRect.setRoundRect(x, y, w, 8.0f, 5.2f, 5.2f);
        g2d.setColor(this.bgColor);
        g2d.fill(this.bkRect);
        if (this.indet) {
            float nw = 200.0 > (double)w ? w * 0.2f : 100.0f;
            float nx = (float)((double)x + (double)(w - nw) * RoundedProgressBar.indetPositionFunc(this.indetPosition));
            this.fgRect.setRoundRect(nx, y, nw, 8.0f, 5.2f, 5.2f);
            g2d.setColor(this.fgColor);
        } else {
            this.fgRect.setRoundRect(x, y, w * this.progress, 8.0f, 5.2f, 5.2f);
            g2d.setColor(this.fgColor);
        }
        g2d.fill(this.fgRect);
        this.bkRect.setRoundRect(x, y, w - 1.0f, 7.0f, 5.2f, 5.2f);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.borderColor);
        g2d.draw(this.bkRect);
        g2d.dispose();
    }

    private int getEffectiveWidth() {
        int w = super.getWidth();
        int maxW = (int)super.getMaximumSize().getWidth();
        int minW = (int)super.getMinimumSize().getWidth();
        if (w > maxW) {
            return maxW;
        }
        if (w < minW) {
            return minW;
        }
        return w;
    }

    class IndetUpdate
    implements ActionListener {
        IndetUpdate() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RoundedProgressBar.this.indetPosition += 0.015;
            if (RoundedProgressBar.this.indetPosition > 1.0) {
                RoundedProgressBar.this.indetPosition = 0.0;
            }
            RoundedProgressBar.this.repaint();
        }
    }
}

