/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import javax.swing.SwingUtilities;
import org.slf4j.Logger;

public final class ViewUtil {
    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    private ViewUtil() {
    }
}

