/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class TunableSlider
extends JPanel {
    private static final int S_MIN = 0;
    private static final int S_MAX = 1000;
    private JSlider slider;
    private JFormattedTextField textField;
    private final Number min;
    private final Number max;
    private Number value;
    private final List<Object> listeners;
    private final DecimalFormat format;
    private boolean ignore;
    String newline = System.getProperty("line.separator");
    Boolean upper;
    Boolean lower;

    public TunableSlider(String title, Number min, Number max, Number value, Boolean lowerstrict, Boolean upperstrict, DecimalFormat format) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.upper = upperstrict;
        this.lower = lowerstrict;
        this.listeners = new ArrayList<Object>();
        this.format = format;
        this.initUI();
    }

    protected void initUI() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getSlider(), -1, -1, Short.MAX_VALUE).addComponent(this.getTextField(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getSlider()).addGroup(layout.createSequentialGroup().addGap(LookAndFeelUtil.isAquaLAF() ? 4 : 0).addComponent(this.getTextField(), -2, -1, -2)));
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
        Font tickFont = this.getSlider().getFont().deriveFont(LookAndFeelUtil.getSmallFontSize());
        Dictionary labelTable = this.getSlider().getLabelTable();
        Enumeration enumeration = labelTable.keys();
        while (enumeration.hasMoreElements()) {
            int k = (Integer)enumeration.nextElement();
            JLabel label = (JLabel)labelTable.get(k);
            label.setFont(tickFont);
            label.setSize(label.getPreferredSize());
        }
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.ignore = true;
        this.value = value;
        this.setSliderValue();
        this.setFieldValue();
        this.ignore = false;
    }

    private JFormattedTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JFormattedTextField(this.format){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    if (this.getGraphics() != null) {
                        int sw = 16 + this.getGraphics().getFontMetrics().stringWidth(TunableSlider.this.format.format(TunableSlider.this.max.doubleValue()));
                        d.width = Math.max(sw, 48);
                    }
                    return d;
                }
            };
            this.textField.setHorizontalAlignment(4);
            if (LookAndFeelUtil.isAquaLAF()) {
                this.textField.putClientProperty("JComponent.sizeVariant", "small");
            } else if (this.textField.getFont() != null) {
                this.textField.setFont(this.textField.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            this.textField.addActionListener(e -> this.textFieldValueChanged());
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TunableSlider.this.textFieldValueChanged();
                }
            });
        }
        return this.textField;
    }

    private JSlider getSlider() {
        if (this.slider == null) {
            int S_RANGE = 1000;
            this.slider = new JSlider(0, 1000);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            if (this.value instanceof Double || this.value instanceof Float) {
                double range = this.max.doubleValue() - this.min.doubleValue();
                this.slider.setMajorTickSpacing(250);
                this.slider.setMinorTickSpacing(50);
                labelTable.put(0, new JLabel(this.format.format(this.min.doubleValue())));
                labelTable.put(500, new JLabel(this.format.format(this.min.doubleValue() + range / 2.0)));
                labelTable.put(1000, new JLabel(this.format.format(this.max.doubleValue())));
            } else if (this.value instanceof Long || this.value instanceof Integer) {
                long range = this.max.longValue() - this.min.longValue();
                int minorTick = Math.round(1000.0f / (float)range);
                this.slider.setSnapToTicks(minorTick > 0 && 1000 / minorTick <= 20);
                minorTick = Math.max(minorTick, 50);
                this.slider.setMinorTickSpacing(minorTick);
                if (range >= 12L && range % 4L == 0L) {
                    this.slider.setMajorTickSpacing(250);
                } else if (range % 2L == 0L) {
                    this.slider.setMajorTickSpacing(500);
                }
                labelTable.put(0, new JLabel(this.format.format(this.min.longValue())));
                if (range % 2L == 0L) {
                    labelTable.put(500, new JLabel(this.format.format(this.min.doubleValue() + (double)(range / 2L))));
                }
                labelTable.put(1000, new JLabel(this.format.format(this.max.longValue())));
            }
            this.slider.setPreferredSize(new Dimension(280, this.slider.getPreferredSize().height));
            this.slider.setLabelTable(labelTable);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.setSliderValue();
            this.setFieldValue();
            this.slider.addChangeListener(e -> {
                if (this.ignore) {
                    return;
                }
                this.ignore = true;
                this.value = this.getTunableValue();
                this.value = this.clamp(this.value);
                this.setFieldValue();
                this.fireChangeEvent();
                this.ignore = false;
            });
        }
        return this.slider;
    }

    private Number getTunableValue() {
        int S_RANGE = 1000;
        if (this.value instanceof Integer) {
            int val = this.getSlider().getValue();
            int min = this.min.intValue();
            int max = this.max.intValue();
            if (this.upper.booleanValue()) {
                --max;
            }
            if (this.lower.booleanValue()) {
                ++min;
            }
            val = Math.min(val, 1000);
            val = Math.max(val, 0);
            return Math.round((float)min + (float)((val - 0) * (max - min)) / 1000.0f);
        }
        if (this.value instanceof Long) {
            long val = this.getSlider().getValue();
            long min = this.min.longValue();
            long max = this.max.longValue();
            if (this.upper.booleanValue()) {
                --max;
            }
            if (this.lower.booleanValue()) {
                ++min;
            }
            val = Math.min(val, 1000L);
            val = Math.max(val, 0L);
            return Math.round((double)min + (double)((val - 0L) * (max - min)) / 1000.0);
        }
        double val = this.getSlider().getValue();
        double min = this.min.doubleValue();
        double max = this.max.doubleValue();
        if (this.upper.booleanValue()) {
            max -= 1.0E-9;
        }
        if (this.lower.booleanValue()) {
            min += 1.0E-9;
        }
        val = Math.min(val, 1000.0);
        val = Math.max(val, 0.0);
        val = min + (val - 0.0) * (max - min) / 1000.0;
        return this.value instanceof Double ? (Number)new Double(val) : (Number)new Float((float)val);
    }

    private void setSliderValue() {
        int val;
        if (this.value instanceof Double || this.value instanceof Float) {
            double value = this.value.doubleValue();
            double min = this.min.doubleValue();
            double max = this.max.doubleValue();
            val = 0 + (int)Math.round(1000.0 * (value - min) / (max - min));
        } else {
            long value = this.value.longValue();
            long min = this.min.longValue();
            long max = this.max.longValue();
            val = 0 + Math.round((float)(1000L * (value - min)) / (float)(max - min));
        }
        this.getSlider().setValue(val);
    }

    private Number getFieldValue() {
        Double val = null;
        Number n = this.format.parse(this.getTextField().getText(), new ParsePosition(0));
        Color errColor = LookAndFeelUtil.getErrorColor();
        if (n == null) {
            try {
                val = Double.valueOf(this.getTextField().getText());
            }
            catch (NumberFormatException nfe) {
                this.getTextField().setForeground(errColor);
                JOptionPane.showMessageDialog(null, "Please enter a Value", "Alert", 0);
                this.setFieldValue();
                this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
                try {
                    val = this.value.doubleValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            val = n.doubleValue();
        }
        if (this.value instanceof Double || this.value instanceof Float) {
            if (val < this.min.doubleValue()) {
                this.getTextField().setForeground(errColor);
                JOptionPane.showMessageDialog(null, "Value (" + val + ") is less than lower limit (" + this.format.format(this.min.doubleValue()) + ")" + this.newline + "Value will be set to default: " + this.value, "Alert", 0);
                this.setFieldValue();
                this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
                return this.value;
            }
            if (val > this.max.doubleValue()) {
                this.getTextField().setForeground(errColor);
                JOptionPane.showMessageDialog(null, "Value (" + val + ") is more than upper limit (" + this.format.format(this.max.doubleValue()) + ")" + this.newline + "Value will be set to default: " + this.value, "Alert", 0);
                this.setFieldValue();
                this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
                return this.value;
            }
            return this.value instanceof Double ? (Number)val : (Number)Float.valueOf(val.floatValue());
        }
        if (val < (double)this.min.longValue()) {
            this.getTextField().setForeground(errColor);
            JOptionPane.showMessageDialog(null, "Value (" + val.longValue() + ") is less than lower limit (" + this.min.longValue() + ")" + this.newline + "Value will be set to default: " + this.value, "Alert", 0);
            this.setFieldValue();
            this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
            return this.value;
        }
        if (val > (double)this.max.longValue()) {
            this.getTextField().setForeground(errColor);
            JOptionPane.showMessageDialog(null, "Value (" + val.longValue() + ") is more than upper limit (" + this.max.longValue() + ")" + this.newline + "Value will be set to default : " + this.value, "Alert", 0);
            this.setFieldValue();
            this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
            return this.value;
        }
        return this.value instanceof Long ? (Number)val.longValue() : (Number)val.intValue();
    }

    private void setFieldValue() {
        this.getTextField().setValue(this.value);
    }

    private Number clamp(Number val) {
        if (this.value instanceof Integer) {
            val = Math.min(val.intValue(), this.max.intValue());
            val = Math.max(val.intValue(), this.min.intValue());
            return val.intValue();
        }
        if (this.value instanceof Long) {
            val = Math.min(val.longValue(), this.max.longValue());
            val = Math.max(val.longValue(), this.min.longValue());
            return val.longValue();
        }
        if (this.value instanceof Float) {
            float min = this.min.floatValue();
            float max = this.max.floatValue();
            if (this.upper.booleanValue()) {
                max = (float)((double)max - 1.0E-9);
            }
            if (this.lower.booleanValue()) {
                min = (float)((double)min + 1.0E-9);
            }
            val = Float.valueOf(Math.min(val.floatValue(), max));
            val = Float.valueOf(Math.max(val.floatValue(), min));
            return new Float(val.floatValue());
        }
        double min = this.min.doubleValue();
        double max = this.max.doubleValue();
        if (this.upper.booleanValue()) {
            max -= 1.0E-9;
        }
        if (this.lower.booleanValue()) {
            min += 1.0E-9;
        }
        val = Math.min(val.doubleValue(), max);
        val = Math.max(val.doubleValue(), min);
        return new Double(val.doubleValue());
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        Iterator<Object> iter = this.listeners.iterator();
        ChangeEvent evt = new ChangeEvent(this);
        while (iter.hasNext()) {
            ChangeListener cl = (ChangeListener)iter.next();
            cl.stateChanged(evt);
        }
    }

    private void textFieldValueChanged() {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        Number v = this.getFieldValue();
        if (v != this.value) {
            this.value = v;
            this.setSliderValue();
        }
        this.fireChangeEvent();
        this.ignore = false;
    }
}

