/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSelection;

public class ListMultipleHandler<T>
extends AbstractGUITunableHandler
implements ListSelectionListener,
ListChangeListener<T> {
    private JList<T> itemsContainerList;
    private DefaultListModel<T> listModel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private boolean isUpdating = false;

    public ListMultipleHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public ListMultipleHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private ListMultipleSelection<T> getMultipleSelection() {
        try {
            return (ListMultipleSelection)this.getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("bad ListMultipleSelection object", e);
        }
    }

    private void init() {
        this.listModel = new DefaultListModel();
        this.itemsContainerList = new JList<T>(this.listModel);
        this.selectAllButton = new JButton("Select All");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListMultipleHandler.this.listModel.getSize() > 0) {
                    ListMultipleHandler.this.itemsContainerList.getSelectionModel().setSelectionInterval(0, ListMultipleHandler.this.listModel.getSize() - 1);
                }
            }
        });
        this.selectNoneButton = new JButton("Select None");
        this.selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListMultipleHandler.this.itemsContainerList.getSelectionModel().clearSelection();
            }
        });
        this.selectNoneButton.setEnabled(false);
        if (LookAndFeelUtil.isAquaLAF()) {
            this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
            this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.selectAllButton, this.selectNoneButton});
        ListMultipleSelection<T> multipleSelection = this.getMultipleSelection();
        if (multipleSelection != null) {
            for (Object value : multipleSelection.getPossibleValues()) {
                this.listModel.addElement(value);
            }
        }
        this.itemsContainerList.setSelectionMode(2);
        List selVals = multipleSelection != null ? multipleSelection.getSelectedValues() : Collections.emptyList();
        List allValues = multipleSelection != null ? multipleSelection.getPossibleValues() : Collections.emptyList();
        int[] selectedIdx = new int[selVals.size()];
        int index = 0;
        for (Object selected : selVals) {
            for (int i = 0; i < allValues.size(); ++i) {
                if (!this.itemsContainerList.getModel().getElementAt(i).equals(selected)) continue;
                selectedIdx[index] = i;
                ++index;
            }
        }
        this.itemsContainerList.setSelectedIndices(selectedIdx);
        this.itemsContainerList.addListSelectionListener(this);
        JScrollPane scrollpane = new JScrollPane(this.itemsContainerList);
        scrollpane.setAutoscrolls(true);
        scrollpane.setOpaque(false);
        JPanel controlPanel = new JPanel();
        if (LookAndFeelUtil.isAquaLAF()) {
            controlPanel.setOpaque(false);
        }
        GroupLayout layout = new GroupLayout(controlPanel);
        controlPanel.setLayout(layout);
        layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(scrollpane, 100, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.selectAllButton).addComponent(this.selectNoneButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(scrollpane, 80, 120, -2).addGroup(layout.createSequentialGroup().addComponent(this.selectAllButton).addComponent(this.selectNoneButton)));
        String description = this.getDescription();
        if (description != null && description.length() > 80) {
            JTextArea textArea = new JTextArea(description);
            GUIDefaults.updateFieldPanel(this.panel, textArea, (Component)controlPanel, this.horizontal);
            GUIDefaults.setTooltip(this.getTooltip(), textArea, scrollpane);
        } else if (description != null && description.length() > 0) {
            JLabel label = new JLabel(description);
            GUIDefaults.updateFieldPanel(this.panel, label, (Component)controlPanel, this.horizontal);
            GUIDefaults.setTooltip(this.getTooltip(), label, scrollpane);
        } else {
            GUIDefaults.updateFieldPanel(this.panel, controlPanel, this.horizontal);
            GUIDefaults.setTooltip(this.getTooltip(), scrollpane);
        }
        this.panel.setVisible(this.itemsContainerList.getModel().getSize() > 0);
    }

    public void update() {
        this.isUpdating = true;
        boolean reloadSelection = false;
        ListMultipleSelection<T> multipleSelection = this.getMultipleSelection();
        if (!Arrays.equals(this.listModel.toArray(), multipleSelection.getPossibleValues().toArray())) {
            this.listModel.removeAllElements();
            reloadSelection = true;
            for (Object value : multipleSelection.getPossibleValues()) {
                this.listModel.addElement(value);
            }
        } else if (!Arrays.equals(this.itemsContainerList.getSelectedValuesList().toArray(), multipleSelection.getSelectedValues().toArray())) {
            reloadSelection = true;
        }
        if (reloadSelection) {
            List selVals = multipleSelection != null ? multipleSelection.getSelectedValues() : Collections.emptyList();
            List allValues = multipleSelection != null ? multipleSelection.getPossibleValues() : Collections.emptyList();
            int[] selectedIdx = new int[selVals.size()];
            int index = 0;
            for (Object selected : selVals) {
                for (int i = 0; i < allValues.size(); ++i) {
                    if (!this.itemsContainerList.getModel().getElementAt(i).equals(selected)) continue;
                    selectedIdx[index] = i;
                    ++index;
                }
            }
            if (!allValues.isEmpty()) {
                this.itemsContainerList.removeSelectionInterval(0, allValues.size() - 1);
                this.itemsContainerList.setSelectedIndices(selectedIdx);
            }
        }
        this.panel.setVisible(this.itemsContainerList.getModel().getSize() > 0);
        this.isUpdating = false;
    }

    public void handle() {
        int selected;
        int total = this.listModel.getSize();
        int n = selected = this.itemsContainerList != null ? this.itemsContainerList.getSelectedIndices().length : 0;
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(selected < total);
        }
        if (this.selectNoneButton != null) {
            this.selectNoneButton.setEnabled(selected > 0);
        }
        if (this.itemsContainerList == null || this.itemsContainerList.getModel().getSize() == 0) {
            return;
        }
        List<T> selectedItems = this.itemsContainerList.getSelectedValuesList();
        this.getMultipleSelection().setSelectedValues(selectedItems);
        try {
            this.setValue(this.getMultipleSelection());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String getState() {
        if (this.itemsContainerList == null) {
            return "";
        }
        ListMultipleSelection<T> multipleSelection = this.getMultipleSelection();
        List selection = multipleSelection != null ? multipleSelection.getSelectedValues() : null;
        return selection == null ? "" : selection.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && !this.isUpdating) {
            this.handle();
        }
    }

    public void selectionChanged(ListSelection<T> source) {
        this.update();
    }

    public void listChanged(ListSelection<T> source) {
        this.update();
    }
}

