/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.work.AbstractTunableInterceptor;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TunableMutator;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.internal.tunables.utils.SimplePanel;
import org.cytoscape.work.internal.tunables.utils.TitledPanel;
import org.cytoscape.work.internal.tunables.utils.XorPanel;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.DirectlyPresentableTunableHandler;
import org.cytoscape.work.swing.GUITunableHandler;
import org.cytoscape.work.swing.TunableUIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPanelTunableMutator
extends AbstractTunableInterceptor<GUITunableHandler>
implements TunableMutator<GUITunableHandler, JPanel>,
TunableUIHelper {
    private static final String TOP_GROUP = "__CY_TOP_GROUP";
    private Map<List<GUITunableHandler>, JPanel> panelMap;
    private JPanel tunablePanel;
    private final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected final JPanel HANDLER_CANCEL_PANEL = new JPanel();
    private boolean updatingMargins;
    private final ComponentListener controlComponentListener;
    private Window parent = null;
    protected List<GUITunableHandler> handlers;
    private final Object lock = new Object();

    public JPanelTunableMutator() {
        this.panelMap = new WeakHashMap<List<GUITunableHandler>, JPanel>();
        this.controlComponentListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                JPanelTunableMutator.this.updateTunableFieldPanelMargins();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JPanelTunableMutator.this.updateTunableFieldPanelMargins();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JPanelTunableMutator.this.updateTunableFieldPanelMargins();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                JPanelTunableMutator.this.updateTunableFieldPanelMargins();
            }
        };
    }

    public void setConfigurationContext(Object tPanel) {
        if (!(tPanel instanceof JPanel)) {
            throw new IllegalArgumentException("this tunable mutator only works with JPanels - set the configuration context to a JPanel");
        }
        this.tunablePanel = (JPanel)tPanel;
    }

    public boolean hasTunables(Object o) {
        return super.hasTunables(o);
    }

    public boolean hasTunables(Object o, String context) {
        return this.getApplicableHandlers(o, context).size() > 0;
    }

    public boolean validateAndWriteBack(Object objectWithTunables) {
        List handlers = this.getHandlers(objectWithTunables);
        for (GUITunableHandler h : handlers) {
            h.handle();
        }
        return this.validateTunableInput(objectWithTunables);
    }

    public JPanel buildConfiguration(Object objectWithTunables) {
        return this.buildConfiguration(objectWithTunables, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPanel buildConfiguration(Object objectWithTunables, Window possibleParent) {
        int factoryCount = 0;
        int otherCount = 0;
        this.parent = possibleParent;
        if (objectWithTunables instanceof TaskFactory) {
            ++factoryCount;
        } else {
            ++otherCount;
        }
        Object object = this.lock;
        synchronized (object) {
            DirectlyPresentableTunableHandler fh;
            this.handlers = this.getApplicableHandlers(objectWithTunables, "gui");
            if (factoryCount > 0) {
                if (factoryCount != 1) {
                    this.logger.error("More than one annotated TaskFactory found.");
                    return null;
                }
                if (otherCount != 0) {
                    this.logger.error("Found annotated Task objects in addition to an annotated TaskFactory.");
                    return null;
                }
            }
            if (this.handlers.isEmpty()) {
                if (this.tunablePanel != null) {
                    this.tunablePanel.removeAll();
                    return this.tunablePanel;
                }
                return null;
            }
            if (this.handlers.size() == 1 && this.handlers.get(0) instanceof DirectlyPresentableTunableHandler && (fh = (DirectlyPresentableTunableHandler)this.handlers.get(0)).isForcedToSetDirectly()) {
                boolean fileFound = fh.setTunableDirectly(possibleParent);
                JPanel jPanel = fileFound ? null : this.HANDLER_CANCEL_PANEL;
                return jPanel;
            }
            if (!this.panelMap.containsKey(this.handlers)) {
                HashMap panels = new HashMap();
                SimplePanel topLevel = new SimplePanel(true);
                panels.put(TOP_GROUP, topLevel);
                for (GUITunableHandler gh : this.handlers) {
                    String dep = gh.getDependency();
                    if (dep != null && !dep.equals("")) {
                        for (GUITunableHandler gh2 : this.handlers) {
                            if (!gh2.getName().equals(dep)) continue;
                            gh2.addDependent(gh);
                            break;
                        }
                    }
                    block5: for (String cs : gh.getChangeSources()) {
                        if (cs == null || cs.equals("")) continue;
                        for (GUITunableHandler gh2 : this.handlers) {
                            if (!gh2.getName().equals(cs)) continue;
                            gh2.addChangeListener(gh);
                            continue block5;
                        }
                    }
                    Map<String, Boolean> groupToVerticalMap = this.processGroupParams(gh, "alignments", "vertical");
                    Map<String, Boolean> groupToDisplayedMap = this.processGroupParams(gh, "groupTitles", "displayed");
                    Object lastGroup = TOP_GROUP;
                    Object groupNames = "";
                    for (String g : gh.getGroups()) {
                        if (g == null || g.equals("")) {
                            throw new IllegalArgumentException("A group's name must not be \"\".");
                        }
                        if (!panels.containsKey(groupNames = (String)groupNames + g)) {
                            boolean displayed = groupToDisplayedMap.get(g);
                            boolean vertical = groupToVerticalMap.get(g);
                            if (g.startsWith("_")) {
                                displayed = false;
                            }
                            panels.put(groupNames, this.createJPanel(g, gh, vertical, displayed));
                            JPanel pnl = (JPanel)panels.get(groupNames);
                            ((JPanel)panels.get(lastGroup)).add((Component)pnl, gh.getChildKey());
                        }
                        lastGroup = groupNames;
                    }
                    ((JPanel)panels.get(lastGroup)).add(gh.getJPanel());
                }
                this.panelMap.put(this.handlers, (JPanel)panels.get(TOP_GROUP));
            }
            this.updateTunableFieldPanelMargins();
            for (GUITunableHandler gh : this.handlers) {
                gh.notifyDependents();
            }
            if (this.tunablePanel == null) {
                return this.panelMap.get(this.handlers);
            }
            this.tunablePanel.removeAll();
            this.tunablePanel.add(this.panelMap.get(this.handlers));
            JPanel retVal = this.tunablePanel;
            this.tunablePanel = null;
            return retVal;
        }
    }

    public List<GUITunableHandler> getApplicableHandlers(Object objectWithTunables, String desiredContext) {
        List handlers = this.getHandlers(objectWithTunables);
        if (handlers != null) {
            ListIterator li = handlers.listIterator();
            while (li.hasNext()) {
                GUITunableHandler gh = (GUITunableHandler)li.next();
                String context = gh.getParams().get("context").toString();
                if (desiredContext.equalsIgnoreCase("gui")) {
                    if (!context.equalsIgnoreCase("nogui")) continue;
                    li.remove();
                    continue;
                }
                if (!desiredContext.equalsIgnoreCase("nogui") || !context.equalsIgnoreCase("gui")) continue;
                li.remove();
            }
        }
        return handlers;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setModality(Dialog.ModalityType modality) {
    }

    public void update(Object objectWithTunables) {
        List handlers = (List)this.handlerMap.get(objectWithTunables);
        if (handlers != null) {
            for (GUITunableHandler handler : handlers) {
                handler.update();
            }
        }
    }

    public void refresh(Object objectWithTunables) {
        this.update(objectWithTunables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTunableFieldPanelMargins() {
        Object object = this.lock;
        synchronized (object) {
            if (this.updatingMargins || this.handlers == null) {
                return;
            }
            this.updatingMargins = true;
            int maxLeftWidth = 0;
            int maxRightWidth = 0;
            boolean updateMargins = false;
            try {
                Component control;
                JComponent label;
                AbstractGUITunableHandler.TunableFieldPanel tfp;
                JPanel p;
                for (GUITunableHandler gh : this.handlers) {
                    if (!(gh instanceof AbstractGUITunableHandler) || ((AbstractGUITunableHandler)gh).isHorizontal() || !((p = gh.getJPanel()) instanceof AbstractGUITunableHandler.TunableFieldPanel)) continue;
                    updateMargins = true;
                    tfp = (AbstractGUITunableHandler.TunableFieldPanel)p;
                    label = tfp.getLabel() != null ? tfp.getLabel() : tfp.getMultiLineLabel();
                    control = tfp.getControl();
                    if (label != null) {
                        maxLeftWidth = Math.max(maxLeftWidth, label.getPreferredSize().width);
                    }
                    if (control == null) continue;
                    maxRightWidth = Math.max(maxRightWidth, control.getPreferredSize().width);
                }
                if (updateMargins) {
                    for (GUITunableHandler gh : this.handlers) {
                        p = gh.getJPanel();
                        if (!(p instanceof AbstractGUITunableHandler.TunableFieldPanel)) continue;
                        tfp = (AbstractGUITunableHandler.TunableFieldPanel)p;
                        label = tfp.getLabel() != null ? tfp.getLabel() : tfp.getMultiLineLabel();
                        control = tfp.getControl();
                        if (control != null) {
                            control.removeComponentListener(this.controlComponentListener);
                        }
                        int left = label == null ? 0 : maxLeftWidth - label.getPreferredSize().width;
                        int right = control == null ? 0 : maxRightWidth - control.getPreferredSize().width;
                        tfp.setBorder(BorderFactory.createEmptyBorder(2, left, 2, right));
                        gh.notifyDependents();
                        if (control == null) continue;
                        control.addComponentListener(this.controlComponentListener);
                    }
                    this.repackEnclosingDialog(this.panelMap.get(this.handlers));
                }
            }
            finally {
                this.updatingMargins = false;
            }
        }
    }

    private JPanel createJPanel(String title, GUITunableHandler gh, Boolean vertical, Boolean displayed) {
        if (gh == null) {
            return this.createTitledPanel(title, vertical, displayed);
        }
        if (gh.controlsMutuallyExclusiveNestedChildren()) {
            return new XorPanel(title, gh);
        }
        String displayState = gh.getParams().getProperty("displayState");
        if (displayState != null) {
            final BasicCollapsiblePanel cp = new BasicCollapsiblePanel(title);
            if (displayState.equalsIgnoreCase("uncollapsed")) {
                cp.setCollapsed(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cp.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            JPanelTunableMutator.this.repackEnclosingDialog((Component)cp);
                        }
                    });
                }
            });
            return cp;
        }
        return this.createTitledPanel(title, vertical, displayed);
    }

    private void repackEnclosingDialog(Component cp) {
        Container container;
        if (cp == null) {
            return;
        }
        for (container = cp.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
        }
        if (container != null) {
            ((JDialog)container).pack();
        }
    }

    private TitledPanel createTitledPanel(String title, Boolean vertical, Boolean displayed) {
        TitledPanel panel = new TitledPanel(displayed == null || displayed != false ? title : null, Boolean.TRUE.equals(vertical));
        return panel;
    }

    private boolean validateTunableInput(Object objectWithTunables) {
        if (!(objectWithTunables instanceof TunableValidator)) {
            return true;
        }
        StringBuilder errMsg = new StringBuilder();
        try {
            TunableValidator.ValidationState validationState = ((TunableValidator)objectWithTunables).getValidationState((Appendable)errMsg);
            if (validationState == TunableValidator.ValidationState.INVALID) {
                JOptionPane.showMessageDialog(new JFrame(), ((Object)errMsg).toString(), "Input Validation Problem", 0);
                return false;
            }
            if (validationState == TunableValidator.ValidationState.REQUEST_CONFIRMATION && JOptionPane.showConfirmDialog(new JFrame(), ((Object)errMsg).toString(), "Confirmation", 0) == 1) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected String getTitle(Object objectWithTunables) {
        Method method = (Method)this.titleProviderMap.get(objectWithTunables);
        if (method != null) {
            try {
                String title = (String)method.invoke(objectWithTunables, new Object[0]);
                if (title != null) {
                    return title;
                }
            }
            catch (Exception e) {
                this.logger.error("Can't retrieve @ProvidesTitle String: ", (Throwable)e);
            }
        }
        return "Set Parameters";
    }

    private Map<String, Boolean> processGroupParams(GUITunableHandler gh, String paramName, String defaultValue) {
        String[] params;
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        String[] groups = gh.getGroups();
        if (groups.length <= (params = gh.getParams().getProperty(paramName, "").split(",")).length) {
            for (int i = 0; i < groups.length; ++i) {
                boolean vertical = params[i].equalsIgnoreCase(defaultValue) || params[i].equals("");
                groupMap.put(groups[i], vertical);
            }
        } else {
            int i;
            for (i = 0; i < params.length; ++i) {
                boolean vertical = params[i].equalsIgnoreCase(defaultValue) || params[i].equals("");
                groupMap.put(groups[i], vertical);
            }
            for (i = params.length; i < groups.length; ++i) {
                groupMap.put(groups[i], true);
            }
        }
        return groupMap;
    }
}

