/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.internal.tunables.utils.TunableBoundedField;
import org.cytoscape.work.internal.tunables.utils.TunableSlider;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.util.AbstractBounded;
import org.cytoscape.work.util.BoundedChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedHandler<T extends AbstractBounded, N>
extends AbstractGUITunableHandler
implements BoundedChangeListener<N> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private boolean useSlider;
    private TunableSlider slider;
    private TunableBoundedField boundedField;
    private T lastBounded;
    private String title;
    DecimalFormat df = new DecimalFormat("##.###");
    DecimalFormat sdf = new DecimalFormat("#.###E0");
    private boolean isUpdating = false;

    public BoundedHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public BoundedHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        this.title = this.getDescription();
        this.useSlider = this.getParams().getProperty("slider", "false").equalsIgnoreCase("true");
        try {
            T bounded = this.getBounded();
            this.lastBounded = bounded;
            this.lastBounded.addListener((BoundedChangeListener)this);
            this.initPanel(bounded);
        }
        catch (Exception e) {
            logger.error("Error in initialization: ", (Throwable)e);
        }
    }

    private void initPanel(T bounded) {
        double min = ((Number)((Object)bounded.getLowerBound())).doubleValue();
        double max = ((Number)((Object)bounded.getUpperBound())).doubleValue();
        double range = max - min;
        DecimalFormat format = this.getDecimalFormat(range);
        JLabel label = new JLabel();
        if (this.useSlider) {
            label.setText(this.title);
            this.slider = new TunableSlider(this.title, (Number)((Object)bounded.getLowerBound()), (Number)((Object)bounded.getUpperBound()), (Number)((Object)bounded.getValue()), bounded.isLowerBoundStrict(), bounded.isUpperBoundStrict(), format);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!BoundedHandler.this.isUpdating) {
                        BoundedHandler.this.handle();
                    }
                }
            });
            GUIDefaults.updateFieldPanel(this.panel, label, (Component)this.slider, this.horizontal);
            this.panel.validate();
            GUIDefaults.setTooltip(this.getTooltip(), label, this.slider);
        } else {
            label.setText(this.title + " (min: " + format.format((Number)((Object)bounded.getLowerBound())) + " max: " + format.format((Number)((Object)bounded.getUpperBound())) + ")");
            this.boundedField = new TunableBoundedField((Number)((Object)bounded.getValue()), (Number)((Object)bounded.getLowerBound()), (Number)((Object)bounded.getUpperBound()), bounded.isLowerBoundStrict(), bounded.isUpperBoundStrict());
            this.boundedField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!BoundedHandler.this.isUpdating) {
                        BoundedHandler.this.handle();
                    }
                }
            });
            this.boundedField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!BoundedHandler.this.isUpdating) {
                        BoundedHandler.this.handle();
                    }
                }
            });
            GUIDefaults.updateFieldPanel(this.panel, label, (Component)this.boundedField, this.horizontal);
            this.panel.validate();
            GUIDefaults.setTooltip(this.getTooltip(), label, this.boundedField);
        }
    }

    private T getBounded() throws Exception {
        try {
            return (T)((AbstractBounded)this.getValue());
        }
        catch (Exception e) {
            logger.error("Could not get value ", (Throwable)e);
            throw e;
        }
    }

    public void update() {
        this.isUpdating = true;
        try {
            T bounded = this.getBounded();
            if (this.lastBounded != bounded) {
                this.lastBounded = bounded;
                BoundedChangeListener found = null;
                List listeners = this.lastBounded.getListeners();
                for (BoundedChangeListener listener : listeners) {
                    if (!(listener instanceof AbstractGUITunableHandler) || !((AbstractGUITunableHandler)listener).getQualifiedName().equals(this.getQualifiedName())) continue;
                    found = listener;
                }
                if (found != null) {
                    this.lastBounded.removeListener(found);
                }
                this.lastBounded.addListener((BoundedChangeListener)this);
                this.panel.removeAll();
                this.initPanel(bounded);
            } else if (this.useSlider) {
                Number n = (Number)((Object)bounded.getValue());
                this.slider.setValue(n);
            } else {
                this.boundedField = new TunableBoundedField((Number)((Object)bounded.getValue()), (Number)((Object)bounded.getLowerBound()), (Number)((Object)bounded.getUpperBound()), bounded.isLowerBoundStrict(), bounded.isUpperBoundStrict());
            }
        }
        catch (Exception e) {
            logger.error("Could not update bounded value", (Throwable)e);
        }
        this.isUpdating = false;
    }

    public void handle() {
        try {
            Number fieldValue;
            T bounded = this.getBounded();
            Number number = fieldValue = this.useSlider ? (Number)this.slider.getValue() : (Number)this.boundedField.getFieldValue();
            if (fieldValue instanceof Double) {
                bounded.setValue((Comparable)((Double)fieldValue));
            } else if (fieldValue instanceof Float) {
                bounded.setValue((Comparable)((Float)fieldValue));
            } else if (fieldValue instanceof Integer) {
                bounded.setValue((Comparable)((Integer)fieldValue));
            } else if (fieldValue instanceof Long) {
                bounded.setValue((Comparable)((Long)fieldValue));
            } else {
                throw new IllegalStateException("unexpected type: " + fieldValue.getClass() + ".");
            }
            this.setValue(bounded);
        }
        catch (Exception e) {
            logger.error("Could not set bounded value", (Throwable)e);
        }
    }

    public String getState() {
        try {
            return this.getBounded().getValue().toString();
        }
        catch (Exception e) {
            logger.error("Error getting state", (Throwable)e);
            return "";
        }
    }

    public void boundsChanged(AbstractBounded changedObject) {
        if (changedObject == this.lastBounded) {
            this.panel.removeAll();
            this.initPanel(this.lastBounded);
        } else {
            changedObject.removeListener((BoundedChangeListener)this);
        }
    }

    public void valueChanged(AbstractBounded changedObject) {
        if (changedObject == this.lastBounded) {
            this.update();
        } else {
            changedObject.removeListener((BoundedChangeListener)this);
        }
    }

    private DecimalFormat getDecimalFormat(double range) {
        if (this.getFormat() != null && this.getFormat().length() > 0) {
            return new DecimalFormat(this.getFormat());
        }
        if (range < 0.001 || range > 10000.0) {
            return this.sdf;
        }
        return this.df;
    }
}

