/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.task;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;

public class TaskHistory
implements Iterable<History> {
    private static final int HISTORY_CAPACITY = 5000;
    private final ConcurrentLinkedQueue<History> histories = new ConcurrentLinkedQueue();
    private final AtomicInteger counter = new AtomicInteger();
    private volatile FinishListener finishListener;
    private final int drainAmount = 500;

    public History newHistory() {
        int size = this.counter.getAndUpdate(count -> 1 + (count > 5000 ? count - 500 : count));
        if (size > 5000) {
            for (int i = 0; i < 500; ++i) {
                this.histories.poll();
            }
        }
        History history = new History();
        this.histories.add(history);
        return history;
    }

    @Override
    public Iterator<History> iterator() {
        return this.histories.iterator();
    }

    public void clear() {
        this.counter.set(0);
        this.histories.clear();
    }

    public void setFinishListener(FinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void addUnnestedMessage(TaskMonitor.Level level, String message) {
        this.histories.add(new History(level, message));
    }

    public class History
    implements Iterable<Message> {
        private volatile FinishStatus.Type finishType;
        private volatile Class<?> firstTaskClass;
        private final boolean isUnnested;
        private final AtomicReference<String> title = new AtomicReference();
        private final ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();

        private History() {
            this.isUnnested = false;
        }

        private History(TaskMonitor.Level level, String message) {
            this.addMessage(level, message);
            this.isUnnested = true;
        }

        public void setTitle(String newTitle) {
            if (!this.title.compareAndSet(null, newTitle)) {
                this.addMessage(null, newTitle);
            }
        }

        public void setFinishType(FinishStatus.Type finishType) {
            this.finishType = finishType;
            if (TaskHistory.this.finishListener != null) {
                TaskHistory.this.finishListener.taskFinished(this);
            }
        }

        public void addMessage(TaskMonitor.Level level, String message) {
            this.messages.add(new Message(level, message));
        }

        public Message getFirstMessage() {
            return this.messages.isEmpty() ? null : this.messages.peek();
        }

        @Override
        public Iterator<Message> iterator() {
            return this.messages.iterator();
        }

        public String getTitle() {
            return this.title.get();
        }

        public FinishStatus.Type getFinishType() {
            return this.finishType;
        }

        public boolean hasMessages() {
            return !this.messages.isEmpty();
        }

        public boolean isUnnested() {
            return this.isUnnested;
        }

        public void setFirstTaskClass(Class<?> klass) {
            this.firstTaskClass = klass;
        }

        public Class<?> getFirstTaskClass() {
            return this.firstTaskClass;
        }
    }

    public static interface FinishListener {
        public void taskFinished(History var1);
    }

    public record Message(TaskMonitor.Level level, String message) {
    }
}

