/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.task;

import java.awt.Window;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTaskManager;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableMutator;
import org.cytoscape.work.TunableRecorder;
import org.cytoscape.work.internal.task.SwingTaskMonitor;
import org.cytoscape.work.internal.task.TaskHistory;
import org.cytoscape.work.internal.tunables.JDialogTunableMutator;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;
import org.cytoscape.work.internal.view.TaskMediator;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDialogTaskManager
extends AbstractTaskManager<JDialog, Window>
implements DialogTaskManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    static final long DELAY_BEFORE_SHOWING_DIALOG = 1L;
    static final TimeUnit DELAY_TIMEUNIT = TimeUnit.SECONDS;
    private static final long DEFAULT_STACK_SIZE = 0xA00000L;
    private final TaskMediator taskMediator;
    private final TaskHistory taskHistory;
    private final CyServiceRegistrar serviceRegistrar;
    private TaskThreadFactory taskThreadFactory;
    private ExecutorService taskExecutorService;
    private ScheduledExecutorService timedDialogExecutorService;
    private ExecutorService cancelExecutorService;
    private Window parent;
    private Window initialParent;
    private final JDialogTunableMutator dialogTunableMutator;

    public JDialogTaskManager(JDialogTunableMutator tunableMutator, TaskMediator taskMediator, TaskHistory taskHistory, CyServiceRegistrar serviceRegistrar) {
        super((TunableMutator)tunableMutator);
        this.dialogTunableMutator = tunableMutator;
        this.taskMediator = taskMediator;
        this.taskHistory = taskHistory;
        this.serviceRegistrar = serviceRegistrar;
        this.parent = null;
        this.initialParent = null;
        this.taskThreadFactory = new TaskThreadFactory();
        this.taskExecutorService = Executors.newCachedThreadPool(this.taskThreadFactory);
        this.addShutdownHook(this.taskExecutorService);
        this.timedDialogExecutorService = Executors.newSingleThreadScheduledExecutor(this.taskThreadFactory);
        this.addShutdownHook(this.timedDialogExecutorService);
        this.cancelExecutorService = this.taskExecutorService;
    }

    void addShutdownHook(ExecutorService serviceToShutdown) {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Runnable shutdownHook = () -> serviceToShutdown.shutdownNow();
        Runtime.getRuntime().addShutdownHook(threadFactory.newThread(shutdownHook));
    }

    public void setExecutionContext(Window parent) {
        this.parent = parent;
        if (this.initialParent == null) {
            this.initialParent = parent;
        }
    }

    public JDialog getConfiguration(TaskFactory factory, Object tunableContext) {
        throw new UnsupportedOperationException("There is no configuration available for a DialogTaskManager");
    }

    public void execute(TaskIterator iterator) {
        this.execute(iterator, null, null);
    }

    public void execute(TaskIterator iterator, TaskObserver observer) {
        this.execute(iterator, null, observer);
    }

    public void execute(TaskIterator taskIterator, Object tunableContext, TaskObserver observer) {
        Task first;
        TaskHistory.History history = this.taskHistory.newHistory();
        SwingTaskMonitor taskMonitor = new SwingTaskMonitor(this.cancelExecutorService, this.parent, history, this.serviceRegistrar);
        try {
            this.dialogTunableMutator.setConfigurationContext(this.parent, true);
            if (tunableContext != null && !this.displayTunables(tunableContext, taskMonitor)) {
                taskMonitor.cancel();
                return;
            }
            taskMonitor.setExpectedNumTasks(taskIterator.getNumTasks());
            first = taskIterator.next();
            if (!this.displayTunables(first, taskMonitor)) {
                taskMonitor.cancel();
                if (observer != null) {
                    observer.allFinished(FinishStatus.newCancelled((Task)first));
                }
                return;
            }
        }
        catch (Exception exception) {
            logger.warn("Caught exception getting and validating task. ", (Throwable)exception);
            taskMonitor.showException(exception);
            return;
        }
        TaskRunnable tasks = new TaskRunnable(first, taskMonitor, taskIterator, observer, history);
        Future<?> executorFuture = this.taskExecutorService.submit(tasks);
        this.openTaskMonitorOnDelay(taskMonitor, executorFuture);
    }

    private void openTaskMonitorOnDelay(SwingTaskMonitor taskMonitor, Future<?> executorFuture) {
        Runnable timedOpen = () -> {
            if (!executorFuture.isDone() && !executorFuture.isCancelled()) {
                ViewUtil.invokeOnEDT(() -> {
                    if (!taskMonitor.isClosed()) {
                        taskMonitor.open();
                    }
                });
            }
        };
        this.timedDialogExecutorService.schedule(timedOpen, 1L, DELAY_TIMEUNIT);
    }

    private boolean displayTunables(Object task, SwingTaskMonitor taskMonitor) throws Exception {
        if (task == null) {
            return true;
        }
        boolean[] ret = new boolean[]{true};
        if (this.dialogTunableMutator.hasTunables(task, "gui")) {
            taskMonitor.showDialog(false);
            ValidateTunables validateTunables = new ValidateTunables(task, ret);
            ViewUtil.invokeOnEDTAndWait(validateTunables);
            for (TunableRecorder ti : this.tunableRecorders) {
                ti.recordTunableState(task);
            }
            taskMonitor.showDialog(true);
        }
        return ret[0];
    }

    private class TaskThreadFactory
    implements ThreadFactory {
        int thread = 1;

        private TaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            long stackSize;
            try {
                CyProperty cyProperty = (CyProperty)JDialogTaskManager.this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
                Properties props = (Properties)cyProperty.getProperties();
                stackSize = Long.parseLong(props.getProperty("taskStackSize"));
            }
            catch (Exception e) {
                stackSize = 0xA00000L;
            }
            return new Thread(null, r, String.format("Task-Thread-%d-Factory-0x%x", this.thread++, super.hashCode()), stackSize);
        }
    }

    private class TaskRunnable
    implements Runnable {
        private final SwingTaskMonitor taskMonitor;
        private final TaskIterator taskIterator;
        private final TaskObserver observer;
        private final TaskHistory.History history;
        private Task task;

        TaskRunnable(Task first, SwingTaskMonitor tm, TaskIterator ti, TaskObserver observer, TaskHistory.History history) {
            this.task = first;
            this.taskMonitor = tm;
            this.taskIterator = ti;
            this.observer = observer;
            this.history = history;
        }

        private FinishStatus innerRun() throws Exception {
            this.taskMonitor.setTask(this.task);
            this.history.setFirstTaskClass(this.task.getClass());
            this.task.run((TaskMonitor)this.taskMonitor);
            this.handleObserver(this.task);
            if (this.taskMonitor.cancelled()) {
                return FinishStatus.newCancelled((Task)this.task);
            }
            while (this.taskIterator.hasNext()) {
                this.task = this.taskIterator.next();
                this.taskMonitor.setTask(this.task);
                if (!JDialogTaskManager.this.displayTunables(this.task, this.taskMonitor)) {
                    return FinishStatus.newCancelled((Task)this.task);
                }
                this.task.run((TaskMonitor)this.taskMonitor);
                this.handleObserver(this.task);
                if (!this.taskMonitor.cancelled()) continue;
                return FinishStatus.newCancelled((Task)this.task);
            }
            return FinishStatus.getSucceeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FinishStatus finishStatus = null;
            try {
                finishStatus = this.innerRun();
                this.taskMonitor.close();
                JDialogTaskManager.this.taskMediator.setTitle(finishStatus.getType(), this.taskMonitor.getFirstTitle());
            }
            catch (Exception exception) {
                finishStatus = FinishStatus.newFailed((Task)this.task, (Exception)exception);
                logger.warn("Caught exception executing task. ", (Throwable)exception);
                this.taskMonitor.showException(exception);
                this.history.addMessage(TaskMonitor.Level.ERROR, exception.getMessage());
            }
            catch (Throwable notAnException) {
                Exception surrogateException = new Exception(notAnException);
                finishStatus = FinishStatus.newFailed((Task)this.task, (Exception)surrogateException);
                logger.error("Caught an error executing task. ", notAnException);
                this.taskMonitor.showException(surrogateException);
                this.history.addMessage(TaskMonitor.Level.ERROR, notAnException.getMessage());
            }
            finally {
                if (finishStatus == null) {
                    finishStatus = FinishStatus.newFailed((Task)this.task, (Exception)new IllegalStateException("Finish status was not set"));
                }
                this.history.setFinishType(finishStatus.getType());
                if (this.observer != null) {
                    this.observer.allFinished(finishStatus);
                }
                JDialogTaskManager.this.parent = JDialogTaskManager.this.initialParent;
                JDialogTaskManager.this.dialogTunableMutator.setConfigurationContext(null, true);
            }
        }

        private void handleObserver(Task t) {
            if (t instanceof ObservableTask && this.observer != null) {
                this.observer.taskFinished((ObservableTask)t);
            }
        }
    }

    class ValidateTunables
    implements Runnable {
        final Object task;
        final boolean[] ret;

        public ValidateTunables(Object task, boolean[] ret) {
            this.task = task;
            this.ret = ret;
        }

        @Override
        public void run() {
            this.ret[0] = JDialogTaskManager.this.dialogTunableMutator.validateAndWriteBack(this.task);
        }
    }
}

