/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.cytoscape.util.color.Palette;

public class PaletteIcon
implements Icon {
    private Palette palette;
    private int colorCount;
    private int width;
    private int height;
    private Color[] colors;

    public PaletteIcon(Palette palette, int colorCount, int width, int height) {
        this.palette = palette;
        this.colorCount = colorCount;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.colors = this.palette.getColors(this.colorCount);
        for (int i = 0; i < this.colorCount; ++i) {
            g.setColor(this.colors[i]);
            g.fillRect(x, y + i * this.height, this.width, this.height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y + i * this.height, this.width, this.height);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height * this.colorCount;
    }
}

