/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBrowserImpl
implements OpenBrowser {
    private static String[] BROWSERS = new String[]{"xdg-open", "htmlview", "firefox", "mozilla", "konqueror", "chrome", "chromium"};
    private final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyServiceRegistrar serviceRegistrar;

    public OpenBrowserImpl(CyServiceRegistrar registrar) {
        this.serviceRegistrar = registrar;
    }

    public boolean openURL(String url, boolean useCyBrowser) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL has an incorrect format: " + url);
        }
        if (useCyBrowser) {
            if (this.openURLWithCyBrowser(url, new HashMap<String, Object>())) {
                return true;
            }
        } else {
            if (this.openURLWithDesktop(uri)) {
                return true;
            }
            if (this.openURLWithDefault(url)) {
                return true;
            }
        }
        this.logger.warn("Cytoscape was unable to open your web browser... \nPlease copy the following URL and paste it into your browser: " + url);
        return false;
    }

    public boolean openURL(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL has an incorrect format: " + url);
        }
        if (this.isDialogBlocking()) {
            if (this.openURLWithDefault(url)) {
                return true;
            }
            if (this.openURLWithDesktop(uri)) {
                return true;
            }
            if (this.openURLWithCyBrowser(url, new HashMap<String, Object>())) {
                return true;
            }
        } else {
            if (this.openURLWithCyBrowser(url, new HashMap<String, Object>())) {
                return true;
            }
            if (this.openURLWithDesktop(uri)) {
                return true;
            }
            if (this.openURLWithDefault(url)) {
                return true;
            }
        }
        this.logger.warn("Cytoscape was unable to open your web browser... \nPlease copy the following URL and paste it into your browser: " + url);
        return false;
    }

    private boolean openURLWithDesktop(URI uri) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (IOException e) {
            this.logger.warn("Failed to launch web browser through java.awt.Desktop.browse(): " + e.getMessage());
            return false;
        }
    }

    private boolean openURLWithDefault(String url) {
        String defBrowser = this.getProperty("defaultWebBrowser");
        try {
            if (defBrowser != null && this.openURLWithBrowser(url, defBrowser)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String browser : BROWSERS) {
            try {
                if (!this.openURLWithBrowser(url, browser)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean openURLWithBrowser(String url, String browser) {
        ProcessBuilder builder = new ProcessBuilder(browser, url);
        try {
            builder.start();
            return true;
        }
        catch (IOException e) {
            this.logger.info(String.format("Failed to launch browser process %s: %s", browser, e.getMessage()));
            return false;
        }
    }

    private boolean openURLWithCyBrowser(String url, Map<String, Object> extraArgs) {
        String useCyBrowser = this.getProperty("useCyBrowser");
        if (useCyBrowser != null && !Boolean.parseBoolean(useCyBrowser)) {
            return false;
        }
        AvailableCommands availableCommands = (AvailableCommands)this.serviceRegistrar.getService(AvailableCommands.class);
        List args = availableCommands.getArguments("cybrowser", "dialog");
        if (args == null || args.size() == 0) {
            return false;
        }
        if (extraArgs == null) {
            extraArgs = new HashMap<String, Object>();
        }
        extraArgs.put("url", url);
        CommandExecutorTaskFactory taskFactory = (CommandExecutorTaskFactory)this.serviceRegistrar.getService(CommandExecutorTaskFactory.class);
        TaskIterator ti = taskFactory.createTaskIterator("cybrowser", "dialog", extraArgs, null);
        try {
            SynchronousTaskManager taskManager = (SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class);
            taskManager.execute(ti);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean isDialogBlocking() {
        Window[] windows;
        boolean blocking = false;
        for (Window w : windows = Window.getWindows()) {
            Dialog.ModalityType modalityType;
            if (!w.isShowing() || !(w instanceof Dialog) || (modalityType = ((Dialog)w).getModalityType()) != Dialog.ModalityType.APPLICATION_MODAL && modalityType != Dialog.ModalityType.TOOLKIT_MODAL) continue;
            blocking = true;
            break;
        }
        return blocking;
    }

    private String getProperty(String key) {
        CyProperty cyProps = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = (Properties)cyProps.getProperties();
        return props.getProperty(key);
    }
}

