/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.cytoscape.util.swing.IconManager;

public class IconManagerImpl
implements IconManager {
    private Font defFont;
    private Map<String, Font> fontMap = new HashMap<String, Font>();
    private Map<String, Icon> iconMap = new HashMap<String, Icon>();
    private final Object fontLock = new Object();
    private final Object iconLock = new Object();

    public IconManagerImpl() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/fonts/fontawesome-webfont.ttf");
            this.defFont = Font.createFont(0, stream);
        }
        catch (FontFormatException | IOException e) {
            throw new RuntimeException(e);
        }
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.defFont);
    }

    public Font getIconFont(float size) {
        return this.defFont.deriveFont(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getIconFont(String fontName, float size) {
        if (fontName == null) {
            throw new IllegalArgumentException("'fontName' must not be null");
        }
        Font font = null;
        Object object = this.fontLock;
        synchronized (object) {
            font = this.fontMap.get(fontName);
        }
        return font != null ? font.deriveFont(size) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIconFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("'font' must not be null");
        }
        if ("FontAwesome".equals(font.getName())) {
            throw new IllegalArgumentException("Cannot add font that has the same name as the default one");
        }
        Object object = this.fontLock;
        synchronized (object) {
            this.fontMap.put(font.getFontName(), font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font removeIconFont(String fontName) {
        if (fontName == null) {
            throw new IllegalArgumentException("'fontName' must not be null");
        }
        if ("FontAwesome".equals(fontName)) {
            throw new IllegalArgumentException("The default font cannot be removed");
        }
        Object object = this.fontLock;
        synchronized (object) {
            return this.fontMap.remove(fontName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcon(String id, Icon icon) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("'id' must not be null or empty");
        }
        if (icon == null) {
            throw new IllegalArgumentException("'icon' must not be null");
        }
        Object object = this.iconLock;
        synchronized (object) {
            this.iconMap.put(id, icon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon removeIcon(String id) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("'id' must not be null or empty");
        }
        Object object = this.iconLock;
        synchronized (object) {
            return this.iconMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(String id) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("'id' must not be null or empty");
        }
        Object object = this.iconLock;
        synchronized (object) {
            return this.iconMap.get(id);
        }
    }
}

