/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.internal.ColorPaletteProviderPanel;
import org.cytoscape.util.swing.internal.ColorPanelSelectionModel;

class CyColorPaletteChooserImpl
extends JDialog
implements CyColorPaletteChooser {
    private final PaletteProviderManager paletteManager;
    private final PaletteType paletteType;
    protected Palette initialPalette;
    protected Color initialColor;
    private boolean paletteOnly;
    protected boolean okWasPressed;
    protected ActionListener okListener;
    protected ActionListener cancelListener;
    protected JPanel innerPanel;
    protected JCheckBox reverseColorsCB;
    private static JColorChooser colorChooser;
    private static ColorPanelSelectionModel model;
    private static boolean lastPaletteOnly;
    private static int colorCount;
    private static PaletteType lastPaletteType;
    private static ColorPaletteProviderPanel[] palettePanels;

    public CyColorPaletteChooserImpl(PaletteProviderManager paletteManager, PaletteType type, boolean paletteOnly) {
        this.paletteOnly = paletteOnly;
        this.paletteManager = paletteManager;
        this.paletteType = type;
    }

    public Color showDialog(Component parent, String title, Palette initialPalette, Color initialColor, int colors) {
        this.checkColorChooser(colors, false);
        this.paletteOnly = false;
        lastPaletteOnly = false;
        lastPaletteType = this.paletteType;
        colorCount = colors < 1 ? 9 : colors;
        this.init(parent, title, initialPalette, initialColor);
        if (this.showDialog()) {
            return this.getSelectedColor();
        }
        return null;
    }

    public Palette showDialog(Component parent, String title, Palette initialPalette, int colors) {
        this.checkColorChooser(colors, true);
        this.paletteOnly = true;
        lastPaletteOnly = true;
        lastPaletteType = this.paletteType;
        colorCount = colors < 1 ? 9 : colors;
        this.init(parent, title, initialPalette, null);
        if (this.showDialog()) {
            return this.getSelectedPalette();
        }
        return null;
    }

    public Color getSelectedColor() {
        return this.getColor();
    }

    public Palette getSelectedPalette() {
        return this.getColorPalette();
    }

    private void init(Component parent, String title, Palette initialPalette, Color initialColor) {
        this.initialPalette = initialPalette;
        this.initialColor = initialColor;
        this.setLocationRelativeTo(parent);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(title);
        this.setDefaultCloseOperation(1);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        pane.add((Component)this.innerPanel, "Center");
        JPanel colorsTab = new JPanel();
        colorsTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        colorsTab.setLayout(new BoxLayout(colorsTab, 1));
        this.innerPanel.add(colorsTab);
        if (colorChooser == null) {
            model = new ColorPanelSelectionModel();
            colorChooser = new JColorChooser(model);
            List<PaletteProvider> providers = this.getPaletteProviders(false);
            palettePanels = this.getPanels(providers, colorCount);
            if (this.paletteOnly) {
                colorChooser.setChooserPanels(palettePanels);
                colorChooser.setPreviewPanel(new JPanel());
            } else {
                int i;
                AbstractColorChooserPanel[] oldPanels = colorChooser.getChooserPanels();
                AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[oldPanels.length + palettePanels.length];
                for (i = 0; i < palettePanels.length; ++i) {
                    newPanels[i] = palettePanels[i];
                }
                for (i = 0; i < oldPanels.length; ++i) {
                    newPanels[i + CyColorPaletteChooserImpl.palettePanels.length] = oldPanels[i];
                }
                colorChooser.setChooserPanels(newPanels);
            }
        }
        if (initialPalette != null) {
            model.setPalette(initialPalette);
        }
        if (initialColor != null) {
            model.setSelectedColor(initialColor);
        }
        JScrollPane colorPane = new JScrollPane(colorChooser, 20, 31);
        colorsTab.add((Component)colorPane, "Center");
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(new FlowLayout(1, 0, 0));
        cbPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        colorsTab.add((Component)cbPanel, "South");
        JPanel cbReverseGridPanel = new JPanel();
        cbPanel.add(cbReverseGridPanel);
        this.reverseColorsCB = new JCheckBox("reverse colors");
        if (initialPalette != null && initialPalette.isReversable() && initialPalette.isReversed()) {
            this.reverseColorsCB.setSelected(true);
        } else if (initialPalette != null && !initialPalette.isReversable()) {
            this.reverseColorsCB.setEnabled(false);
        }
        this.reverseColorsCB.addActionListener(e -> {
            JCheckBox source = (JCheckBox)e.getSource();
            boolean reverseColors = source.isSelected();
            for (ColorPaletteProviderPanel cbccp : palettePanels) {
                cbccp.setReverseColors(reverseColors);
                cbccp.updateChooser();
                colorChooser.repaint();
            }
        });
        cbReverseGridPanel.add(this.reverseColorsCB);
        JPanel cbFriendlyGridPanel = new JPanel();
        cbPanel.add(cbFriendlyGridPanel);
        JCheckBox colorBlindOnly = new JCheckBox("show only colorblind-friendly");
        colorBlindOnly.addActionListener(e -> {
            JCheckBox source = (JCheckBox)e.getSource();
            for (ColorPaletteProviderPanel cbccp : palettePanels) {
                cbccp.setShowColorBlindSafe(source.isSelected());
                cbccp.updateChooser();
                colorChooser.repaint();
            }
        });
        cbFriendlyGridPanel.add(colorBlindOnly);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        colorsTab.add((Component)buttonPanel, "Center");
        JPanel buttonGridPanel = new JPanel();
        buttonGridPanel.setLayout(new GridLayout(1, 3, 5, 0));
        buttonPanel.add(buttonGridPanel);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> {
            Palette palette = this.initialPalette;
            this.setPalette(palette);
            this.setColor(this.initialColor);
            for (ColorPaletteProviderPanel cbccp : palettePanels) {
                cbccp.setSelectedPalette(palette != null ? palette.getName() : null);
                cbccp.updateChooser();
                colorChooser.repaint();
            }
        });
        buttonGridPanel.add(resetButton);
        JButton okButton = new JButton("OK");
        okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(e -> {
            this.okWasPressed = true;
            this.setVisible(false);
            this.initialPalette = this.getColorPalette();
            if (this.okListener != null) {
                this.okListener.actionPerformed(e);
            }
        });
        buttonGridPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.setPalette(this.initialPalette);
            this.okWasPressed = false;
            this.setVisible(false);
            if (this.cancelListener != null) {
                this.cancelListener.actionPerformed(e);
            }
        });
        buttonGridPanel.add(cancelButton);
        this.pack();
        this.validate();
    }

    private boolean checkColorChooser(int colors, boolean paletteO) {
        if (colors < 1) {
            colors = 9;
        }
        if (colorCount == colors && lastPaletteOnly == paletteO && lastPaletteType == this.paletteType) {
            return true;
        }
        colorChooser = null;
        return false;
    }

    public boolean showDialog() {
        if (this.isModal()) {
            this.setVisible(true);
            return this.okWasPressed;
        }
        this.setModal(true);
        this.setVisible(true);
        boolean status = this.okWasPressed;
        this.setModal(false);
        this.dispose();
        return status;
    }

    public boolean wasOKPressed() {
        return this.okWasPressed;
    }

    public Color getColor() {
        return colorChooser.getColor();
    }

    public void setColor(Color color) {
        colorChooser.setColor(color);
        this.initialColor = color;
    }

    public void setColor(int red, int green, int blue) {
        this.initialColor = new Color(red, green, blue);
        colorChooser.setColor(this.initialColor);
    }

    public Palette getColorPalette() {
        ColorPanelSelectionModel model = (ColorPanelSelectionModel)colorChooser.getSelectionModel();
        return model.getPalette();
    }

    public void setPalette(Palette palette) {
        if (palette == null) {
            palette = this.initialPalette;
        }
        ColorPanelSelectionModel model = (ColorPanelSelectionModel)colorChooser.getSelectionModel();
        model.setPalette(palette);
        this.initialPalette = palette;
        if (palette != null) {
            this.reverseColorsCB.setEnabled(palette.isReversable());
        }
    }

    private List<PaletteProvider> getPaletteProviders(boolean colorBlindOnly) {
        return this.paletteManager.getPaletteProviders(this.paletteType, colorBlindOnly);
    }

    private ColorPaletteProviderPanel[] getPanels(List<PaletteProvider> providers, int size) {
        ArrayList<ColorPaletteProviderPanel> panels = new ArrayList<ColorPaletteProviderPanel>();
        for (PaletteProvider provider : providers) {
            if (this.paletteType.equals(BrewerType.ANY)) {
                for (PaletteType t : provider.getPaletteTypes()) {
                    panels.add(new ColorPaletteProviderPanel(provider, t, size, this.paletteOnly));
                }
                continue;
            }
            panels.add(new ColorPaletteProviderPanel(provider, this.paletteType, size, this.paletteOnly));
        }
        return panels.toArray(new ColorPaletteProviderPanel[1]);
    }
}

