/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;

public class AppUtil {
    public static final String APP_STORE_URL = "https://apps.cytoscape.org/";

    public static String getAppStoreURL(CyServiceRegistrar registrar) {
        CyProperty cyProps = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = (Properties)cyProps.getProperties();
        String appStoreUrl = props.getProperty("appStoreDownloadSiteUrl1");
        if (appStoreUrl == null || appStoreUrl.equals("http://apps.cytoscape.org/")) {
            appStoreUrl = APP_STORE_URL;
        }
        return appStoreUrl;
    }

    public static String[] dumbSplit(String s, char delimiter) {
        int delimiterIndex;
        if (s == null) {
            return null;
        }
        int delimiterCount = 0;
        int scanIndex = 0;
        while (scanIndex < s.length()) {
            int delimiterIndex2 = s.indexOf(delimiter, scanIndex);
            if (delimiterIndex2 >= 0) {
                ++delimiterCount;
                scanIndex = delimiterIndex2 + 1;
                continue;
            }
            scanIndex = s.length();
        }
        String[] splitList = new String[delimiterCount + 1];
        scanIndex = 0;
        delimiterCount = 0;
        while (scanIndex < s.length() && (delimiterIndex = s.indexOf(delimiter, scanIndex)) >= 0) {
            splitList[delimiterCount] = s.substring(scanIndex, delimiterIndex);
            ++delimiterCount;
            scanIndex = delimiterIndex + 1;
        }
        splitList[delimiterCount] = s.substring(scanIndex);
        return splitList;
    }

    private static int pyIndexOfChar(String s, int fromIndex, char ch) {
        int index = s.indexOf(ch, fromIndex);
        return index < 0 ? s.length() : index;
    }

    private static int indexOfChar(String s, int startIndex, char delimiter) {
        int indexDelimiter = AppUtil.pyIndexOfChar(s, startIndex, delimiter);
        int indexQuote = AppUtil.pyIndexOfChar(s, startIndex, '\"');
        while (indexQuote < indexDelimiter) {
            int indexCloseQuote = AppUtil.pyIndexOfChar(s, indexQuote + 1, '\"');
            indexDelimiter = AppUtil.pyIndexOfChar(s, indexCloseQuote + 1, delimiter);
            indexQuote = AppUtil.pyIndexOfChar(s, indexCloseQuote + 1, '\"');
        }
        return indexDelimiter;
    }

    public static ArrayList<String> splitByChar(String packageList, char delimiter) {
        ArrayList<String> splitList = new ArrayList<String>();
        int index = 0;
        while (index < packageList.length()) {
            int nextIndex = AppUtil.indexOfChar(packageList, index, delimiter);
            splitList.add(packageList.substring(index, nextIndex));
            index = nextIndex + 1;
        }
        return splitList;
    }

    public static Window getWindowAncestor(ActionEvent evt, CySwingApplication swingApplication) {
        Window window = null;
        if (evt.getSource() instanceof JMenuItem) {
            if (swingApplication.getJMenuBar() != null) {
                window = SwingUtilities.getWindowAncestor(swingApplication.getJMenuBar());
            }
        } else if (evt.getSource() instanceof Component) {
            window = SwingUtilities.getWindowAncestor((Component)evt.getSource());
        }
        if (window == null || !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = swingApplication.getJFrame();
        }
        return window;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

