/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTextPane;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.ui.Article;
import org.cytoscape.app.internal.ui.PubMedParser;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

class RetrieveTask
implements Task {
    protected static final String CYTOSCAPE_PMID = "14597658";
    private final WebQuerier webQuerier;
    private final JTextPane textPane;
    private final AppManager appManager;

    public RetrieveTask(WebQuerier webQuerier, JTextPane textPane, AppManager appManager) {
        this.webQuerier = webQuerier;
        this.textPane = textPane;
        this.appManager = appManager;
    }

    private Map<String, String> getPmidsOfApps() {
        HashMap<String, String> pmids = new HashMap<String, String>();
        Set<WebApp> allApps = this.webQuerier.getAllApps();
        this.webQuerier.checkWebAppInstallStatus(allApps, this.appManager);
        for (WebApp app : allApps) {
            if (app.getCorrespondingApp() == null || app.getCorrespondingApp().getStatus() != App.AppStatus.INSTALLED || app.getCitation() == null) continue;
            pmids.put(app.getFullName(), app.getCitation());
        }
        return pmids;
    }

    public void run(TaskMonitor monitor) throws Exception {
        monitor.setTitle("Retrieve citations from PubMed");
        monitor.showMessage(TaskMonitor.Level.INFO, "Retrieve list of apps");
        Map<String, String> pmids = this.getPmidsOfApps();
        pmids.put("Cytoscape", CYTOSCAPE_PMID);
        monitor.showMessage(TaskMonitor.Level.INFO, "Retrieve articles");
        PubMedParser pubMedParser = new PubMedParser();
        Map<String, Article> articles = pubMedParser.retrieveArticles(pmids);
        StringBuffer buffer = new StringBuffer("<html>");
        RetrieveTask.formatArticleAsHtmlDefinition("Cytoscape", articles.get("Cytoscape"), buffer);
        buffer.append("<br><hr><br>");
        for (String name : new TreeSet<String>(articles.keySet())) {
            if (name.equals("Cytoscape")) continue;
            Article article = articles.get(name);
            RetrieveTask.formatArticleAsHtmlDefinition(name, article, buffer);
        }
        buffer.append("</html>");
        this.textPane.setText(buffer.toString());
    }

    private static void formatArticleAsHtmlDefinition(String name, Article article, StringBuffer buffer) {
        buffer.append("<dl><dt><b>");
        buffer.append(name);
        buffer.append("</b></dt>");
        buffer.append("<dd>");
        buffer.append(article.toString());
        buffer.append("<br>");
        buffer.append("<font size=\"-1\"><a href=\"http://www.ncbi.nlm.nih.gov/pubmed/");
        buffer.append(article.getPmid());
        buffer.append("\">Open in PubMed &rarr;</a></font>");
        buffer.append("</dd></dl>");
    }

    public void cancel() {
    }
}

