/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.app.internal.ui.downloadsites.ManageDownloadSitesDialog;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.swing.DialogTaskManager;

public class AppManagerDialog
extends JDialog {
    private JTabbedPane mainTabbedPane;
    private ManageDownloadSitesDialog manageDownloadSitesDialog;
    private DownloadSitesManager downloadSitesManager;
    private final AppManager appManager;
    private final UpdateManager updateManager;
    private final CyServiceRegistrar serviceRegistrar;

    public AppManagerDialog(Window parent, AppManager appManager, DownloadSitesManager downloadSitesManager, UpdateManager updateManager, CyServiceRegistrar serviceRegistrar) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.updateManager = updateManager;
        this.serviceRegistrar = serviceRegistrar;
        this.manageDownloadSitesDialog = new ManageDownloadSitesDialog(parent, downloadSitesManager);
        this.manageDownloadSitesDialog.setLocationRelativeTo(this);
        this.setLocationRelativeTo(parent);
        appManager.setAppManagerDialog(this);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("App Manager");
        FileUtil fileUtil = (FileUtil)this.serviceRegistrar.getService(FileUtil.class);
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        this.mainTabbedPane = new JTabbedPane();
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppManagerDialog.this.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)closeButton, (String)"App_Manager");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)closeButton.getAction());
        this.pack();
    }

    public void changeTab(int index) {
        this.mainTabbedPane.setSelectedIndex(index);
    }

    public void showManageDownloadSitesDialog() {
        if (this.manageDownloadSitesDialog != null) {
            this.manageDownloadSitesDialog.setLocationRelativeTo(this);
            this.manageDownloadSitesDialog.setVisible(true);
        }
    }

    public void showNetworkError(String errorMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.showNetworkError(errorMessage));
        }
    }

    public void hideNetworkError() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.hideNetworkError());
        }
    }
}

