/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.tunable;

import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.task.ResolveAppConflictTask;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.DirectlyPresentableTunableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConflictHandler
extends AbstractGUITunableHandler
implements DirectlyPresentableTunableHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    protected AppConflictHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
    }

    protected AppConflictHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
    }

    public boolean setTunableDirectly(Window possibleParent) {
        try {
            ResolveAppConflictTask.AppConflict conflict = (ResolveAppConflictTask.AppConflict)this.getValue();
            Map<App, App> appsToReplace = conflict.getAppsToReplace();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            JLabel title = new JLabel("The following " + (appsToReplace.size() == 1 ? "app" : "apps") + " will be replaced:");
            title.setAlignmentX(0.0f);
            panel.add(title);
            panel.add(Box.createVerticalStrut(title.getPreferredSize().height));
            Object deps = "";
            for (Map.Entry<App, App> entry : appsToReplace.entrySet()) {
                deps = (String)deps + entry.getKey().getAppName() + " (to be installed: " + entry.getKey().getVersion() + ", " + entry.getValue().getVersion() + " currently installed)\n";
            }
            deps = ((String)deps).substring(0, ((String)deps).length() - 1);
            JTextArea textArea = new JTextArea((String)deps);
            textArea.setRows(Math.min(appsToReplace.size(), 10));
            textArea.setEditable(false);
            textArea.setHighlighter(null);
            textArea.setBorder(null);
            textArea.setOpaque(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setAlignmentX(0.0f);
            scrollPane.setBorder(null);
            scrollPane.getViewport().setOpaque(false);
            scrollPane.setOpaque(false);
            panel.add(scrollPane);
            panel.add(Box.createVerticalStrut(title.getPreferredSize().height));
            JLabel message = new JLabel("Continue?");
            message.setAlignmentX(0.0f);
            panel.add(message);
            Dimension size = panel.getPreferredSize();
            if (size.width > 600) {
                size.width = 600;
                panel.setPreferredSize(size);
            }
            int response = JOptionPane.showConfirmDialog(possibleParent, panel, "Replace " + (appsToReplace.size() == 1 ? "App" : "Apps"), 2);
            conflict.setReplaceApps(response);
        }
        catch (IllegalAccessException e) {
            logger.warn("Error accessing conflict object", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("Exception thrown by conflict object", (Throwable)e);
        }
        return true;
    }

    public boolean isForcedToSetDirectly() {
        return true;
    }

    public void handle() {
    }
}

