/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.app.internal.task.InstallUpdatesTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class UpdateTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="Name of app to update", longDescription="The name of the app to uninstall or ```all`` to update all apps.", exampleStringValue="stringApp", context="nogui", required=true)
    public String app = null;
    String error = null;
    final UpdateManager updateManager;
    List<Update> updateList;
    App appObject;

    public UpdateTask(AppManager appManager, UpdateManager updateManager) {
        super(appManager);
        this.updateManager = updateManager;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "App name not provided");
            return;
        }
        this.updateList = new ArrayList<Update>();
        this.updateApps();
        this.updateWebApps();
        Set<Update> updates = this.updateManager.getUpdates();
        if (updates.size() == 0) {
            this.error = "All apps are current: nothing to update";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        if (this.app.equals("all")) {
            this.updateList.addAll(updates);
        } else {
            for (Update update : updates) {
                this.appObject = update.getApp();
                if (this.appObject == null) {
                    this.error = "Can't find app '" + this.app + "'";
                    taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
                    return;
                }
                if (!this.appObject.getAppName().equalsIgnoreCase(this.app)) continue;
                this.updateList.add(update);
            }
        }
        taskMonitor.setTitle("Updating apps");
        this.insertTasksAfterCurrentTask(new Task[]{new InstallUpdatesTask(this.updateList, this.appManager)});
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                Object str = "[";
                int count = this.updateList.size();
                int index = 0;
                for (Update update : this.updateList) {
                    App appObject = update.getApp();
                    str = (String)str + "{\"appName\": \"" + appObject.getAppName() + "\"";
                    str = (String)str + ",\"version\": \"" + appObject.getVersion() + "\"}";
                    if (index < this.updateList.size() - 1) {
                        str = (String)str + ",";
                    }
                    ++index;
                }
                str = (String)str + "]";
                return str;
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            if (this.updateList.size() > 0) {
                if (this.error != null) {
                    return (R)this.error;
                }
                Object res = "Updated apps:\n";
                for (Update update : this.updateList) {
                    res = (String)res + "    " + update.getApp().getAppName() + "\n";
                }
                return (R)res;
            }
            return null;
        }
        return null;
    }
}

