/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class StatusTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="Name of app to get the status of", longDescription="The name of the app to get the status of", exampleStringValue="stringApp", context="nogui", required=true)
    public String app = null;
    String error = null;
    private App appObject = null;
    private App.AppStatus status;

    public StatusTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null) {
            this.error = "App name not provided";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        taskMonitor.setTitle("Getting the status of app " + this.app);
        this.updateApps();
        this.appObject = this.getApp(this.app);
        if (this.appObject == null) {
            this.error = "Can't find app '" + this.app + "'";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        this.status = this.appObject.getStatus();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                return "{\"appName\": \"" + this.app + "\", \"status\": \"" + this.status.toString() + "\" }";
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            if (this.error != null) {
                return (R)this.error;
            }
            String res = "app: " + this.app + ", status: " + this.status.toString();
            return (R)res;
        }
        return null;
    }
}

