/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.InstallAppsFromFileTask;
import org.cytoscape.app.internal.task.ShowInstalledAppsTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

public class ManagerInstallAppsFromFileTask
extends AbstractTask {
    final AppManager appManager;
    final TaskManager taskManager;
    final CyServiceRegistrar serviceRegistrar;

    public ManagerInstallAppsFromFileTask(AppManager appManager, TaskManager taskManager, CyServiceRegistrar serviceRegistrar) {
        this.appManager = appManager;
        this.taskManager = taskManager;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        SwingUtilities.invokeLater(() -> {
            FileUtil fileUtil = (FileUtil)this.serviceRegistrar.getService(FileUtil.class);
            FileChooserFilter fileChooserFilter = new FileChooserFilter("Jar, Zip, and Karaf Kar Files (*.jar, *.zip, *.kar)", new String[]{"jar", "zip", "kar"});
            LinkedList<FileChooserFilter> fileChooserFilters = new LinkedList<FileChooserFilter>();
            fileChooserFilters.add(fileChooserFilter);
            JDialog wrapper = new JDialog((Window)null);
            wrapper.setVisible(false);
            File[] files = fileUtil.getFiles((Component)wrapper, "Choose file(s)", 0, "directory.last", "Install", true, fileChooserFilters);
            if (files != null) {
                TaskIterator ti = new TaskIterator(new Task[0]);
                ti.append((Task)new InstallAppsFromFileTask(Arrays.asList(files), this.appManager, true));
                ti.append((Task)new ShowInstalledAppsTask(wrapper));
                this.taskManager.setExecutionContext((Object)wrapper);
                this.taskManager.execute(ti);
            }
        });
    }
}

