/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Collection;
import java.util.Map;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class InstallAppsTask
extends AbstractTask {
    final Collection<App> appsToInstall;
    final Map<App, App> appsToReplace;
    final AppManager appManager;

    public InstallAppsTask(Collection<App> appsToInstall, Map<App, App> appsToReplace, AppManager appManager) {
        this.appsToInstall = appsToInstall;
        this.appsToReplace = appsToReplace;
        this.appManager = appManager;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        for (App appToInstall : this.appsToInstall) {
            App appToReplace = this.appsToReplace.get(appToInstall);
            if (appToReplace != null) {
                taskMonitor.setStatusMessage("Updating " + appToInstall.getAppName());
            } else {
                taskMonitor.setStatusMessage("Installing " + appToInstall.getAppName());
            }
            this.appManager.installApp(appToInstall);
            if (appToReplace == null || appToInstall.getVersion().equals(appToReplace.getVersion())) continue;
            this.appManager.uninstallApp(appToReplace);
        }
    }
}

