/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class InformationTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="App name", longDescription="The name of the app to get information on", exampleStringValue="stringApp", context="nogui", required=true)
    public String app = null;
    String error = null;
    WebApp webApp;

    public InformationTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "App name not provided");
            return;
        }
        taskMonitor.setTitle("Getting app " + this.app + " information");
        this.updateWebApps();
        this.webApp = this.getWebApp(this.app);
        if (this.webApp == null) {
            this.error = "Can't find app '" + this.app + "'";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "Got information on '" + this.app + "'");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                Object str = "{";
                str = (String)str + "\"app\": \"" + this.app + "\",";
                str = (String)str + "\"descriptionName\": " + AppUtil.quote(this.webApp.getDescription()) + ",";
                str = (String)str + "\"version\": \"" + this.getVersion(this.webApp) + "\"}";
                return str;
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            if (this.error != null) {
                return (R)this.error;
            }
            String res = "App: " + this.webApp.getName() + ", description: " + this.webApp.getDescription() + ", version: " + this.getVersion(this.webApp);
            return (R)res;
        }
        return null;
    }
}

