/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class EnableTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="Name of app to enable", longDescription="The name of the app to enable", exampleStringValue="stringApp", context="nogui", required=true)
    public String app = null;
    public String error = null;
    App appObject = null;

    public EnableTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "App name not provided");
            return;
        }
        taskMonitor.setTitle("Enabling app " + this.app);
        this.updateApps();
        this.appObject = this.getApp(this.app);
        if (this.appObject == null) {
            this.error = "Can't find app '" + this.app + "'";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        if (!this.appObject.getStatus().equals((Object)App.AppStatus.DISABLED)) {
            this.error = "App '" + this.app + "' is not disabled";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        this.appManager.installApp(this.appObject);
        this.updateApps();
        String msg = "App '" + this.app + "' re-enabled";
        taskMonitor.showMessage(TaskMonitor.Level.INFO, msg);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                return "{\"appName\": \"" + this.app + "\"}";
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            return (R)this.error;
        }
        return null;
    }
}

