/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.cytoscape.app.internal.exception.AppDownloadException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.DownloadStatus;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.ui.AppManagerDialog;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.app.internal.util.DebugHelper;
import org.cytoscape.application.CyVersion;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebQuerier {
    public static final List<DownloadSite> DEFAULT_DOWNLOAD_SITES = new LinkedList<DownloadSite>();
    public static final String DEFAULT_APP_STORE_URL = "https://apps.cytoscape.org/";
    private static final String REQUEST_JSON_HEADER_KEY = "X-Requested-With";
    private static final String REQUEST_JSON_HEADER_VALUE = "XMLHttpRequest";
    private static final String COMPATIBLE_RELEASE_REGEX = "(^\\s*|.*,)\\s*3(\\..*)?\\s*(\\s*$|,.*)";
    private static final Logger logger;
    private Map<String, Set<WebApp>> appsByUrl;
    private Map<String, Map<String, Set<WebApp>>> appsByTagNameByUrl;
    private Map<String, Map<String, AppTag>> appTagsByUrl;
    private boolean showMultipleWarnings = false;
    private String currentAppStoreUrl = "https://apps.cytoscape.org/";
    private String currentSiteName = null;
    private static final Pattern VERSION_PATTERN;
    public static final Pattern OUTPUT_FILENAME_DISALLOWED_CHARACTERS;
    private AppManager appManager;
    private final CyServiceRegistrar serviceRegistrar;

    public WebQuerier(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.appsByUrl = new HashMap<String, Set<WebApp>>();
        this.appTagsByUrl = new HashMap<String, Map<String, AppTag>>();
        this.appsByTagNameByUrl = new HashMap<String, Map<String, Set<WebApp>>>();
        this.appsByUrl.put(this.currentAppStoreUrl, null);
        this.appTagsByUrl.put(this.currentAppStoreUrl, new HashMap());
        this.appsByTagNameByUrl.put(this.currentAppStoreUrl, new HashMap());
    }

    public void setShowMultipleWarnings(boolean show) {
        this.showMultipleWarnings = show;
    }

    private String query(String url) throws IOException {
        URL parsedUrl = null;
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IOException("Malformed url, " + e.getMessage());
        }
        String result = null;
        StreamUtil streamUtil = (StreamUtil)this.serviceRegistrar.getService(StreamUtil.class);
        HttpURLConnection connection = (HttpURLConnection)streamUtil.getURLConnection(parsedUrl);
        connection.setRequestProperty(REQUEST_JSON_HEADER_KEY, REQUEST_JSON_HEADER_VALUE);
        connection.setReadTimeout(10000);
        connection.connect();
        InputStream inputStream = connection.getInputStream();
        result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        connection.disconnect();
        return result;
    }

    public void setAppManager(AppManager appManager) {
        this.appManager = appManager;
    }

    public String getDefaultAppStoreUrl() {
        return DEFAULT_APP_STORE_URL;
    }

    public String getCurrentAppStoreUrl() {
        return this.currentAppStoreUrl;
    }

    public void setCurrentAppStoreUrl(String url) {
        boolean malformed = false;
        try {
            URL uRL = new URL(url);
        }
        catch (MalformedURLException e) {
            malformed = true;
            logger.warn("Malformed URL: " + url + ", " + e.getMessage());
        }
        if (!malformed) {
            this.currentAppStoreUrl = !url.trim().endsWith("/") ? url + "/" : url;
            if (this.appsByUrl.get(this.currentAppStoreUrl) == null) {
                this.appsByUrl.put(this.currentAppStoreUrl, null);
            }
            if (this.appTagsByUrl.get(this.currentAppStoreUrl) == null) {
                this.appTagsByUrl.put(this.currentAppStoreUrl, new HashMap());
            }
            if (this.appsByTagNameByUrl.get(this.currentAppStoreUrl) == null) {
                this.appsByTagNameByUrl.put(this.currentAppStoreUrl, new HashMap());
            }
        }
    }

    public void setCurrentSiteName(String site) {
        this.currentSiteName = site;
    }

    public Set<AppTag> getAllTags() {
        Set<WebApp> apps = this.getAllApps();
        return new HashSet<AppTag>(this.appTagsByUrl.get(this.currentAppStoreUrl).values());
    }

    public boolean appsHaveBeenLoaded() {
        return this.appsByUrl.get(this.currentAppStoreUrl) != null;
    }

    public Set<WebApp> getAllApps() {
        return this.getAllApps(false);
    }

    public Set<WebApp> getAllApps(boolean forceRefresh) {
        if (!this.showMultipleWarnings && this.appManager != null && this.appManager.getAppManagerDialog() != null) {
            this.appManager.getAppManagerDialog().hideNetworkError();
        }
        if (!forceRefresh && this.appsByUrl.get(this.currentAppStoreUrl) != null) {
            return this.appsByUrl.get(this.currentAppStoreUrl);
        }
        DebugHelper.print("Obtaining apps from app store..");
        HashSet<WebApp> result = new HashSet<WebApp>();
        String jsonResult = null;
        try {
            jsonResult = this.query(this.currentAppStoreUrl + "backend/all_apps");
            JSONArray jsonArray = new JSONArray(jsonResult);
            JSONObject jsonObject = null;
            for (int index = 0; index < jsonArray.length(); ++index) {
                jsonObject = jsonArray.getJSONObject(index);
                WebApp webApp = new WebApp();
                String keyName = "fullname";
                if (!jsonObject.has(keyName)) continue;
                webApp.setName(jsonObject.get(keyName).toString());
                webApp.setFullName(jsonObject.get(keyName).toString());
                keyName = "icon_url";
                if (jsonObject.has(keyName)) {
                    webApp.setIconUrl(jsonObject.get(keyName).toString());
                }
                if (jsonObject.has(keyName = "page_url")) {
                    webApp.setPageUrl(this.currentAppStoreUrl.substring(0, this.currentAppStoreUrl.length() - 1) + jsonObject.get(keyName).toString());
                }
                if (jsonObject.has(keyName = "description")) {
                    webApp.setDescription(jsonObject.get(keyName).toString());
                }
                if (jsonObject.has(keyName = "downloads")) {
                    try {
                        webApp.setDownloadCount(Integer.parseInt(jsonObject.get(keyName).toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(keyName = "stars_percentage")) {
                    try {
                        webApp.setStarsPercentage(Integer.parseInt(jsonObject.get(keyName).toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(keyName = "votes")) {
                    try {
                        webApp.setVotes(Integer.parseInt(jsonObject.get(keyName).toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(keyName = "citation")) {
                    webApp.setCitation(jsonObject.get(keyName).toString());
                }
                try {
                    LinkedList<WebApp.Release> releases = new LinkedList<WebApp.Release>();
                    if (jsonObject.has("releases")) {
                        JSONArray jsonReleases = jsonObject.getJSONArray("releases");
                        boolean isCompatible = true;
                        for (int releaseIndex = 0; releaseIndex < jsonReleases.length(); ++releaseIndex) {
                            JSONObject jsonRelease = jsonReleases.getJSONObject(releaseIndex);
                            WebApp.Release release = webApp.new WebApp.Release();
                            release.setBaseUrl(this.currentAppStoreUrl);
                            release.setRelativeUrl(jsonRelease.optString("release_download_url"));
                            release.setReleaseDate(jsonRelease.optString("created_iso"));
                            release.setReleaseVersion(jsonRelease.optString("version"));
                            keyName = "works_with";
                            if (jsonRelease.has(keyName)) {
                                release.setCompatibleCytoscapeVersions(jsonRelease.get(keyName).toString());
                                isCompatible = release.isCompatible((CyVersion)this.serviceRegistrar.getService(CyVersion.class));
                            }
                            if (!isCompatible) continue;
                            releases.add(release);
                        }
                        Collections.sort(releases, Comparator.comparing(WebApp.Release::getReleaseVersion, (a, b) -> -WebQuerier.compareVersions(a, b)));
                    }
                    webApp.setReleases(releases);
                }
                catch (JSONException e) {
                    logger.warn("Error obtaining releases for app: " + webApp.getFullName() + ", " + e.getMessage());
                }
                List<WebApp.Release> compatibleReleases = this.getCompatibleReleases(webApp);
                if (compatibleReleases.size() <= 0) continue;
                this.processAppTags(webApp, jsonObject);
                result.add(webApp);
            }
        }
        catch (IOException e) {
            if (this.appManager != null && this.appManager.getAppManagerDialog() != null) {
                AppManagerDialog dialog = this.appManager.getAppManagerDialog();
                if (this.currentSiteName == null) {
                    dialog.showNetworkError("Cannot access the App Store at: " + this.currentAppStoreUrl);
                } else {
                    dialog.showNetworkError("Cannot access " + this.currentSiteName + " at: " + this.currentAppStoreUrl);
                }
            }
            e.printStackTrace();
            result = new HashSet();
        }
        catch (JSONException e) {
            DebugHelper.print("Error parsing JSON: " + e.getMessage());
            e.printStackTrace();
        }
        this.appsByUrl.put(this.currentAppStoreUrl, result);
        WebApp webAppNoInternet = new WebApp();
        webAppNoInternet.setName("noInternet");
        result.add(webAppNoInternet);
        return result;
    }

    private void processAppTags(WebApp webApp, JSONObject jsonObject) throws JSONException {
        JSONArray appTagObjects = jsonObject.optJSONArray("tags");
        if (appTagObjects == null) {
            return;
        }
        for (int index = 0; index < appTagObjects.length(); ++index) {
            String appTagName = appTagObjects.get(index).toString();
            AppTag appTag = this.appTagsByUrl.get(this.currentAppStoreUrl).get(appTagName);
            if (appTag == null) {
                appTag = new AppTag();
                appTag.setName(appTagName);
                appTag.setFullName(appTagName);
                appTag.setCount(0);
                this.appTagsByUrl.get(this.currentAppStoreUrl).put(appTagName, appTag);
            }
            webApp.getAppTags().add(appTag);
            if (this.appsByTagNameByUrl.get(this.currentAppStoreUrl).get(appTagName) == null) {
                this.appsByTagNameByUrl.get(this.currentAppStoreUrl).put(appTagName, new HashSet());
            }
            this.appsByTagNameByUrl.get(this.currentAppStoreUrl).get(appTagName).add(webApp);
            appTag.setCount(appTag.getCount() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File downloadApp(WebApp webApp, String version, File directory, DownloadStatus status) throws AppDownloadException {
        List<WebApp.Release> compatibleReleases = this.getCompatibleReleases(webApp);
        if (compatibleReleases.size() <= 0) throw new AppDownloadException("No available releases were found for the app " + webApp.getFullName() + ".");
        WebApp.Release releaseToDownload = null;
        if (version != null) {
            for (WebApp.Release compatibleRelease : compatibleReleases) {
                if (!compatibleRelease.getReleaseVersion().matches("(^\\s*|.*,)\\s*" + version + "\\s*(\\s*$|,.*)")) continue;
                releaseToDownload = compatibleRelease;
            }
            if (releaseToDownload == null) {
                throw new AppDownloadException("No release with the requested version " + version + " was found for the requested app " + webApp.getFullName());
            }
        } else {
            releaseToDownload = compatibleReleases.get(compatibleReleases.size() - 1);
        }
        URL downloadUrl = null;
        try {
            downloadUrl = new URL(this.currentAppStoreUrl + releaseToDownload.getRelativeUrl());
        }
        catch (MalformedURLException e) {
            throw new AppDownloadException("Unable to obtain URL for version " + version + " of the release for " + webApp.getFullName());
        }
        if (downloadUrl == null) return null;
        try {
            StreamUtil streamUtil = (StreamUtil)this.serviceRegistrar.getService(StreamUtil.class);
            URLConnection connection = streamUtil.getURLConnection(downloadUrl);
            InputStream inputStream = connection.getInputStream();
            long contentLength = connection.getContentLength();
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);){
                Object outputFileBasename = webApp.getName().replaceAll("\\s", "_");
                outputFileBasename = (String)outputFileBasename + "-v" + releaseToDownload.getReleaseVersion();
                outputFileBasename = OUTPUT_FILENAME_DISALLOWED_CHARACTERS.matcher((CharSequence)outputFileBasename).replaceAll("");
                outputFileBasename = (String)outputFileBasename + ".jar";
                File outputFile = new File(directory.getCanonicalPath() + File.separator + (String)outputFileBasename);
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                outputFile.createNewFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                    long bytesTransferred;
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    long currentDownloadPosition = 0L;
                    TaskMonitor taskMonitor = status.getTaskMonitor();
                    do {
                        bytesTransferred = fileChannel.transferFrom(readableByteChannel, currentDownloadPosition, 16384L);
                        if (status.isCanceled()) {
                            outputFile.delete();
                            File file = null;
                            return file;
                        }
                        currentDownloadPosition += bytesTransferred;
                        if (contentLength <= 0L) continue;
                        double progress = (double)currentDownloadPosition / (double)contentLength;
                        taskMonitor.setProgress(progress);
                    } while (bytesTransferred > 0L);
                    return outputFile;
                }
            }
        }
        catch (IOException e) {
            throw new AppDownloadException("Error while downloading app " + webApp.getFullName() + ", " + e.getMessage());
        }
    }

    private List<WebApp.Release> getCompatibleReleases(WebApp webApp) {
        LinkedList<WebApp.Release> compatibleReleases = new LinkedList<WebApp.Release>();
        for (WebApp.Release release : webApp.getReleases()) {
            if (!release.getCompatibleCytoscapeVersions().matches(COMPATIBLE_RELEASE_REGEX)) continue;
            compatibleReleases.add(release);
        }
        return compatibleReleases;
    }

    public Set<WebApp> getAppsByTag(String tagName) {
        Set<WebApp> webApps = this.getAllApps();
        return this.appsByTagNameByUrl.get(this.currentAppStoreUrl).get(tagName);
    }

    public Set<Update> checkForUpdates(Set<App> apps, AppManager appManager) {
        HashSet<Update> updates = new HashSet<Update>();
        block0: for (App app : apps) {
            for (String url : this.appsByUrl.keySet()) {
                Update update = this.checkForUpdate(app, url, appManager);
                if (update == null) continue;
                updates.add(update);
                continue block0;
            }
        }
        return updates;
    }

    public void checkWebAppInstallStatus(Set<WebApp> webApps, AppManager appManager) {
        for (App app : appManager.getInstalledApps()) {
            for (WebApp webApp : webApps) {
                for (WebApp.Release release : webApp.getReleases()) {
                    if (!WebQuerier.releaseEquals(app, release) || webApp.getCorrespondingApp() != null && !webApp.getCorrespondingApp().isDetached() && WebQuerier.compareVersions(webApp.getCorrespondingApp().getVersion(), app.getVersion()) <= 0) continue;
                    webApp.setCorrespondingApp(app);
                    if (app.getDescription() != null) continue;
                    app.setDescription(webApp.getDescription());
                }
            }
        }
    }

    private static boolean releaseEquals(App app, WebApp.Release release) {
        return app.getAppName().equals(release.getWebApp().getName()) && WebQuerier.compareVersions(app.getVersion(), release.getReleaseVersion()) == 0;
    }

    private Update checkForUpdate(App app, String url, AppManager appManager) {
        Set<WebApp> urlApps = this.appsByUrl.get(url);
        if (urlApps != null) {
            for (WebApp webApp : urlApps) {
                if (!webApp.getName().equalsIgnoreCase(app.getAppName())) continue;
                WebApp.Release highestVersionRelease = null;
                for (WebApp.Release release : webApp.getReleases()) {
                    if (highestVersionRelease != null && WebQuerier.compareVersions(highestVersionRelease.getReleaseVersion(), release.getReleaseVersion()) <= 0) continue;
                    highestVersionRelease = release;
                }
                if (highestVersionRelease == null || WebQuerier.compareVersions(highestVersionRelease.getReleaseVersion(), app.getVersion()) >= 0) continue;
                Update update = new Update();
                update.setUpdateVersion(highestVersionRelease.getReleaseVersion());
                update.setApp(app);
                update.setWebApp(webApp);
                update.setRelease(highestVersionRelease);
                return update;
            }
        }
        return null;
    }

    public static int compareVersions(String version1, String version2) {
        Matcher matcher1 = VERSION_PATTERN.matcher(version1);
        Matcher matcher2 = VERSION_PATTERN.matcher(version2);
        if (!matcher1.matches()) {
            throw new IllegalArgumentException("Incorrectly-formatted version string: " + version1);
        }
        if (!matcher2.matches()) {
            throw new IllegalArgumentException("Incorrectly-formatted version string: " + version2);
        }
        for (int i = 1; i < 8; i += 2) {
            int result;
            String part1 = matcher1.group(i);
            String part2 = matcher2.group(i);
            if (part1 == null && part2 == null) {
                return 0;
            }
            if (i < 7) {
                if (part1 != null && part2 == null) {
                    return Integer.parseInt(part1) == 0 ? 0 : -1;
                }
                if (part1 == null && part2 != null) {
                    return Integer.parseInt(part2) == 0 ? 0 : 1;
                }
                result = Integer.compare(Integer.parseInt(part1), Integer.parseInt(part2));
                if (result == 0) continue;
                return -result;
            }
            if (part1 != null && part2 == null) {
                return -1;
            }
            if (part1 == null && part2 != null) {
                return 1;
            }
            result = part1.compareTo(part2);
            if (result == 0) continue;
            return -result;
        }
        return 0;
    }

    public void findAppDescriptions(Set<App> apps) {
        if (this.appsByUrl.get(DEFAULT_APP_STORE_URL) == null) {
            return;
        }
        HashSet<WebApp> allWebApps = new HashSet<WebApp>(this.appsByUrl.get(DEFAULT_APP_STORE_URL).size());
        for (String url : this.appsByUrl.keySet()) {
            Set<WebApp> urlApps = this.appsByUrl.get(url);
            for (WebApp webApp : urlApps) {
                allWebApps.add(webApp);
            }
        }
        for (WebApp webApp : allWebApps) {
            for (WebApp.Release release : webApp.getReleases()) {
                for (App app : apps) {
                    if (app.getDescription() != null || !WebQuerier.releaseEquals(app, release)) continue;
                    app.setDescription(release.getWebApp().getDescription());
                }
            }
        }
    }

    static {
        DownloadSite site = new DownloadSite("Cytoscape App Store", DEFAULT_APP_STORE_URL);
        DEFAULT_DOWNLOAD_SITES.add(site);
        logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
        VERSION_PATTERN = Pattern.compile("(\\d+)([.](\\d+)([.](\\d+)([.]([-_a-zA-Z0-9]+))?)?)?");
        OUTPUT_FILENAME_DISALLOWED_CHARACTERS = Pattern.compile("[^a-zA-Z0-9.-]");
    }

    public class AppTag {
        private String name;
        private String fullName;
        private int count;

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public int getCount() {
            return this.count;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String toString() {
            return this.fullName + " (" + this.count + ")";
        }
    }
}

