/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.app.internal.util.MiniTest;

class Version {
    private static final int UNDEFINED_INT = -1;
    private static final String UNDEFINED_STRING = null;
    int major = -1;
    int minor = -1;
    int step = -1;
    String modifier = UNDEFINED_STRING;

    public Version(String version) throws Exception {
        if (version != null && (version = version.trim()).length() > 0) {
            String[] parts = AppUtil.dumbSplit(version, '.');
            if (parts.length > 3) {
                throw new Exception("Invalid version " + version);
            }
            if (parts.length > 0) {
                this.major = Integer.valueOf(parts[0]);
                if (parts.length > 1) {
                    String[] stepParts;
                    this.minor = Integer.valueOf(parts[1]);
                    if (parts.length > 2 && (stepParts = AppUtil.dumbSplit(parts[2], '-')).length > 0) {
                        this.step = Integer.valueOf(stepParts[0]);
                        if (stepParts.length > 1) {
                            this.modifier = stepParts[1];
                            if (this.modifier.length() == 0) {
                                throw new Exception("Invalid modifier " + version);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isDefined() {
        return this.major != -1;
    }

    public int compare(Version version) {
        if (this.major == -1 && version.major == -1) {
            return 0;
        }
        if (this.major == -1) {
            return -1;
        }
        if (version.major == -1) {
            return 1;
        }
        if (this.major != version.major) {
            return (this.major - version.major) / Math.abs(this.major - version.major);
        }
        if (this.minor == -1 && version.minor == -1) {
            return 0;
        }
        if (this.minor == -1) {
            return -1;
        }
        if (version.minor == -1) {
            return 1;
        }
        if (this.minor != version.minor) {
            return (this.minor - version.minor) / Math.abs(this.minor - version.minor);
        }
        if (this.step == -1 && version.step == -1) {
            return 0;
        }
        if (this.step == -1) {
            return -1;
        }
        if (version.step == -1) {
            return 1;
        }
        if (this.step != version.step) {
            return (this.step - version.step) / Math.abs(this.step - version.step);
        }
        if (this.modifier == UNDEFINED_STRING && version.modifier == UNDEFINED_STRING) {
            return 0;
        }
        if (this.modifier == UNDEFINED_STRING) {
            return -1;
        }
        if (version.modifier == UNDEFINED_STRING) {
            return 1;
        }
        return this.modifier.compareTo(version.modifier);
    }

    public String toString() {
        Object val = "";
        if (this.major != -1) {
            val = String.valueOf(this.major);
            if (this.minor != -1) {
                val = (String)val + "." + String.valueOf(this.minor);
                if (this.step != -1) {
                    val = (String)val + "." + String.valueOf(this.step);
                    if (this.modifier != UNDEFINED_STRING) {
                        val = (String)val + "-" + this.modifier;
                    }
                }
            }
        }
        return val;
    }

    public static void main(String[] args) {
        System.out.println("Tester for class Version");
        try {
            MiniTest.eq(new Version(null).toString(), "");
            MiniTest.eq(new Version("").toString(), "");
            MiniTest.eq(new Version("1").toString(), "1");
            MiniTest.eq(new Version("1.2").toString(), "1.2");
            MiniTest.eq(new Version("1.2.3").toString(), "1.2.3");
            MiniTest.eq(new Version("1.2.3-alpha").toString(), "1.2.3-alpha");
            MiniTest.isTrue(new Version("1").compare(new Version("1")) == 0, "1 == 1");
            MiniTest.isTrue(new Version("1.2").compare(new Version("1.2")) == 0, "1.2 == 1.2");
            MiniTest.isTrue(new Version("1.2.3").compare(new Version("1.2.3")) == 0, "1.2.3 == 1.2.3");
            MiniTest.isTrue(new Version("1.2.3-alpha").compare(new Version("1.2.3-alpha")) == 0, "1.2.3-alpha == 1.2.3-alpha");
            MiniTest.isTrue(new Version("1").compare(new Version("2")) < 0, "1 < 2");
            MiniTest.isTrue(new Version("2").compare(new Version("1")) > 0, "2 > 1");
            MiniTest.isTrue(new Version("1.1").compare(new Version("1.2")) < 0, "1.1 < 1.2");
            MiniTest.isTrue(new Version("1.2").compare(new Version("1.1")) > 0, "1.2 > 1.1");
            MiniTest.isTrue(new Version("1.1.1").compare(new Version("1.1.2")) < 0, "1.1.1 < 1.1.2");
            MiniTest.isTrue(new Version("1.1.2").compare(new Version("1.1.1")) > 0, "1.1.2 > 1.1.1");
            MiniTest.isTrue(new Version("1.1.1-alpha").compare(new Version("1.1.1-beta")) < 0, "1.1.1-alpha < 1.1.2-beta");
            MiniTest.isTrue(new Version("1.1.1-beta").compare(new Version("1.1.1-alpha")) > 0, "1.1.1-beta > 1.1.1-alpha");
            MiniTest.isTrue(new Version("1").compare(new Version("1.2")) < 0, "1 < 1.2");
            MiniTest.isTrue(new Version("1.2").compare(new Version("1")) > 0, "1.2 > 1");
            MiniTest.isTrue(new Version("1.2").compare(new Version("1.2.3")) < 0, "1.2 < 1.2.3");
            MiniTest.isTrue(new Version("1.2.3").compare(new Version("1.2")) > 0, "1.2.3 > 1.2");
            MiniTest.isTrue(new Version("1.2.3").compare(new Version("1.2.3-alpha")) < 0, "1.2.3 < 1.2.3-alpha");
            MiniTest.isTrue(new Version("1.2.3-alpha").compare(new Version("1.2.3")) > 0, "1.2.3-alpha > 1.2.3");
        }
        catch (Throwable t) {
            System.out.println("Should not have seen exception " + t);
        }
        try {
            new Version("a");
            System.out.println("a exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("a exception test PASSED");
        }
        try {
            new Version(".");
            System.out.println(". exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println(". exception test PASSED");
        }
        try {
            new Version("1.");
            System.out.println("1. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1. exception test PASSED");
        }
        try {
            new Version("1..");
            System.out.println("1.. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.. exception test PASSED");
        }
        try {
            new Version("1.a.");
            System.out.println("1.a. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.a. exception test PASSED");
        }
        try {
            new Version("1.2.");
            System.out.println("1.2. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2. exception test PASSED");
        }
        try {
            new Version("1.2..");
            System.out.println("1.2.. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2.. exception test PASSED");
        }
        try {
            new Version("1.2.a.");
            System.out.println("1.2.a. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2.a. exception test PASSED");
        }
        try {
            new Version("1.2.3.");
            System.out.println("1.2.3. exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2.3. exception test PASSED");
        }
        try {
            new Version("1.2.3-");
            System.out.println("1.2.3- exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2.3- exception test PASSED");
        }
        try {
            new Version("1.2.3+alpha");
            System.out.println("1.2.3+alpha exception test FAILED");
        }
        catch (Throwable t) {
            System.out.println("1.2.3+alpha exception test PASSED");
        }
    }
}

