/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;

public class AppDependencyNode {
    private Set<AppDependencyNode> dependencies = new HashSet<AppDependencyNode>();
    private Set<AppDependencyNode> parents = new HashSet<AppDependencyNode>();
    private String currentAppName;
    private String currentAppVersion;

    public AppDependencyNode(String appName, String appVersion) {
        this.currentAppName = appName;
        this.currentAppVersion = appVersion;
    }

    public String getNodeAppName() {
        return this.currentAppName;
    }

    public String getNodeAppVersion() {
        return this.currentAppVersion;
    }

    public Set<AppDependencyNode> getDependencies() {
        return this.dependencies;
    }

    public Set<AppDependencyNode> getParents() {
        return this.parents;
    }

    public void addDependency(AppDependencyNode dependency) {
        this.dependencies.add(dependency);
    }

    public void addParent(AppDependencyNode parent) {
        this.parents.add(parent);
    }

    public List<String> getMissingDependencies(AppManager appManager) {
        HashMap<CallSite, App> currentApps = new HashMap<CallSite, App>();
        for (App app : appManager.getApps()) {
            currentApps.put((CallSite)((Object)(app.getAppName() + " " + app.getVersion())), app);
        }
        LinkedList<AppDependencyNode> dependenciesToCheck = new LinkedList<AppDependencyNode>();
        for (AppDependencyNode node : this.dependencies) {
            dependenciesToCheck.add(node);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        while (!dependenciesToCheck.isEmpty()) {
            AppDependencyNode current = (AppDependencyNode)dependenciesToCheck.remove();
            if (current.getDependencies().size() != 0) {
                for (AppDependencyNode node : current.getDependencies()) {
                    dependenciesToCheck.add(node);
                }
                continue;
            }
            String keyName = current.getNodeAppName() + " " + current.getNodeAppVersion();
            if (currentApps.get(keyName) != null && ((App)currentApps.get(keyName)).getStatus() == App.AppStatus.INSTALLED) continue;
            linkedList.add(keyName);
        }
        return linkedList;
    }
}

