/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.zoom;

import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.undo.AbstractCyEdit;

final class FitContentEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private final double networkScaleFactor;
    private final double networkCenterXLocation;
    private final double networkCenterYLocation;

    FitContentEdit(String description, CyNetworkView view) {
        super(description);
        this.view = view;
        this.networkScaleFactor = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.networkCenterXLocation = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        this.networkCenterYLocation = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
    }

    public void redo() {
        this.view.fitContent();
        this.view.updateView();
    }

    public void undo() {
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)this.networkScaleFactor);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)this.networkCenterXLocation);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)this.networkCenterYLocation);
        this.view.updateView();
    }
}

